/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.views.profile.ProfileView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateCredentials {
    static String cacopyright = "Copyright (c) 2016 CA";
    private String userId;
    private String ePassword;
    private TTServer server;
    private Dataset[] datasets = new Dataset[0];
    private String errorMessage;
    private int errorLevel;
    private int errorCount;
    private ArrayList<Element> errorElements = new ArrayList();
    private String errorCause;
    private static final String SERVICE = "testingtools/validate";

    public ValidateCredentials(TTServer server) {
        this.server = server;
        this.userId = server.getUser();
        this.ePassword = server.getEPassword();
    }

    public ValidateCredentials(TTServer server, Dataset[] datasets) {
        this(server);
        this.datasets = datasets;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Dataset[] datasets) {
        this.datasets = datasets;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int run(boolean credentials) {
        this.errorElements.clear();
        ServerConnect connect = new ServerConnect(this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>(2 + this.datasets.length);
        this.errorCount = 0;
        if (credentials) {
            map.put("user", this.userId);
            map.put("epassw", this.ePassword);
        }
        if (this.datasets.length > 0) {
            map.put("dsn", this.datasets);
        }
        Dataset[] datasetArray = this.datasets;
        int n = this.datasets.length;
        int n2 = 0;
        while (n2 < n) {
            Dataset dsn = datasetArray[n2];
            if (dsn != null) {
                dsn.setFileNotfound(false);
            }
            ++n2;
        }
        try {
            this.errorCause = "";
            XMLRequest xml = connect.connect("check", (Map<String, Object>)map, false);
            Element command = xml.getCommand();
            Dataset[] datasetArray2 = this.datasets;
            int n3 = this.datasets.length;
            int n4 = 0;
            while (n4 < n3) {
                Dataset dsn = datasetArray2[n4];
                if (dsn != null) {
                    dsn.setFileNotfound(false);
                }
                ++n4;
            }
            if (credentials) {
                this.checkError(command.getElementsByTagName("Signon"), false);
            }
            this.checkError(command.getElementsByTagName("DSN"), true);
        }
        catch (Exception e) {
            this.errorLevel = credentials ? -1 : 32;
            this.errorMessage = HexUtil.getErrorText((Throwable)e);
            this.errorCause = "Error attempting to connect to server";
        }
        return this.errorLevel;
    }

    public int run(boolean credentials, String datasetName) {
        this.errorElements.clear();
        ServerConnect connect = new ServerConnect(this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>(3);
        this.errorCount = 0;
        if (credentials) {
            map.put("user", this.userId);
            map.put("epassw", this.ePassword);
        }
        if (datasetName.length() > 0) {
            map.put("dsn", datasetName);
        }
        try {
            this.errorCause = "";
            XMLRequest xml = connect.connect("check", map, false);
            Element command = xml.getCommand();
            if (credentials) {
                this.checkError(command.getElementsByTagName("Signon"), false);
            }
            this.checkError(command.getElementsByTagName("DSN"), true);
        }
        catch (Exception e) {
            this.errorLevel = credentials ? -1 : 32;
            this.errorMessage = HexUtil.getErrorText((Throwable)e);
            this.errorCause = "Error attempting to connect to server";
        }
        return this.errorLevel;
    }

    private void checkError(NodeList elements, boolean isDSN) {
        int index = 0;
        while (index < elements.getLength()) {
            Element element = (Element)elements.item(index);
            String value = element.getAttribute("errorlevel");
            int error = 0;
            try {
                error = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            if (error > 0) {
                if (error > this.errorLevel) {
                    this.errorLevel = error;
                    this.errorMessage = element.getAttribute("msg");
                }
                this.errorElements.add(element);
                if (isDSN) {
                    String name = element.getAttribute("name");
                    Dataset[] datasetArray = this.datasets;
                    int n = this.datasets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Dataset dataset = datasetArray[n2];
                        if (dataset != null && name.equals(dataset.getName())) {
                            CheckboxTreeViewer viewer;
                            dataset.setFileNotfound(true);
                            dataset.setList(new ArrayList<Object>(0));
                            dataset.getParent().setChecked(false);
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            IViewPart view = page.findView("com.ca.testingtools.ui.views.profileview");
                            if (view instanceof ProfileView && (viewer = ((ProfileView)view).getViewer()) != null) {
                                TT_TreeItem selection = ServerTreeModel.getInstance().findObject(dataset);
                                viewer.refresh((Object)selection, true);
                                viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++index;
        }
    }

    public ValidateCredentials(TTServer server, String userId, String password) {
        this(server);
        this.userId = userId;
        this.ePassword = password;
    }

    public void setServer(TTServer server) {
        this.server = server;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ArrayList<Element> getErrorElements() {
        return this.errorElements;
    }

    public String getErrorCause() {
        return this.errorCause;
    }
}

