/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;
/**
 * @author mahma04
 *
 */

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.view.wizardpages.MemberWizardPage;


public class MemberWizard extends Wizard implements INewWizard {
	
	private MemberWizardPage memberWizardpage;
	private FileMasterServer  server;
	private GUIResponseType response;
	private String DbdName;
	private String title;
	private String memberLabel;
	private String CONTEXT_HELP_ID;
	
	public MemberWizard(String title, String memberLabel, String DbdName, GUIResponseType response, FileMasterServer server, String CONTEXT_HELP_ID){
		this.response=response;
		this.server=server;
		this.DbdName=DbdName;
		this.title=title;
		this.memberLabel=memberLabel; 
		this.CONTEXT_HELP_ID = CONTEXT_HELP_ID;
		setWindowTitle(title);
	}
	
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean performFinish() {
		memberWizardpage.doFinish();
		return true;
	}
	public void addPages() {
		TrayDialog.setDialogHelpAvailable(true);

		memberWizardpage = new MemberWizardPage(title, memberLabel, response, server, DbdName, CONTEXT_HELP_ID);

		addPage(memberWizardpage);
	}

}
