/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.widgets.ExploreEditDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractCellEditor
extends TextCellEditor {
    private ColumnModel columnModel;
    private ObjectIdentity identity;
    boolean validCharacterEntered = true;
    private InputDialog dialog = null;
    private boolean keyValidationsExecuted;

    public AbstractCellEditor(Composite parent, ObjectIdentity identity, ColumnModel model) {
        super(parent);
        this.setIdentity(identity);
        this.setColumnModel(model);
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return AbstractCellEditor.this.validate(value);
            }
        });
    }

    private void setIdentity(ObjectIdentity identity) {
        this.identity = identity;
    }

    public abstract boolean onKeyPressValidation(KeyEvent var1);

    public abstract String validate(Object var1);

    public abstract Object formatValue(Object var1);

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        this.validCharacterEntered = true;
        if (this.specialKeys(keyEvent) || this.arrowKeys(keyEvent)) {
            this.keyValidationsExecuted = false;
        } else {
            this.validCharacterEntered = this.onKeyPressValidation(keyEvent);
            this.keyValidationsExecuted = true;
        }
        super.keyReleaseOccured(keyEvent);
    }

    private boolean specialKeys(KeyEvent e) {
        return this.specialKeysByKeyChar(e) || this.specialKeysByKeyCode(e);
    }

    private boolean specialKeysByKeyChar(KeyEvent e) {
        switch (e.character) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\r': 
            case '\u001b': 
            case '\u007f': {
                return true;
            }
        }
        return false;
    }

    private boolean specialKeysByKeyCode(KeyEvent e) {
        switch (e.keyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: {
                return true;
            }
        }
        return false;
    }

    private boolean arrowKeys(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected void doSetValue(Object value) {
        String s;
        String string = value instanceof String ? (String)value : (s = value != null ? value.toString() : "");
        if (s != null) {
            super.doSetValue((Object)s);
        }
    }

    public void setColumnModel(ColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    public ColumnModel getColumnModel() {
        return this.columnModel;
    }

    protected void valueChanged(boolean oldValidState, boolean newValidState) {
        super.valueChanged(oldValidState, newValidState);
        if (!newValidState && (!this.keyValidationsExecuted || this.keyValidationsExecuted && !this.validCharacterEntered)) {
            this.dialog = new ExploreEditDialog(this.identity, this.columnModel, this.text.getText(), true);
            this.dialog.open();
        }
    }

    public void postExplodeEdit() {
        if (this.dialog != null) {
            this.dialog.close();
            this.dialog = null;
        }
    }
}

