/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.i18n.DWBundle;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DateTimeUtil {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static final String ISO_EUR_TIME_PATTERN = "HH.mm.ss";
    public static final String USA_TIME_PATTERN = "hh:mm a";
    public static final String JIS_TIME_PATTERN = "HH:mm:ss";
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    public static final String USA_DATE_PATTERN = "MM/dd/yyyy";
    public static final String EUR_DATE_PATTERN = "dd.MM.yyyy";
    public static final String JIS_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO_TIMESTAMP_PATTERN = "yyyy-MM-dd-HH.mm.ss";
    public static final String USA_TIMESTAMP_PATTERN = "MM/dd/yyyy-hh:mm a";
    public static final String EUR_TIMESTAMP_PATTERN = "dd.MM.yyyy-HH.mm.ss";
    public static final String JIS_TIMESTAMP_PATTERN = "yyyy-MM-dd-HH.mm.ss";
    public static final String ISO_DATE_REGEX = "[\\d]{4}[-][\\d]{2}[-][\\d]{2}";
    public static final String USA_DATE_REGEX = "[\\d]{2}[/][\\d]{2}[/][\\d]{4}";
    public static final String EUR_DATE_REGEX = "[\\d]{2}[.][\\d]{2}[.][\\d]{4}";
    public static final String IND_DATE_REGEX = "[\\d]{2}[-][\\d]{2}[-][\\d]{4}";
    public static final String ISO_DATE_FORMAT_REGEX = "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})";
    public static final String USA_DATE_FORMAT_REGEX = "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})";
    public static final String EUR_DATE_FORMAT_REGEX = "([0-9]{1,2})[.]([0-9]{1,2})[.]([0-9]{4})";
    public static final String JIS_DATE_FORMAT_REGEX = "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})";
    public static final Pattern ISO_DATE_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})");
    public static final Pattern USA_DATE_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})");
    public static final Pattern EUR_DATE_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{1,2})[.]([0-9]{1,2})[.]([0-9]{4})");
    private static final SimpleDateFormat ISO_SDF = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat USA_SDF = new SimpleDateFormat("MM/dd/yyyy");
    private static final SimpleDateFormat EUR_SDF = new SimpleDateFormat("dd.MM.yyyy");
    private static final SimpleDateFormat JIS_SDF = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat();
    public static final String ISO_TIME_PATTERN_MSG = "hh.mm[.ss]";
    public static final String USA_TIME_PATTERN_MSG = "hh[:mm] AM or PM";
    public static final String EUR_TIME_PATTERN_MSG = "hh.mm[.ss]";
    public static final String JIS_TIME_PATTERN_MSG = "hh:mm[:ss]";
    public static final String ISO_TIME_FORMAT_REGEX = "([0-9]{1,2})[.]([0-9]{2})([.]([0-9]{2}))?";
    public static final String USA_TIME_FORMAT_REGEX = "([0-9]{1,2})(:([0-9]{2}))?( )(AM|am|aM|Am|PM|pm|pM|Pm)";
    public static final String EUR_TIME_FORMAT_REGEX = "([0-9]{1,2})[.]([0-9]{2})([.]([0-9]{2}))?";
    public static final String JIS_TIME_FORMAT_REGEX = "([0-9]{1,2}):([0-9]{2})(:([0-9]{2}))?";
    public static final Pattern ISO_TIME_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{1,2})[.]([0-9]{2})([.]([0-9]{2}))?");
    public static final Pattern USA_TIME_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{1,2})(:([0-9]{2}))?( )(AM|am|aM|Am|PM|pm|pM|Pm)");
    public static final Pattern JIS_TIME_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{1,2}):([0-9]{2})(:([0-9]{2}))?");
    private static final SimpleDateFormat GMT_ISO_TIME_SDF = new SimpleDateFormat("HH.mm.ss");

    static {
        ISO_SDF.setLenient(false);
        USA_SDF.setLenient(false);
        EUR_SDF.setLenient(false);
        JIS_SDF.setLenient(false);
        GMT_ISO_TIME_SDF.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
    }

    public static String getSystemDate(String format) {
        return DateTimeUtil.getSimpleDateFormat(format).format(new Date());
    }

    public static String getSystemTimestamp(String format, short scale) {
        String timestampPattern = DateTimeUtil.getTimestampPattern(format, scale, false);
        dateFormat.applyPattern(timestampPattern.toString());
        StringBuffer timestamp = new StringBuffer(dateFormat.format(new Date()));
        if (scale == 1 || scale == 2) {
            int padIndex = timestampPattern.length();
            timestamp.delete(padIndex, padIndex + (3 - scale));
        }
        return timestamp.toString();
    }

    private static String getTimestampPattern(String format, short scale, boolean isWithTZ) {
        format = "ISO";
        StringBuffer timestampPattern = new StringBuffer(DateTimeUtil.getDatePattern(format));
        timestampPattern.append("-");
        timestampPattern.append(DateTimeUtil.getSystemTime(format));
        if (scale > 0) {
            timestampPattern.append(".");
        }
        int i = 0;
        while (i < scale) {
            timestampPattern.append("S");
            ++i;
        }
        if (isWithTZ) {
            timestampPattern.append("Z");
        }
        return timestampPattern.toString();
    }

    public static String getSystemTimestampTZ(String format, short scale) {
        String timestampTZPattern = DateTimeUtil.getTimestampPattern(format, scale, true);
        dateFormat.applyPattern(timestampTZPattern);
        StringBuffer timestz = new StringBuffer(dateFormat.format(new Date()));
        if (scale == 1 || scale == 2) {
            int padIndex = timestampTZPattern.length() - 1;
            timestz.delete(padIndex, padIndex + (3 - scale));
        }
        timestz.insert(timestz.length() - 2, ":");
        return timestz.toString();
    }

    public static String getSystemTime(String format) {
        if (DateTimeUtil.isISOformat(format) || DateTimeUtil.isEURformat(format)) {
            format = ISO_EUR_TIME_PATTERN;
        } else if (DateTimeUtil.isUSAformat(format)) {
            format = USA_TIME_PATTERN;
        } else if (DateTimeUtil.isJISformat(format)) {
            format = JIS_TIME_PATTERN;
        }
        dateFormat.applyPattern(format);
        return dateFormat.format(new Date());
    }

    public static String getTimePattern(String format) {
        if (DateTimeUtil.isISOformat(format) || DateTimeUtil.isEURformat(format)) {
            format = ISO_EUR_TIME_PATTERN;
        } else if (DateTimeUtil.isUSAformat(format)) {
            format = USA_TIME_PATTERN;
        } else if (DateTimeUtil.isJISformat(format)) {
            format = JIS_TIME_PATTERN;
        }
        return format;
    }

    public static Timestamp getCurrentTimestamp() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return timestamp;
    }

    public static String DB2ToJavaTimestamp(String timestamp) {
        StringBuilder builder = new StringBuilder(timestamp);
        builder.replace(10, 11, " ");
        builder.replace(13, 14, ":");
        builder.replace(16, 17, ":");
        return builder.toString();
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        if (DateTimeUtil.isISOformat(format)) {
            return ISO_SDF;
        }
        if (DateTimeUtil.isUSAformat(format)) {
            return USA_SDF;
        }
        if (DateTimeUtil.isJISformat(format)) {
            return JIS_SDF;
        }
        if (DateTimeUtil.isEURformat(format)) {
            return EUR_SDF;
        }
        return ISO_SDF;
    }

    public static String getDatePattern(String format) {
        if (DateTimeUtil.isISOformat(format)) {
            return "yyyy-MM-dd";
        }
        if (DateTimeUtil.isUSAformat(format)) {
            return USA_DATE_PATTERN;
        }
        if (DateTimeUtil.isJISformat(format)) {
            return "yyyy-MM-dd";
        }
        if (DateTimeUtil.isEURformat(format)) {
            return EUR_DATE_PATTERN;
        }
        return null;
    }

    public static Date getDate(String format, String value) throws ParseException {
        return DateTimeUtil.getSimpleDateFormat(format).parse(value);
    }

    public static boolean isISOformat(String format) {
        return "ISO".equals(format);
    }

    public static boolean isUSAformat(String format) {
        return "USA".equals(format);
    }

    public static boolean isJISformat(String format) {
        return "JIS".equals(format);
    }

    public static boolean isEURformat(String format) {
        return "EUR".equals(format);
    }

    public static Pattern getDatePatternInstance(String format) {
        if (DateTimeUtil.isISOformat(format) || DateTimeUtil.isJISformat(format)) {
            return ISO_DATE_FORMAT_PATTERN_INSTANCE;
        }
        if (DateTimeUtil.isUSAformat(format)) {
            return USA_DATE_FORMAT_PATTERN_INSTANCE;
        }
        return EUR_DATE_FORMAT_PATTERN_INSTANCE;
    }

    public static Pattern getTimePatternInstance(String format) {
        if (DateTimeUtil.isISOformat(format) || DateTimeUtil.isEURformat(format)) {
            return ISO_TIME_FORMAT_PATTERN_INSTANCE;
        }
        if (DateTimeUtil.isUSAformat(format)) {
            return USA_TIME_FORMAT_PATTERN_INSTANCE;
        }
        return JIS_TIME_FORMAT_PATTERN_INSTANCE;
    }

    public static String getTimePatternMsg(String format) {
        if (DateTimeUtil.isISOformat(format) || DateTimeUtil.isEURformat(format)) {
            return "hh.mm[.ss]";
        }
        if (DateTimeUtil.isUSAformat(format)) {
            return USA_TIME_PATTERN_MSG;
        }
        if (DateTimeUtil.isJISformat(format)) {
            return JIS_TIME_PATTERN_MSG;
        }
        return null;
    }

    public static String validateRangesForDate(int year, int month, int day) {
        boolean leapYear;
        if (1 > year || year > 9999) {
            return DWBundle.bind((String)DWBundle.ERR_INVALID_YEAR, (Object)"0001", (Object)9999);
        }
        if (1 > month || month > 12) {
            return DWBundle.bind((String)DWBundle.ERR_INVALID_MONTH, (Object)1, (Object)12);
        }
        boolean bl = leapYear = year % 4 == 0;
        if (leapYear) {
            if (month == 2) {
                return 1 > day || day > 29 ? DWBundle.bind((String)DWBundle.ERR_INVALID_DAY, (Object)1, (Object)29) : null;
            }
        } else if (month == 2) {
            return 1 > day || day > 28 ? DWBundle.bind((String)DWBundle.ERR_INVALID_DAY, (Object)1, (Object)28) : null;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 1 > day || day > 30 ? DWBundle.bind((String)DWBundle.ERR_INVALID_DAY, (Object)1, (Object)30) : null;
        }
        return 1 > day || day > 31 ? DWBundle.bind((String)DWBundle.ERR_INVALID_DAY, (Object)1, (Object)31) : null;
    }

    public static String validateRangesForTime(boolean isNoonFormat, int hours, int minutes, int seconds) {
        if (isNoonFormat) {
            if (hours < 0 || hours > 12) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_HOUR, (Object)0, (Object)12);
            }
            if (minutes < 0 || minutes > 59) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_MINUTE, (Object)"00", (Object)59);
            }
        } else {
            if (hours < 0 || hours > 24) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_HOUR, (Object)0, (Object)24);
            }
            if (hours == 24 && (minutes != 0 || seconds != 0)) {
                return DWBundle.ERR_INVALID_MINS_SECS;
            }
            if (minutes < 0 || minutes > 59) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_MINUTE, (Object)"00", (Object)59);
            }
            if (seconds < 0 || seconds > 59) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_SECOND, (Object)"00", (Object)59);
            }
        }
        return null;
    }

    public static Object convertToUTC(int colType, short scale, Object o) {
        if (o != null) {
            if (92 == colType) {
                return GMT_ISO_TIME_SDF.format(o);
            }
            if (93 == colType) {
                StringBuffer timestampPattern = new StringBuffer("yyyy-MM-dd-HH.mm.ss");
                if (scale > 0) {
                    timestampPattern.append(".S");
                }
                SimpleDateFormat GMT_ISO_TIMESTAMP_SDF = new SimpleDateFormat(timestampPattern.toString());
                GMT_ISO_TIMESTAMP_SDF.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
                String s = GMT_ISO_TIMESTAMP_SDF.format(o);
                return s;
            }
        }
        return null;
    }
}

