/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.GenericAddPage;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.common.FileMasterSelection;
import com.ca.filemaster.dsnlists.view.DSNListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

/**
 * @author galpe02
 * 
 */
public class AddDSNListWizardPage extends GenericAddPage implements
		ModifyListener, ICheckStateListener {
	protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.addDSNListMemPage"; //$NON-NLS-1$
	public FMDSNListTreeModel fmDSNListModel = FMDSNListTreeModel
			.getInstance();
	private String initDSName;
	private String memberName;

	public AddDSNListWizardPage(String pageName, FileMasterServer server,
			String datasetName, String memberName, boolean isDirectoryListCaller) {

		super(pageName, server, datasetName, memberName, isDirectoryListCaller);
		this.initDSName = datasetName;
		this.memberName = memberName;
		this.server = server;
		setTitle("Add DSN List");
	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);

		FMHistory.intializeComboBoxes(dataSetCombo, "DatasetListAddDSNList");
		FMHistory
				.intializeComboBoxes(memberNameCombo, "MemberListAddDSNList");
		if (serverNameCombo.getItemCount() > 0) {
			boolean lastServerExists = false;
			String lastServerUsed = FMHistory
					.getServer("ServerAddDSNListWizardPage");
			for (int count = 0; count < serverNameCombo.getItemCount(); count++) {
				if (serverNameCombo.getItem(count).toString()
						.equalsIgnoreCase(lastServerUsed)) {
					lastServerExists = true;
					serverNameCombo.setText(serverNameCombo.getItem(count)
							.toString());

					break;
				}
			}
			if (!lastServerExists)
				serverNameCombo.setText(serverNameCombo.getItem(0));
		}
		dataSetCombo.setText(initDSName);
		checkboxTableViewer.addCheckStateListener(this);

	}

	@Override
	public void modifyText(ModifyEvent e) {
		// TODO Auto-generated method stub
		setPageComplete(canFinish());
	}

	@Override
	public void checkStateChanged(CheckStateChangedEvent event) {
		if (checkboxTableViewer.getCheckedElements().length >= 1) {
			selectAllClearButton.setText("&Clear Selections");
		} else {
			selectAllClearButton.setText("Select &All");
		}
		if (checkboxTableViewer.getCheckedElements().length == 0) {
			selectAllClearButton.setText("Select &All");
		}

		setPageComplete(canFinish());
	}

	public XMLRequest getDSNListMem() {
		XMLRequest xml = new XMLRequest();
		xml.setCommand("AddSelection");
		Element element = xml.getCommand();
		Element dsnlistElement1 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement1.setAttribute("name", "APM.TUN42.LST");
		Element dsnlistElement2 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement2.setAttribute("name", "CDE.TEMP.PROTSYM.DATA");		
		Element dsnlistElement3 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement3.setAttribute("name", "APM.IPC.R11.ADROUT");
		Element dsnlistElement4 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement4.setAttribute("name", "AD1QA.SYMDUM85.BASETEST.PROTSYM.DATA");			
		element.appendChild(dsnlistElement1);
		element.appendChild(dsnlistElement2);
		element.appendChild(dsnlistElement3);
		element.appendChild(dsnlistElement4);		
		return xml;

	}

	public XMLRequest getDSNListData() {
		XMLRequest xml = new XMLRequest();
		xml.setCommand("AddSelection");
		Element element = xml.getCommand();
		Element dsnlistElement1 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement1.setAttribute("name", "APM.TUN42.LST");
		Element dsnlistElement2 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement2.setAttribute("name", "CDE.TEMP.PROTSYM.DATA");
		Element dsnlistElement3 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement3.setAttribute("name", "APM.IPC.R11.ADROUT");
		Element dsnlistElement4 = xml.createElement(FMXMLProfile.SELECTNODE);
		dsnlistElement4.setAttribute("name", "AD1QA.SYMDUM85.BASETEST.PROTSYM.DATA");
		element.appendChild(dsnlistElement1);
		element.appendChild(dsnlistElement2);
		element.appendChild(dsnlistElement3);
		element.appendChild(dsnlistElement4);
		return xml;

	}

	public Object[] process(String selectParm) {
		XMLRequest xml = null;
		if (selectParm.equals("SELCRT1"))
			xml = getDSNListMem();
		else
			xml = getDSNListData();
		if (xml != null) {
			Element element = xml.getCommand();
			NodeList nodes = element
					.getElementsByTagName(FMXMLProfile.SELECTNODE);
			if (nodes.getLength() == 0) {
				TT_ErrorDialog
						.openError(
								null,
								"DSN List Error",
								"DSN List Member does not exist.",
								new Throwable(
										"DSN List name mispelled\nDSN List not defined\nMainframe communication error"));
			} else {
				ArrayList<Object> fmSelectionList = new ArrayList<Object>();
				for (int i = 0; i < nodes.getLength(); i++) {
					Element selectionElement = (Element) nodes.item(i);
					FileMasterSelection selection = new FileMasterSelection(
							null);
					selection.setName(selectionElement.getAttribute("name"));
					fmSelectionList.add(selection);
				}
				return fmSelectionList.toArray(new Object[fmSelectionList
						.size()]);
			}
		}
		return null;
	}

	@Override
	public boolean nextOrFinish() {
		error = "";
		boolean returnVal = false;

		returnVal = super.isPageComplete();

		if (dataSetCombo != null && memberSelectBtn != null) {
			switch (Validator.dataset(dataSetCombo.getText(), true)) {
			case Validator.NO_ERROR:
				memberSelectBtn.setEnabled(true);
				break;
			default:
				memberSelectBtn.setEnabled(false);
				break;
			}
		}

		if (returnVal)
			returnVal = ValidateMember();

		if (dataSetCombo != null && memberNameCombo != null
				&& checkboxTableViewer != null) {
			dataSetName = dataSetCombo.getText().trim();
			if (returnVal) {
				if (dataSetName.startsWith("\"")) {
					dataSetName = dataSetName.substring(1,
							dataSetName.length() - 1);
				}
			}
			if (this.getName().equalsIgnoreCase("Add Selection")) {
				if (checkboxTableViewer.getCheckedElements().length == 0) {
					memberName = memberNameCombo.getText().trim();
					/* Create The Dataset object */
					FileMasterDataset fmdataset = new FileMasterDataset(null);
					fmdataset.setName(dataSetName);
					fmdataset.setDsOrg("PDS");
					TT_TreeItem dsItem = null;
					if ((dsItem = fmDSNListModel.findObject(fmdataset)) != null) {
						/* Create The Member object */
						FileMasterMember fmmember = new FileMasterMember(dsItem);
						fmmember.setName(memberName);
					}
				} else {
					for (int count = 0; count < checkboxTableViewer
							.getCheckedElements().length; count++) {
						memberName = ((FileMasterMember) checkboxTableViewer
								.getCheckedElements()[count]).getName();

						/* Create The Dataset object */
						FileMasterDataset fmdataset = new FileMasterDataset(
								null);
						fmdataset.setName(dataSetName);
						fmdataset.setDsOrg("PDS");
						TT_TreeItem dsItem = null;
						if ((dsItem = fmDSNListModel.findObject(fmdataset)) != null) {
							/* Create The Member object */
							FileMasterMember fmmember = new FileMasterMember(
									dsItem);
							fmmember.setName(memberName);
						}
					}
				}
			}
		}
		return returnVal;
	}

	private void AddMemberToDSNView(TT_TreeItem dsItem,
			FileMasterMember fmmember, int count, Object[] checkedLayouts,
			Object[] checkedLayoutMembers) {
		Element memElement = fmDSNListModel.addMember(dsItem.getElement(),
				fmmember.getName(), fmmember.getType(),
				"DSN List Member");
		TT_TreeItem memItem = fmDSNListModel.insertMember(dsItem, memElement);
		memItem.getElement().setAttribute("description",
				"DSN List Member");
		checkedLayouts = process(((FileMasterMember) checkedLayoutMembers[count])
				.getName());
		/* Create Selection object */
		FileMasterSelection fmSelect = null;
		Element fmSelectElement = null;
		for (int countLay = 0; countLay < checkedLayouts.length; countLay++) {
			/* Create Layout object */
			if (checkedLayouts[countLay] instanceof FileMasterSelection) {
				fmSelect = new FileMasterSelection(null);
				fmSelect.setName(((FileMasterSelection) checkedLayouts[countLay])
						.getName());
				fmSelectElement = fmDSNListModel.addDSName(memElement,
						fmSelect.getName());
				fmDSNListModel.insertDSName(memItem, fmSelectElement);

			}

		}

	}

	public boolean doFinish() {

		FMHistory.clearList("ServerAddDSNListWizardPage");
		FMHistory.insertHistory(serverNameCombo, "ServerAddDSNListWizardPage");
		FMHistory.insertHistory(dataSetCombo, "DatasetListAddDSNList");
		FMHistory.insertHistory(memberNameCombo, "MemberListAddDSNList");

		Object[] checkedLayoutMembers = (Object[]) checkboxTableViewer
				.getCheckedElements();
		Object[] checkedLayouts = null;
		boolean isDuplicatedMember = false;
		boolean yesToAll = false;
		boolean noToAll = false;
		boolean singelYes = false;
		final String title = "Replace Members";
		String question = "Do you want to replace ";
		/* Create The Dataset object */
		//FileMasterDataset fmdataset = new FileMasterDataset(null);
		//fmdataset.setName(dataSetCombo.getText());

		//fmdataset.setDsOrg("PDS");
		TT_TreeItem dsItem = null;
		
		fmdataset = new FileMasterDataset(null);
		fmdataset.setName(dataSetCombo.getText());
		fmdataset.setDsOrg("PDS");

		if ((dsItem = fmDSNListModel.findObject(fmdataset)) == null) {
			Element dsElement = fmDSNListModel.addDataset(null,fmdataset);
			dsItem = fmDSNListModel.insertDataset(dsElement);
		}

		/* Create The Member object */
		FileMasterMember fmmember = new FileMasterMember(null);
		if (checkedLayoutMembers.length == 0) {
			fmmember.setName(memberNameCombo.getText().trim());
			fmmember.setType("DSNLIST");
			
			checkedLayoutMembers = new Object[1];
			checkedLayoutMembers[0] = CommonMFCalls.getFQMEM(
					fmdataset.getName(), fmmember.getName(), server, "S");
			((FileMasterMember) checkedLayoutMembers[0]).setType(fmmember.getType());
			
			if(!CommonMFCalls.RETURN_CODE.equals("0")){
				return false;
			}
		}
		for (int count = 0; count < checkedLayoutMembers.length; count++) {
			if (checkedLayoutMembers[count] instanceof FileMasterMember) {

				fmmember.setName(((FileMasterMember) checkedLayoutMembers[count])
						.getName());
				fmmember.setType("DSNLIST");
				if (fmDSNListModel.findObjectInTree(fmmember, dsItem) != null) {
					isDuplicatedMember = true;
				}

				if (isDuplicatedMember) {

					if (!yesToAll && !noToAll) {

						MessageDialog dialog = new MessageDialog(getContainer()
								.getShell(), title, null, question
								+ fmmember.getName() + " ?",
								MessageDialog.QUESTION, new String[] {
										IDialogConstants.NO_LABEL,
										IDialogConstants.NO_TO_ALL_LABEL,
										IDialogConstants.YES_LABEL,
										IDialogConstants.YES_TO_ALL_LABEL, }, 0);
						dialog.open();
						if (dialog.getReturnCode() == 0) // singelNO
						{

						} else if (dialog.getReturnCode() == 1) // noToAll
						{
							noToAll = true;
							yesToAll = false;

						} else if (dialog.getReturnCode() == 2) // singelYes
						{
							fmDSNListModel.removeItem(fmmember);
							AddMemberToDSNView(dsItem, fmmember, count,
									checkedLayouts, checkedLayoutMembers);

						} else if (dialog.getReturnCode() == 3) // yesToAll
						{
							fmDSNListModel.removeItem(fmmember);
							AddMemberToDSNView(dsItem, fmmember, count,
									checkedLayouts, checkedLayoutMembers);
							yesToAll = true;

						}
					}

					if (yesToAll || singelYes) // next duplicate member which
												// comes after Yes to all
					{
						fmDSNListModel.removeItem(fmmember);
						AddMemberToDSNView(dsItem, fmmember, count,
								checkedLayouts, checkedLayoutMembers);
						singelYes = false;
					}

					isDuplicatedMember = false;

				} else if (!isDuplicatedMember) {

					AddMemberToDSNView(dsItem, fmmember, count, checkedLayouts,
							checkedLayoutMembers);
				}

			}
		}

		final IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		Shell shell = window.getShell();
		shell.setMinimized(false);
		shell.forceActive();
		shell.forceFocus();

		try {
			final IWorkbenchPage page = window.getActivePage();
			IViewPart view = page.showView(DSNListView.ID);

			if (view instanceof DSNListView) {
				TreeViewer viewer = ((DSNListView) view).getViewer();
				if (viewer != null) {
					TT_TreeItem selection = fmDSNListModel.findObjectInTree(
							fmmember, fmDSNListModel.findObject(fmdataset));
					Object[] expandedElements = viewer.getExpandedElements();
					viewer.setInput(fmDSNListModel.getDatasets());
					viewer.refresh(true);
					viewer.setExpandedElements(expandedElements);
					viewer.setSelection(new StructuredSelection(selection),
							true);
					view = page.showView(DSNListView.ID);
					page.activate(view);
					page.bringToTop(view);

				}

				view.setFocus();

			}

		} catch (final PartInitException e) {
		}
		fmDSNListModel.save();
		return true;

	}
}
