/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

import java.util.ArrayList;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;


import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.core.TT_TreeItem;

/**
 * @author galpe02
 * 
 */
public class CreateUpdateDSNListWizard extends Wizard implements INewWizard {
	private CreateUpdateDSNListWizardPage page1;
	private FMDSNListTreeModel dsnlistModel = FMDSNListTreeModel
			.getInstance();
	private boolean isDSNListTreeItem = false;
	private FileMasterServer server = null;
	private FileMasterDataset dataset = null;
	private FileMasterMember member = null;
	private TT_TreeItem treeItem;
	private boolean isNewDSNList = false;
	private String title;
	
	ArrayList<String> dsnList = new ArrayList<String>();

	public CreateUpdateDSNListWizard(boolean isNewDSNList) {

		this.isNewDSNList = isNewDSNList;
		if (isNewDSNList) {
			title = "Create DSN List";
		} else
			title = "DSN List Update";

		setWindowTitle(title);
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		Object object = selection.getFirstElement();
		if (object != null) {
			treeItem = dsnlistModel.findObject(object);
			isDSNListTreeItem = true;
			if (treeItem != null) {
				if (isDSNListTreeItem) {
					server = null;
					if (treeItem.getParent() != null) {
						
						if(!isNewDSNList){
							member = (FileMasterMember) treeItem
									.getAdapter(FileMasterMember.class);
						}
						
						dataset = (FileMasterDataset) treeItem.getParent()
								.getAdapter(FileMasterDataset.class);
						
						for(TT_TreeItem DSName : (TT_TreeItem[]) treeItem.getChildren()){
							dsnList.add(DSName.getName());
						}

					} else {
						member = null;
						dataset = (FileMasterDataset) treeItem
								.getAdapter(FileMasterDataset.class);
					}
				}
			} else {
				dataset = null;
				member = null;
				server = null;
			}
		}

	}

	public void addPages() {
		String datasetName = "";
		String memberName = "";
		String description = "";

		if (dataset != null) {
			datasetName = dataset.getName();
		}
		if (member != null) {
			memberName = member.getName();
		}
		if (treeItem != null){
			description = treeItem.getElement().getAttribute("description");	
		}
		
		dsnList.add("");

		page1 = new CreateUpdateDSNListWizardPage(title, server, datasetName,
				memberName, description, isNewDSNList, dsnList);
		addPage(page1);
	}

	@Override
	public boolean performFinish() {
		return (page1).doFinish();
	}

	@Override
	public boolean canFinish() {
		// TODO Auto-generated method stub
		return page1.isPageComplete();
	}

}
