/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RunGetStartEdit
implements Runnable {
    static final String cacopyright = "Copyright (c) 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterDataset layoutDataset;
    private FileMasterMember member;
    private FileMasterMember layoutMember;
    private String displayMode;
    private String changeLog;
    private String uuid;
    private boolean canRetry = true;
    private String selCritDynamic;
    private String[] selectionCriteria;
    private static final String SERVICE = "filemaster/fmp";
    private String editMode;
    private int CLOGNUM = 0;
    private String CLOGPOPT = "";
    private String changeLogSpacePrim;
    private String changeLogSpaceSec;
    private String storageName;
    private String storgevalue;
    private EditorView editorView = new EditorView();

    public RunGetStartEdit(FileMasterServer server, FileMasterDataset[] datasets, FileMasterMember[] members, String editMode, String displayMode, String changeLog, String changeLogSpacePrim, String changeLogSpaceSec, String storageName, String storgevalue, int changeLogNUM, String changeLogPOPT, ArrayList<String> selCrit) {
        this.dataset = datasets[0];
        this.layoutDataset = datasets[1];
        this.member = members[0];
        this.layoutMember = members[1];
        this.displayMode = displayMode;
        this.changeLog = changeLog;
        this.selCritDynamic = selCrit.get(0);
        this.selectionCriteria = this.selCritDynamic.split("\r\n");
        this.server = server;
        this.editMode = editMode;
        this.CLOGNUM = changeLogNUM;
        this.CLOGPOPT = changeLogPOPT;
        this.changeLogSpacePrim = changeLogSpacePrim;
        this.changeLogSpaceSec = changeLogSpaceSec;
        this.storageName = storageName;
        this.storgevalue = storgevalue;
    }

    public RunGetStartEdit(FileMasterServer server, String datasetVal, String editMode, String displayMode) {
        this.server = server;
        this.editMode = editMode;
        this.displayMode = displayMode;
        this.changeLog = "N";
        this.selectionCriteria = new String[0];
        this.layoutDataset = new FileMasterDataset(null);
        this.layoutMember = new FileMasterMember(null);
        this.dataset = new FileMasterDataset(null);
        this.dataset.setName(datasetVal);
        this.member = new FileMasterMember(null);
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            FileMasterSession session = FileMasterSession.startSession((FileMasterServer)this.server, (boolean)false);
            if (session == null) {
                return;
            }
            this.uuid = session.getUuid();
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("strte", map, false, this.createXml());
                if (this.xml.getAttachedFile() != null) {
                    int ReturnCode;
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                    Element element = this.xml.getRoot();
                    Node returnNode = element.getElementsByTagName("ReturnCode").item(0);
                    if (returnNode != null && (ReturnCode = Integer.parseInt(CommonMFCalls.getTagValue((String)"RetuenCode", (Element)((Element)returnNode)))) > 0) {
                        NodeList messages = element.getElementsByTagName("Message");
                        String message = "";
                        String message2 = "";
                        int i = 0;
                        while (i < messages.getLength()) {
                            Node msgNode = messages.item(i);
                            Element msgElement = (Element)msgNode;
                            message2 = String.valueOf(message2) + CommonMFCalls.getTagValue((String)"Message", (Element)msgElement);
                            ++i;
                        }
                        FileMasterSession.removeSession((FileMasterServer)this.server, (String)this.uuid);
                        ArrayList<String> extraText = new ArrayList<String>();
                        extraText.add("Session information: " + this.uuid);
                        message = "Return Code: " + ReturnCode;
                        TT_ErrorDialog.openError(null, (String)"Communications Error", (String)message, (Throwable)new Throwable(message2), extraText);
                    }
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null && (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16"))) {
                        String message = "";
                        FileMasterSession.removeSession((FileMasterServer)this.server, (String)this.uuid);
                        ArrayList<String> extraText = new ArrayList<String>();
                        extraText.add("Session information: " + this.uuid);
                        message = "Return Code: " + reqElement.getAttribute("errorlevel");
                        String message2 = "The connection with the server has been interrupted.";
                        TT_ErrorDialog.openError(null, (String)"Communications Error", (String)message, (Throwable)new Throwable(message2), extraText);
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"N\">";
        command = this.changeLog.equalsIgnoreCase("Y") ? String.valueOf(command) + "<StartEdit changeLog=\"" + this.changeLog + "\"  changeLogNUM=\"" + this.CLOGNUM + "\" changeLogPOPT=\"" + this.CLOGPOPT + "\" editMode=\"" + this.editMode + "\">" : String.valueOf(command) + "<StartEdit changeLog=\"" + this.changeLog + "\" editMode=\"" + this.editMode + "\">";
        command = String.valueOf(command) + "<DataSet dsname=\"" + this.dataset.getName() + "\"";
        if (!this.dataset.getVolume().trim().isEmpty()) {
            command = String.valueOf(command) + " volumeSerial=\"" + this.dataset.getVolume() + "\"";
        }
        if (!this.member.getName().trim().isEmpty()) {
            command = String.valueOf(command) + " member=\"" + this.member.getName() + "\"";
        }
        command = String.valueOf(command) + "/>";
        if (!this.layoutDataset.getName().isEmpty() && !this.layoutMember.getName().isEmpty()) {
            command = String.valueOf(command) + "<Layout><DataSetName>" + this.layoutDataset.getName() + "</DataSetName>" + "<MemberName>" + this.layoutMember.getName() + "</MemberName>" + "</Layout>";
        }
        if (this.selectionCriteria.length > 0 && !this.selectionCriteria[0].trim().isEmpty()) {
            command = String.valueOf(command) + "<SelectionCriteria><DynamicSelCrit>";
            command = String.valueOf(command) + "<DynamicSelCritLine>*** CA File Master Plus              9.0.0   Selection Criteria</DynamicSelCritLine>";
            command = String.valueOf(command) + "<DynamicSelCritLine>\"SELECTION CRITERIA MEMBER\"</DynamicSelCritLine>";
            int count = 0;
            while (count < this.selectionCriteria.length) {
                command = String.valueOf(command) + "<DynamicSelCritLine>" + this.selectionCriteria[count] + "</DynamicSelCritLine>";
                ++count;
            }
            command = String.valueOf(command) + "</DynamicSelCrit>";
            command = String.valueOf(command) + "</SelectionCriteria>";
        }
        if (this.changeLog.equalsIgnoreCase("Y")) {
            command = String.valueOf(command) + "<ChangeLogData ";
            command = String.valueOf(command) + " ChangeLogSpacePrim=\"" + this.changeLogSpacePrim + "\" ChangeLogSpaceSec=\"" + this.changeLogSpaceSec + "\">";
            if (this.storageName.equalsIgnoreCase("ChangeLogVolser")) {
                command = String.valueOf(command) + "<ChangeLogVolser>" + this.storgevalue;
                command = String.valueOf(command) + "</ChangeLogVolser>";
            } else if (this.storageName.equalsIgnoreCase("ChangeLogUnit")) {
                command = String.valueOf(command) + "<ChangeLogUnit>" + this.storgevalue;
                command = String.valueOf(command) + "</ChangeLogUnit>";
            }
            command = String.valueOf(command) + "</ChangeLogData>";
        }
        command = String.valueOf(command) + " </StartEdit></Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc((String)command);
    }
}

