/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.editor.FMEditorProfile;
import com.ca.filemaster.editor.pricommands.wizards.InsertRecordsWizard;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class LineInsertHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (window.getActivePage().getActivePart() instanceof EditorView) {
            String secondaryID = ((IViewSite)window.getActivePage().getActivePart().getSite()).getSecondaryId();
            FileMasterSession session = ((EditorView)window.getActivePage().getActivePart()).getCurrentSession(secondaryID);
            FileMasterServer server = session.getServer();
            String uuid = session.getUuid();
            String displayMode = session.getDisplayMode();
            String hexMode = session.getHexMode();
            FMEditorProfile profile = ((EditorView)window.getActivePage().getActivePart()).getProfile();
            int recordLength = -1;
            if (displayMode.equals("C")) {
                recordLength = ((EditorView)window.getActivePage().getActivePart()).getCharMode().getSelectedRecordLength();
            } else if (displayMode.equals("M")) {
                recordLength = ((EditorView)window.getActivePage().getActivePart()).getMultiRecordFormatMode().getSelectedRecordLength();
            }
            if (recordLength == -1) {
                recordLength = profile.getMaxLength();
            }
            InsertRecordsWizard wizard = new InsertRecordsWizard(server, uuid, displayMode, hexMode, recordLength);
            Shell shell = window.getShell();
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            if (profile.getMinLength() != profile.getMaxLength()) {
                wizard.setVariableLength(profile.getMinLength(), profile.getMaxLength());
            }
            dialog.open();
        }
        return null;
    }
}

