/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.pricommands.wizards.FindChangePrimaryCommandWizardPage;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import com.ca.filemaster.runners.RunGetFindExclude;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ExcludePrimaryCommandWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private static final int EXCLUDE_LENGTH_MAX = 16;
    private static final int EXCLUDE_LENGTH_MIN = 1;
    private static final int EXCLUDE_VALUE_MAX = 32;
    private static final int EXCLUDE_VALUE_MIN = 1;
    protected Composite container;
    private Composite parentComposite;
    private Logger logger = Logger.getLogger(ExcludePrimaryCommandWizardPage.class.getName());
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.exclude";
    public Label excString;
    private Label findLim;
    private Label startCol;
    private Label endCol;
    private Label changeLabel;
    private Label totalMatch;
    protected Combo txtExcString;
    protected Spinner txtFindLim;
    protected Combo txtstartCol;
    protected Combo txtendCol;
    protected Combo textChange;
    private Button nextBtn;
    private Button prevBtn;
    private Button firstBtn;
    private Button lastBtn;
    private Composite btnComposite;
    private Button excludeBtn;
    private Button excludeAllBtn;
    private Button charBtn;
    private Button wordBtn;
    private Button prefixBtn;
    private Button suffixBtn;
    private Button fieldBtn;
    protected FileMasterServer server;
    protected String uuid;
    protected String displayMode;
    protected String hexMode;
    protected EditorView editorView;
    private FMPCursor cursorRange;
    private int findlimit;
    private Combo cmbType;
    private Text txtLength;

    public ExcludePrimaryCommandWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Exclude");
    }

    public ExcludePrimaryCommandWizardPage(String pageName, FileMasterServer server, String uuid, String displayMode, String hexMode, EditorView editorView, FMPCursor cursorRange) {
        super(pageName);
        this.setTitle("Exclude");
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
        this.editorView = editorView;
        this.cursorRange = cursorRange;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.parentComposite = new Composite(this.container, 0);
        GridLayout gl_parentComposite = new GridLayout(1, false);
        gl_parentComposite.marginHeight = 0;
        gl_parentComposite.marginWidth = 0;
        this.parentComposite.setLayout((Layout)gl_parentComposite);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite composite1 = new Composite(this.parentComposite, 0);
        GridLayout gl_comp = new GridLayout(3, false);
        gl_comp.marginHeight = 0;
        gl_comp.marginWidth = 0;
        composite1.setLayout((Layout)gl_comp);
        composite1.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite firstColumn = new Composite(composite1, 0);
        GridLayout gl_firstColumn = new GridLayout(1, false);
        gl_firstColumn.marginHeight = 0;
        gl_firstColumn.marginWidth = 0;
        firstColumn.setLayout((Layout)gl_firstColumn);
        firstColumn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.excString = new Label(firstColumn, 0);
        this.excString.setText("E&xclude:");
        this.txtExcString = new Combo(firstColumn, 2048);
        this.txtExcString.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtExcString.addModifyListener((ModifyListener)this);
        Composite SecondColumn = new Composite(composite1, 0);
        GridLayout gl_SecondColumn = new GridLayout(1, false);
        gl_SecondColumn.marginHeight = 0;
        gl_SecondColumn.marginWidth = 0;
        SecondColumn.setLayout((Layout)gl_SecondColumn);
        SecondColumn.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        Label lblType = new Label(SecondColumn, 0);
        lblType.setText("&Type:");
        this.cmbType = new Combo(SecondColumn, 8);
        this.cmbType.setItems(FindChangePrimaryCommandWizardPage.types);
        this.cmbType.setText(FindChangePrimaryCommandWizardPage.types[0]);
        this.cmbType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ExcludePrimaryCommandWizardPage.this.cmbType.getSelectionIndex() == 3) {
                    ExcludePrimaryCommandWizardPage.this.txtLength.setEnabled(true);
                } else {
                    ExcludePrimaryCommandWizardPage.this.txtLength.setEnabled(false);
                }
                ExcludePrimaryCommandWizardPage.this.isPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite ThirdColumn = new Composite(composite1, 0);
        GridLayout gl_ThirdColumn = new GridLayout(1, true);
        gl_ThirdColumn.marginHeight = 0;
        gl_ThirdColumn.marginWidth = 0;
        ThirdColumn.setLayout((Layout)gl_ThirdColumn);
        Label lblLength = new Label(ThirdColumn, 0);
        lblLength.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblLength.setText("Len&gth:");
        this.txtLength = new Text(ThirdColumn, 2048);
        this.txtLength.setEnabled(false);
        this.txtLength.addModifyListener((ModifyListener)this);
        this.txtLength.addVerifyListener((VerifyListener)new verifyDigit(true));
        Composite composite = new Composite(this.parentComposite, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Group colRange = new Group(composite, 0);
        colRange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        colRange.setLayout((Layout)new GridLayout(3, false));
        colRange.setText("Column range");
        this.startCol = new Label((Composite)colRange, 0);
        this.startCol.setText("&Start:");
        this.txtstartCol = new Combo((Composite)colRange, 2048);
        this.txtstartCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtstartCol.addModifyListener((ModifyListener)this);
        this.txtstartCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.endCol = new Label((Composite)colRange, 0);
        this.endCol.setText("En&d:");
        this.txtendCol = new Combo((Composite)colRange, 2048);
        this.txtendCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtendCol.addModifyListener((ModifyListener)this);
        this.txtendCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        Group occurenceGrp = new Group(this.container, 0);
        occurenceGrp.setLayout((Layout)new GridLayout(4, false));
        occurenceGrp.setSize(occurenceGrp.computeSize(-1, -1));
        occurenceGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        occurenceGrp.setText("Occurrences");
        this.setControl((Control)this.container);
        this.nextBtn = new Button((Composite)occurenceGrp, 16);
        this.nextBtn.setText("&Next");
        this.nextBtn.setSelection(true);
        this.prevBtn = new Button((Composite)occurenceGrp, 16);
        this.prevBtn.setText("&Previous");
        this.firstBtn = new Button((Composite)occurenceGrp, 16);
        this.firstBtn.setText("&First");
        this.lastBtn = new Button((Composite)occurenceGrp, 16);
        this.lastBtn.setText("&Last");
        Group locatnGrp = new Group(this.container, 0);
        locatnGrp.setLayout((Layout)new GridLayout(5, false));
        locatnGrp.setSize(locatnGrp.computeSize(-1, -1));
        locatnGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        locatnGrp.setText("Location");
        this.charBtn = new Button((Composite)locatnGrp, 16);
        this.charBtn.setText("C&haracter");
        this.charBtn.setSelection(true);
        this.wordBtn = new Button((Composite)locatnGrp, 16);
        this.wordBtn.setText("&Word");
        this.prefixBtn = new Button((Composite)locatnGrp, 16);
        this.prefixBtn.setText("P&refix");
        this.suffixBtn = new Button((Composite)locatnGrp, 16);
        this.suffixBtn.setText("S&uffix");
        this.btnComposite = new Composite(this.container, 0);
        GridLayout gl_btnComposite = new GridLayout(4, false);
        gl_btnComposite.marginWidth = 0;
        this.btnComposite.setLayout((Layout)gl_btnComposite);
        this.btnComposite.setLayoutData((Object)new GridData(131072, 1024, false, true, 1, 1));
        this.initializeDialogUnits((Control)parent);
        this.excludeBtn = new Button(this.btnComposite, 0);
        this.excludeBtn.addSelectionListener((SelectionListener)this);
        this.excludeBtn.setText("&Exclude");
        this.setButtonLayoutData(this.excludeBtn);
        this.excludeAllBtn = new Button(this.btnComposite, 0);
        this.excludeAllBtn.addSelectionListener((SelectionListener)this);
        this.excludeAllBtn.setText("Exclude &All");
        this.totalMatch = new Label(this.btnComposite, 0);
        this.totalMatch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.totalMatch.setText("  ");
        CharFormatMode.totalMatch = "";
        SingleRecordFormatMode.totalMatch = "";
        MultiRecordFormatMode.totalMatch = "";
        this.setButtonLayoutData(this.excludeAllBtn);
        FMHistory.intializeComboBoxes((Combo)this.txtExcString, (String)"excludeExcString");
        FMHistory.intializeComboBoxes((Combo)this.txtstartCol, (String)"excludestartCol");
        FMHistory.intializeComboBoxes((Combo)this.txtendCol, (String)"excludeendCol");
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setEnabled(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setVisible(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(1).setText("Close");
        this.getShell().getDefaultButton().setVisible(false);
        Point size = this.getShell().computeSize(400, 550);
        this.getShell().setSize(size);
        this.setControl((Control)this.container);
        this.setPageComplete(this.isPageComplete());
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.controlModifiedAny();
        if (this.txtstartCol.getText().isEmpty() && !this.txtendCol.getText().isEmpty()) {
            this.setErrorMessage("Missing start column value");
            this.toggleBtns(false);
            return false;
        }
        if (!this.txtstartCol.getText().isEmpty() && !this.txtendCol.getText().isEmpty() && Integer.parseInt(this.txtstartCol.getText()) > Integer.parseInt(this.txtendCol.getText())) {
            this.setErrorMessage("End column range should be greater than start column range.");
            this.toggleBtns(false);
            return false;
        }
        return true;
    }

    private void toggleBtns(boolean state) {
        this.excludeBtn.setEnabled(state);
        this.excludeAllBtn.setEnabled(state);
    }

    private void controlModifiedAny() {
        this.determineIfExcludeButtonsShouldBeEnabledOrDisabled();
        this.determineIfExcludeAllButtonsShouldBeEnabledOrDisabled();
        this.determineIfThereAreErrorsWithTheQuery();
    }

    private void determineIfExcludeAllButtonsShouldBeEnabledOrDisabled() {
        if (this.txtExcString.getText().isEmpty() || this.txtExcString == null) {
            if (this.cmbType.getSelectionIndex() == 3) {
                if (this.txtLength.getText().isEmpty()) {
                    this.toggleBtns(false);
                    return;
                }
                this.excludeAllBtn.setEnabled(true);
                this.excludeBtn.setEnabled(false);
                return;
            }
            this.excludeAllBtn.setEnabled(true);
            this.excludeBtn.setEnabled(false);
            return;
        }
        this.excludeAllBtn.setEnabled(true);
        this.excludeBtn.setEnabled(true);
    }

    private void determineIfExcludeButtonsShouldBeEnabledOrDisabled() {
        if (this.txtExcString.getText().isEmpty() || this.txtExcString == null) {
            this.excludeBtn.setEnabled(false);
            return;
        }
        this.excludeBtn.setEnabled(true);
    }

    private void determineIfThereAreErrorsWithTheQuery() {
        this.setErrorMessage(null);
        if (this.cmbType.getSelectionIndex() == 3) {
            int packedDecimalLength = 0;
            if (this.txtLength.isEnabled() && !this.txtLength.getText().isEmpty()) {
                try {
                    packedDecimalLength = Integer.parseInt(this.txtLength.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (packedDecimalLength > 16) {
                    this.disableSubmissionButtonsBecauseOfErrorInQuery("Find Length cannot be more than 16");
                    return;
                }
                if (packedDecimalLength < 1) {
                    this.disableSubmissionButtonsBecauseOfErrorInQuery("Find Length cannot be less than 1");
                    return;
                }
            }
            if (this.txtExcString.getText().length() > 32) {
                this.disableSubmissionButtonsBecauseOfErrorInQuery("Find Value cannot be more than 32");
            }
        }
        if (!this.txtExcString.getText().isEmpty()) {
            if (this.cmbType.getSelectionIndex() == 2) {
                String errorMessage = Validator.errorMsg[Validator.HexadecimalLength((String)this.txtExcString.getText(), (boolean)false)];
                this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
                return;
            }
            if (this.cmbType.getSelectionIndex() == 3) {
                String errorMessage = Validator.errorMsg[Validator.PackedDecimalLength((String)this.txtExcString.getText(), (boolean)false)];
                this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
                return;
            }
        }
    }

    private void disableSubmissionButtonsBecauseOfErrorInQuery(String errorMessage) {
        if (errorMessage != null && errorMessage.length() > 0) {
            this.setErrorMessage(errorMessage);
            this.excludeBtn.setEnabled(false);
            this.excludeAllBtn.setEnabled(false);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected String getOccurrence() {
        if (this.nextBtn.getSelection()) {
            return "NEXT";
        }
        if (this.prevBtn.getSelection()) {
            return "PREV";
        }
        if (this.firstBtn.getSelection()) {
            return "FIRST";
        }
        if (this.lastBtn.getSelection()) {
            return "LAST";
        }
        return "";
    }

    protected String getLocation() {
        if (this.wordBtn.getSelection()) {
            return "WORD";
        }
        if (this.prefixBtn.getSelection()) {
            return "PREFIX";
        }
        if (this.suffixBtn.getSelection()) {
            return "SUFFIX";
        }
        return "";
    }

    public boolean doFinish() {
        FMHistory.insertHistory((Combo)this.txtExcString, (String)"excludeExcString");
        FMHistory.insertHistory((Combo)this.txtstartCol, (String)"excludestartCol");
        FMHistory.insertHistory((Combo)this.txtendCol, (String)"excludeendCol");
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        String occurence;
        boolean startingPoint = true;
        String findString = "";
        EditorView view = null;
        FMPCursor cursor = this.getCursor();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page.getActivePart() instanceof EditorView) {
            view = (EditorView)page.getActivePart();
        }
        String changeString = "";
        String padcharecter = "";
        String excludeOption = "";
        if (e.getSource().equals(this.excludeBtn) || e.getSource().equals(this.excludeAllBtn)) {
            FMHistory.insertHistory((Combo)this.txtExcString, (String)"excludeExcString");
            FMHistory.insertHistory((Combo)this.txtstartCol, (String)"excludestartCol");
            FMHistory.insertHistory((Combo)this.txtendCol, (String)"excludeendCol");
        }
        if (e.getSource().equals(this.excludeAllBtn)) {
            cursor.setRecordNumber(1);
            this.setCursor(cursor);
            occurence = "ALL";
        } else {
            occurence = this.getOccurrence();
        }
        findString = this.txtExcString.getText().trim();
        if (!findString.isEmpty()) {
            switch (this.cmbType.getSelectionIndex()) {
                case 0: {
                    findString = "T'" + findString + "'";
                    break;
                }
                case 1: {
                    findString = "C'" + findString + "'";
                    break;
                }
                case 2: {
                    findString = "X'" + findString + "'";
                    break;
                }
                case 3: {
                    if (this.txtLength.getText().length() > 0) {
                        findString = "PL" + this.txtLength.getText() + "'" + findString + "'";
                        break;
                    }
                    findString = "P'" + findString + "'";
                }
            }
        } else if (findString.isEmpty() && this.cmbType.getSelectionIndex() == 3) {
            findString = "PL" + this.txtLength.getText();
        }
        FMPRange colsRange = new FMPRange(this.txtstartCol.getText().trim(), this.txtendCol.getText().trim());
        String location = this.getLocation();
        if (this.displayMode.equalsIgnoreCase("C")) {
            this.cursorRange = cursor;
        }
        if (this.displayMode.equalsIgnoreCase("M")) {
            this.cursorRange = cursor;
        }
        if (this.displayMode.equalsIgnoreCase("S")) {
            this.cursorRange = this.editorView.getCursor();
        }
        RunGetFindExclude runner = new RunGetFindExclude("Exclude", this.server, this.uuid, this.displayMode, this.hexMode, this.findlimit, findString, changeString, padcharecter, this.cursorRange, colsRange, occurence, location, excludeOption);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
        this.totalMatch.setText(xmlResponseParser.getDisplayMessage());
        Element reqElement = xmlResponse.getRoot();
        IWorkbenchPart workbenchPart = page.getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        view.handleMissingSession(reqElement, page, secondaryId);
        if (xmlResponse != null && xmlResponse.getRoot().getNodeName().equals("GUIResponse") && view != null) {
            if (this.displayMode.equalsIgnoreCase("C")) {
                int newTableLineNumber;
                NamedNodeMap map;
                Element element;
                NodeList nodeListRecord;
                if (e.getSource().equals(this.excludeAllBtn) && xmlResponse != null && (nodeListRecord = (element = xmlResponse.getRoot()).getElementsByTagName(Constants.ELEMENT_RECORD)).getLength() != 0 && (map = nodeListRecord.item(0).getAttributes()).getNamedItem("number") != null && (newTableLineNumber = Integer.valueOf(map.getNamedItem("number").getNodeValue()) + 1) > 0) {
                    view.getCharMode().setCursor(newTableLineNumber);
                }
                view.getCharMode().setExcluded(true);
                CharFormatMode.resetRecordCount();
                view.updateCharEditViewer(xmlResponse, true);
            }
            if (this.displayMode.equalsIgnoreCase("M")) {
                if (occurence.equals("ALL")) {
                    view.getMultiRecordFormatMode().setExcludeAll(true);
                }
                view.getMultiRecordFormatMode().setExcluded(true);
                view.getMultiRecordFormatMode().setUpdateCurrentDisplay(true);
                view.updateMRFEditViewer(xmlResponse);
            }
            if (this.displayMode.equalsIgnoreCase("S")) {
                view.updateSRFEditViewer(xmlResponse);
            }
        }
    }

    private void closeExcludeDialogBox() {
        TestingToolsWizardDialog ttwd;
        String name;
        Object object;
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        Shell shell = activeShell.getShell();
        if (shell != null && (object = shell.getData()) != null && object instanceof TestingToolsWizardDialog && (name = (ttwd = (TestingToolsWizardDialog)object).getCurrentPage().getName()).equals("Exclude")) {
            shell.close();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private FMPCursor getCursor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page.getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)page.getActivePart();
            String secondaryId = ((IViewSite)view.getSite()).getSecondaryId();
            return view.getCursor(secondaryId);
        }
        return new FMPCursor(0, "", 1, 0);
    }

    private void setCursor(FMPCursor cursor) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page.getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)page.getActivePart();
            view.setCursor(cursor);
        }
    }
}

