/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageTwo;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditorWizard
extends Wizard
implements INewWizard {
    public IStructuredSelection selection;
    public static String fileType = "";
    public static String keyPosition = "-1";
    public static String keyLength = "-1";
    EditorWizardPageOne page1;
    EditorWizardPageTwo page2;
    public String titlePageOne = "Open File";
    public String titlePageTwo = "Options";
    protected String datasetName = "";
    protected String memberName = "";
    protected String serverName = "";
    protected FileMasterServer server;
    protected FileMasterDataset dataSet;
    protected FileMasterMember member;
    protected String layoutDS = "";
    protected String layoutMem = "";
    private String uuid;
    private final Logger logger = Logger.getLogger(EditorWizard.class.getName());

    public EditorWizard() {
    }

    public EditorWizard(FileMasterDataset dataSet, FileMasterServer server, String uuid) {
        this.dataSet = dataSet;
        this.server = server;
        this.uuid = uuid;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.logger.log(Level.INFO, "");
        keyPosition = "-1";
        keyLength = "-1";
        this.selection = selection;
        if (selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() != null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
                this.member = (FileMasterMember)treeItem.getValue();
                fileType = "PDS";
                this.layoutDS = treeItem.getElement().getAttribute("layoutDS");
                this.layoutMem = treeItem.getElement().getAttribute("layoutMem");
            } else {
                this.dataSet = (FileMasterDataset)treeItem.getValue();
                this.server = (FileMasterServer)treeItem.getParent().getValue();
                this.dataSet = CommonMFCalls.getFQDSN((String)this.dataSet.getName(), (String)"", (FileMasterServer)this.server);
                if (this.dataSet.getVolume().equalsIgnoreCase("ARCIVE")) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)"Invalid data set", (Throwable)new Throwable("Data set is archived. "));
                    return;
                }
                if (((FileMasterDataset)treeItem.getValue()).getDsOrg().equalsIgnoreCase("VSAM")) {
                    keyPosition = "-1";
                    keyLength = "-1";
                    if (this.dataSet.getDsType().equalsIgnoreCase("CLUSTER") || this.dataSet.getDsType().equalsIgnoreCase("K")) {
                        if (((FMPVSAMDataset)this.dataSet).getBaseDsn().isEmpty()) {
                            keyPosition = ((FMPVSAMDataset)this.dataSet).getOffset();
                            keyLength = ((FMPVSAMDataset)this.dataSet).getLength();
                        } else {
                            keyPosition = "6";
                            ((FMPVSAMDataset)this.dataSet).setOffset(keyPosition);
                            keyLength = ((FMPVSAMDataset)this.dataSet).getLength();
                        }
                    }
                    if (!this.dataSet.getDsType().equalsIgnoreCase("T") && CommonMFCalls.RETURN_CODE.equals("0")) {
                        this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
                    }
                    fileType = "VSAM";
                } else {
                    fileType = ((FileMasterDataset)treeItem.getValue()).getDsOrg();
                }
            }
        }
    }

    public FileMasterDataset getDataSet() {
        return this.dataSet;
    }

    public void addPages() {
        this.setWindowTitle("Open Data Set");
        this.setForcePreviousAndNextButtons(true);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.page1 = new EditorWizardPageOne(false, this.titlePageOne, this.server, this.dataSet, this.member, fileType);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new EditorWizardPageTwo(this.titlePageTwo, this.server.getName(), this.layoutDS, this.layoutMem, this.uuid);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        this.page2.doFinish();
        return this.page1.doFinish();
    }
}

