/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.common.LineRange;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.RunGetGetRecords;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.filemaster.editor.virtualtableviews.CharLineNumLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.CharacterDataEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.EditorContentProvider;
import com.ca.filemaster.editor.virtualtableviews.EditorLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.TableFormatMode;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CharFormatMode
extends TableFormatMode
implements Runnable {
    private static final String TITLE_DATA_CHAR = "DataChar";
    private static final String TITLE_LINE_NUMBER = "LineNumber";
    public static int PAGE_SIZE = 0;
    public static int ORIGINAL_PAGE_SIZE = 0;
    public static int GUI_PAGESIZE = 50;
    public static int COUNT = 0;
    public static String totalMatch = "";
    public static String storetotalMatch = "";
    public int hitIndex = -1;
    public boolean hiliteAllHits = true;
    private int oldIndex;
    private Thread t;
    private Runnable runnableObj = this;
    private int currentStartVal = 0;
    private int currentLastVal = 0;
    private boolean updateCurrentDisplay = false;
    private int currentIndex = -1;
    private boolean isHexMode = false;
    private boolean isLocate = false;
    private boolean isSwitch = false;
    public boolean isReset = false;
    public boolean isFlip = false;
    private boolean isExcluded = false;
    private boolean execute = false;
    private Event prevEvent;
    private boolean dispUp = false;
    private boolean dispMessage = false;
    private int cursorPosition;
    private int hitNumber = -1;
    private Logger log = Logger.getLogger(CharFormatMode.class.getName());
    private Composite charContainer;
    private Composite tableContainer;
    private int tableLineNumber;
    private String hexDisplay;
    public boolean updateDisplay;
    private TableViewerColumn tableviewerColumn;
    private Slider hSlider;
    private Slider vSlider;
    private final int LINENUM_LEN = 10;
    int prevRecordLength = 0;
    int length = 0;
    private int startRownumber;
    private CharacterDataEditingSupport characterDataEditingSupport;
    Map<Integer, FileMasterRecord> selectionData = new HashMap<Integer, FileMasterRecord>();
    private boolean askForRecordCount = true;
    private String secondaryID;
    private FileMasterRecordField fileMasterRecordField;
    private Shell shell = null;
    private boolean dontExecuteGetChunkWhenOpeningDataSet = true;
    private boolean dontExecuteGetChunkAfterExcludeAllClick;
    private Runnable getChunk = new Runnable(){

        @Override
        public void run() {
            if (CharFormatMode.this.editorView.getCurrentSession(CharFormatMode.this.secondaryID) != null && !CharFormatMode.this.editorView.getCurrentSession(CharFormatMode.this.secondaryID).getDisplayMode().equals("C")) {
                return;
            }
            if (CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable) {
                CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                return;
            }
            if (CharFormatMode.this.execute) {
                CharFormatMode.this.getChunk(CharFormatMode.this.oldIndex);
            }
        }
    };

    public CharFormatMode(Composite parent, EditorView editorView) {
        super(parent, editorView);
        this.secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        FileMasterSession fileMasterSession = editorView.getCurrentSession(this.secondaryID);
        EditorWizardPageOne.dataSet = fileMasterSession.getDatasets()[0];
        if (this.shell == null) {
            this.shell = new Shell();
        }
    }

    protected Shell getShell() {
        return this.shell;
    }

    public Composite getContainer() {
        if (this.charContainer == null) {
            this.createContainer(0);
        }
        return this.charContainer;
    }

    public void createContainer(int topIndex) {
        this.t = new Thread(this.runnableObj, "test");
        this.charContainer = new Composite(this.parent, 0);
        this.charContainer.setLayout((Layout)new GridLayout(2, false));
        this.charContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableContainer = new Composite(this.charContainer, 0);
        this.tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableContainer.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(this.tableContainer, 268503058);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.getTable().setLinesVisible(false);
        this.createScrollBars(this.tableContainer);
        this.setTableSize(ORIGINAL_PAGE_SIZE + 1);
        this.tableViewer.getTable().setFont(this.editorView.font);
        ORIGINAL_PAGE_SIZE = PAGE_SIZE;
        this.tableViewer.getTable().addListener(36, new Listener(){

            public void handleEvent(Event event) {
                CharFormatMode.this.prevEvent = event;
                CharFormatMode.this.oldIndex = CharFormatMode.this.tableViewer.getTable().getTopIndex();
                if (!CharFormatMode.this.t.isAlive()) {
                    CharFormatMode.this.t = new Thread(CharFormatMode.this.runnableObj, "ScrollThread");
                    CharFormatMode.this.t.start();
                    return;
                }
            }
        });
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CharFormatMode.this.fileMasterRecords != null) {
                    CharFormatMode.this.fileMasterRecords.clear();
                    CharFormatMode.this.fileMasterRecords = null;
                    CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.clear();
                    CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer = null;
                }
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if ((keyEvent.stateMask & 0x40000) == 262144 && keyEvent.keyCode == 0x1000007) {
                    CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                    CharFormatMode.this.setUpdateCurrentDisplay(true);
                    CharFormatMode.this.setCallMF(true);
                } else if (keyEvent.keyCode == 0x1000007) {
                    CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                    CharFormatMode.this.setUpdateCurrentDisplay(true);
                    CharFormatMode.this.setCallMF(true);
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && CharFormatMode.this.tableViewer.getTable().getSelectionIndex() == CharFormatMode.this.tableViewer.getTable().getTopIndex() + CharFormatMode.this.getLastIndex() - 1) {
                    Event scrollEvent = new Event();
                    scrollEvent.detail = 0x1000002;
                    CharFormatMode.this.vSlider.notifyListeners(13, scrollEvent);
                } else if (e.keyCode == 0x1000001) {
                    CharFormatMode.this.setUpdateCurrentDisplay(true);
                    CharFormatMode.this.setCallMF(false);
                } else if (e.keyCode == 0x1000006) {
                    if (CharFormatMode.this.tableViewer.getTable().getSelectionIndex() == CharFormatMode.this.tableViewer.getTable().getTopIndex() + CharFormatMode.this.getLastIndex() - 1) {
                        Event scrollEvent = new Event();
                        scrollEvent.detail = 0x1000006;
                        CharFormatMode.this.vSlider.notifyListeners(13, scrollEvent);
                        CharFormatMode.this.tableViewer.getTable().setSelection(CharFormatMode.this.tableViewer.getTable().getTopIndex() + CharFormatMode.this.getLastIndex() - 1);
                        e.doit = false;
                    } else if (CharFormatMode.this.tableViewer.getTable().getSelectionIndex() >= CharFormatMode.this.tableViewer.getTable().getTopIndex() && CharFormatMode.this.tableViewer.getTable().getSelectionIndex() <= CharFormatMode.this.tableViewer.getTable().getTopIndex() + CharFormatMode.this.getLastIndex() - 1) {
                        e.doit = true;
                    } else {
                        Event scrollEvent = new Event();
                        scrollEvent.detail = 0x1000006;
                        CharFormatMode.this.vSlider.notifyListeners(13, scrollEvent);
                        e.doit = false;
                    }
                } else if (e.keyCode == 0x1000005) {
                    if (CharFormatMode.this.tableViewer.getTable().getSelectionIndex() == CharFormatMode.this.tableViewer.getTable().getTopIndex()) {
                        Event scrollEvent = new Event();
                        scrollEvent.detail = 0x1000005;
                        CharFormatMode.this.vSlider.notifyListeners(13, scrollEvent);
                        CharFormatMode.this.tableViewer.getTable().setSelection(CharFormatMode.this.tableViewer.getTable().getTopIndex());
                        e.doit = false;
                    } else if (CharFormatMode.this.tableViewer.getTable().getSelectionIndex() > CharFormatMode.this.tableViewer.getTable().getTopIndex() && CharFormatMode.this.tableViewer.getTable().getSelectionIndex() <= CharFormatMode.this.tableViewer.getTable().getTopIndex() + CharFormatMode.this.getLastIndex() - 1) {
                        e.doit = true;
                    } else {
                        Event scrollEvent = new Event();
                        scrollEvent.detail = 0x1000005;
                        CharFormatMode.this.vSlider.notifyListeners(13, scrollEvent);
                        e.doit = false;
                    }
                } else if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 0x1000008 || e.keyCode == 0x1000008) {
                    int offset = 1;
                    CharFormatMode.this.createModel(Integer.MAX_VALUE, true);
                    if (CharFormatMode.this.fileMasterRecords.size() == 0) {
                        return;
                    }
                    if (CharFormatMode.this.fileMasterRecords.size() <= CharFormatMode.this.getLastIndex()) {
                        offset = 0;
                    }
                    int vSliderSelection = ((FileMasterRecord)CharFormatMode.this.fileMasterRecords.get(offset)).getNumber();
                    CharFormatMode.this.vSlider.setSelection(vSliderSelection - 1);
                    CharFormatMode.this.tableViewer.getTable().setTopIndex(vSliderSelection - 1);
                    ORIGINAL_PAGE_SIZE = PAGE_SIZE;
                    CharFormatMode.this.initOldarrayFMRecord();
                    int count = 0;
                    while (count < CharFormatMode.this.fileMasterRecords.size()) {
                        if (vSliderSelection + count - 1 < CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() && count + offset < CharFormatMode.this.fileMasterRecords.size()) {
                            CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.set(vSliderSelection - 1 + count, CharFormatMode.this.fileMasterRecords.get(count + offset));
                        }
                        ++count;
                    }
                    CharFormatMode.this.tableViewer.setInput((Object)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new Object[CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
                    CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
                    CharFormatMode.this.setUpdateCurrentDisplay(false);
                    CharFormatMode.this.setCallMF(false);
                    e.doit = false;
                }
            }
        });
        this.tableViewer.getTable().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                CharFormatMode.this.setUpdateCurrentDisplay(true);
                CharFormatMode.this.setCallMF(true);
                CharFormatMode.this.setSliderAttr();
                CharFormatMode.this.updateTableDisplay();
                CharFormatMode.this.tableViewer.getTable().redraw();
                CharFormatMode.this.vSlider.setFocus();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.tableViewer.getTable().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                CharFormatMode.this.setSliderAttr();
            }
        });
        this.setTableSize(PAGE_SIZE + 1);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if ((IStructuredSelection)event.getSelection() instanceof FileMasterRecord && (FileMasterRecord)((IStructuredSelection)event.getSelection()).getFirstElement() != null) {
                    CharFormatMode.this.tableLineNumber = ((FileMasterRecord)((IStructuredSelection)event.getSelection()).getFirstElement()).getNumber() - 1;
                }
            }
        });
        this.initOldarrayFMRecord();
        this.tableViewer.getTable().setSelection(0);
        this.tableViewer.refresh();
        this.tableViewer.getControl().setFocus();
        this.createColumns(this.parent, this.tableViewer);
        this.tableViewer.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CharFormatMode.this.setSliderAttr();
            }
        });
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CharFormatMode.this.setSelectionData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CharFormatMode.this.setSelectionData();
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000004) {
                    e.doit = false;
                    CharFormatMode.this.hSlider.setSelection(CharFormatMode.this.hSlider.getSelection() + CharFormatMode.this.getPixelSizeOfCharacter());
                    CharFormatMode.this.updateTableDisplay();
                }
                if (e.keyCode == 0x1000003) {
                    e.doit = false;
                    CharFormatMode.this.hSlider.setSelection(CharFormatMode.this.hSlider.getSelection() - CharFormatMode.this.getPixelSizeOfCharacter());
                    CharFormatMode.this.updateTableDisplay();
                }
            }
        });
        if (topIndex > 0) {
            this.tableViewer.getTable().setTopIndex(topIndex);
            this.vSlider.setSelection(topIndex);
        }
    }

    private void createScrollBars(Composite mainContainer2) {
        this.hSlider = new Slider(mainContainer2, 256);
        this.hSlider.setBounds(2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().width - this.getPixelSizeOfCharacter() - 3 * this.tableViewer.getTable().getBorderWidth(), this.getDefaultSizeOfSliders() * 2);
        this.hSlider.setMinimum(0);
        this.hSlider.setMaximum(this.currentRecordLength * this.getPixelSizeOfCharacter());
        this.hSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.hSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CharFormatMode.this.getCharacterDataEditingSupport().textCellEditorFileMaster.isActivated()) {
                    CharFormatMode.this.getCharacterDataEditingSupport().focusLost(null);
                }
                CharFormatMode.this.updateTableDisplay();
                CharFormatMode.this.tableViewer.getTable().redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.vSlider = new Slider(this.charContainer, 512);
        this.vSlider.setBounds(this.tableViewer.getTable().getBounds().width, this.tableViewer.getTable().getBounds().y + 3 * this.tableViewer.getTable().getBorderWidth(), this.getDefaultSizeOfSliders() * 2, this.tableViewer.getTable().getBounds().height);
        this.vSlider.setMinimum(0);
        this.vSlider.setMaximum(PAGE_SIZE - this.getLastIndex() + 11);
        this.vSlider.setIncrement(1);
        this.vSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int vSliderSelection = CharFormatMode.this.vSlider.getSelection();
                int topIndex = CharFormatMode.this.tableViewer.getTable().getTopIndex();
                switch (e.detail) {
                    case 0x1000002: {
                        if (topIndex >= CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size()) break;
                        Object recordObject = CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex);
                        FileMasterRecord topRecord = null;
                        if (!(recordObject instanceof FileMasterRecord)) {
                            return;
                        }
                        topRecord = (FileMasterRecord)recordObject;
                        if (topRecord.isExcluded()) {
                            FileMasterRecord top1Record = (FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + 1);
                            vSliderSelection = top1Record.getNumber() - 1;
                            break;
                        }
                        vSliderSelection = topRecord.getNumber();
                        break;
                    }
                    case 0x1000006: {
                        FileMasterRecord lastRecord = null;
                        if (topIndex + CharFormatMode.this.getLastIndex() - 1 > CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() - 1) {
                            if (CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() - 1) instanceof FileMasterRecord) {
                                lastRecord = (FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() - 1);
                            }
                        } else if (CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + CharFormatMode.this.getLastIndex() - 1) instanceof FileMasterRecord) {
                            lastRecord = (FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + CharFormatMode.this.getLastIndex() - 1);
                        }
                        if (lastRecord == null) break;
                        if (lastRecord.isExcluded()) {
                            if (!(CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + CharFormatMode.this.getLastIndex() - 2) instanceof FileMasterRecord)) break;
                            FileMasterRecord last1Record = (FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + CharFormatMode.this.getLastIndex() - 2);
                            vSliderSelection = last1Record.getNumber() + lastRecord.getNumberOfExcludedLines() - 1;
                            break;
                        }
                        if (lastRecord.getNumber() == 0) {
                            vSliderSelection += CharFormatMode.this.getLastIndex();
                            break;
                        }
                        vSliderSelection = lastRecord.getNumber() - 1;
                        break;
                    }
                    case 0x1000005: {
                        int offset = 0;
                        if (topIndex + 1 < CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() && CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex + 1) instanceof FileMasterRecord) {
                            vSliderSelection = ((FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex)).getNumber();
                        } else if (CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex) instanceof FileMasterRecord) {
                            vSliderSelection = ((FileMasterRecord)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.get(topIndex)).getNumber();
                            offset = 1;
                        } else {
                            return;
                        }
                        CharFormatMode.this.createModel(vSliderSelection, true);
                        if (CharFormatMode.this.fileMasterRecords.size() == 0) {
                            return;
                        }
                        if (CharFormatMode.this.fileMasterRecords.size() <= CharFormatMode.this.getLastIndex()) {
                            offset = 0;
                        }
                        vSliderSelection = ((FileMasterRecord)CharFormatMode.this.fileMasterRecords.get(offset)).getNumber();
                        CharFormatMode.this.vSlider.setSelection(vSliderSelection - 1);
                        CharFormatMode.this.tableViewer.getTable().setTopIndex(vSliderSelection - 1);
                        CharFormatMode.this.initOldarrayFMRecord();
                        int count = 0;
                        while (count < CharFormatMode.this.fileMasterRecords.size()) {
                            if (vSliderSelection + count - 1 < CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size() && count + offset < CharFormatMode.this.fileMasterRecords.size()) {
                                CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.set(vSliderSelection - 1 + count, CharFormatMode.this.fileMasterRecords.get(count + offset));
                            }
                            ++count;
                        }
                        CharFormatMode.this.tableViewer.setInput((Object)CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new Object[CharFormatMode.this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
                        CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
                        CharFormatMode.this.setUpdateCurrentDisplay(false);
                        CharFormatMode.this.setCallMF(false);
                        return;
                    }
                }
                CharFormatMode.this.vSlider.setSelection(vSliderSelection);
                CharFormatMode.this.tableViewer.getTable().setTopIndex(vSliderSelection);
                if (CharFormatMode.this.askForRecordCount && CharFormatMode.this.vSlider.getSelection() > CharFormatMode.this.vSlider.getMaximum() - CharFormatMode.this.getLastIndex()) {
                    CharFormatMode.this.updateRealRecordCount(true, 1);
                }
                CharFormatMode.this.log.log(Level.INFO, "vbar changed");
                CharFormatMode.this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                CharFormatMode.this.setUpdateCurrentDisplay(true);
                CharFormatMode.this.setCallMF(true);
                CharFormatMode.this.tableViewer.getTable().notifyListeners(36, CharFormatMode.this.prevEvent);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void updateTableDisplay() {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().setRedraw(false);
            int displayWidth = this.tableViewer.getTable().getBounds().width;
            int startOfDisplay = this.hSlider.getSelection() + 10 * this.getPixelSizeOfCharacter();
            int startOfData_inChar = this.hSlider.getSelection() / this.getPixelSizeOfCharacter();
            int endOfData_inChar = startOfData_inChar + this.tableViewer.getTable().getBounds().width / this.getPixelSizeOfCharacter() - 10;
            int preserveCol = this.tableViewer.getTable().getColumnCount();
            int i = preserveCol - 1;
            while (i >= 0) {
                this.tableViewer.getTable().getColumn(i).dispose();
                --i;
            }
            i = 0;
            while (i < 2) {
                switch (i) {
                    case 0: {
                        this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                        this.tableviewerColumn.getColumn().setText(" ");
                        this.tableviewerColumn.getColumn().setWidth(10 * this.getPixelSizeOfCharacter());
                        this.getLineNumber(this.tableViewer, this.tableviewerColumn, startOfDisplay / this.getPixelSizeOfCharacter());
                        break;
                    }
                    default: {
                        this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
                        this.tableviewerColumn.getColumn().setWidth(displayWidth - 10 * this.getPixelSizeOfCharacter());
                        this.getDataChar(this.tableViewer, this.tableviewerColumn, 1, startOfData_inChar, endOfData_inChar);
                    }
                }
                ++i;
            }
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    public void setSelectionData() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        HashMap<Integer, FileMasterRecord> newSelectionData = new HashMap<Integer, FileMasterRecord>();
        int i = 0;
        while (i < selectedItems.length) {
            int itemIndex = this.tableViewer.getTable().indexOf(selectedItems[i]);
            FMPCursor fmpCursor = this.getEditorView().getCursor();
            if (itemIndex >= 0) {
                fmpCursor.setRecordNumber(itemIndex + 1);
                this.getEditorView().setCursor(fmpCursor);
            }
            if (selectedItems[i].getData() != null && selectedItems[i].getData() instanceof FileMasterRecord) {
                if (((FileMasterRecord)selectedItems[i].getData()).getNumber() != 0) {
                    newSelectionData.put(itemIndex, (FileMasterRecord)selectedItems[i].getData());
                } else if (this.selectionData.get(itemIndex) != null) {
                    newSelectionData.put(itemIndex, this.selectionData.get(itemIndex));
                } else {
                    this.tableViewer.getTable().deselect(itemIndex);
                }
            } else if (this.selectionData.get(itemIndex) != null) {
                newSelectionData.put(itemIndex, this.selectionData.get(itemIndex));
            } else {
                this.tableViewer.getTable().deselect(itemIndex);
            }
            ++i;
        }
        this.selectionData = newSelectionData;
    }

    private void initOldarrayFMRecord() {
        this.fileMasterRecordsUsedAsInputByTableViewer = new ArrayList();
        int i = 0;
        while (i < ORIGINAL_PAGE_SIZE) {
            this.fileMasterRecordsUsedAsInputByTableViewer.add(null);
            ++i;
        }
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int startOfData_inChar = this.hSlider.getSelection() / this.getPixelSizeOfCharacter();
        int endOfData_inChar = startOfData_inChar + this.tableViewer.getTable().getBounds().width / this.getPixelSizeOfCharacter();
        this.tableviewerColumn = new TableViewerColumn(viewer, 16384);
        this.tableviewerColumn.getColumn().setText(TITLE_LINE_NUMBER);
        this.tableViewer.getTable().setRedraw(false);
        this.tableviewerColumn.getColumn().setWidth(10 * this.getPixelSizeOfCharacter());
        this.tableViewer.getTable().setRedraw(true);
        this.tableviewerColumn.getColumn().setResizable(true);
        this.getLineNumber(viewer, this.tableviewerColumn, 0);
        this.tableviewerColumn = new TableViewerColumn(this.tableViewer, 16384);
        this.tableViewer.getTable().setRedraw(false);
        this.tableviewerColumn.getColumn().setWidth(this.tableViewer.getTable().getBounds().width);
        this.tableViewer.getTable().setRedraw(true);
        this.tableviewerColumn.getColumn().setText(TITLE_DATA_CHAR);
        this.characterDataEditingSupport = null;
        this.getDataChar(this.tableViewer, this.tableviewerColumn, 1, startOfData_inChar, endOfData_inChar);
    }

    private void getDataChar(TableViewer viewer, TableViewerColumn tableViewerColumn, int columnNumber, int startSubString, int endSubString) {
        int finalEndSubString = endSubString - 1;
        tableViewerColumn.setLabelProvider((CellLabelProvider)new EditorLabelProvider(this.editorView.font, this, viewer, columnNumber, startSubString, finalEndSubString, this.currentRecordLength));
        if (this.characterDataEditingSupport == null) {
            this.characterDataEditingSupport = new CharacterDataEditingSupport(this, viewer, columnNumber, true, startSubString, finalEndSubString);
        } else {
            this.characterDataEditingSupport.subStringEndIndex = finalEndSubString;
            this.characterDataEditingSupport.subStringBeginIndex = startSubString;
        }
        tableViewerColumn.setEditingSupport((EditingSupport)this.characterDataEditingSupport);
    }

    private void getLineNumber(final TableViewer viewer, TableViewerColumn tableViewerColumn, int subStringIndex) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new CharLineNumLabelProvider(this.editorView.font, false, subStringIndex));
        tableViewerColumn.setEditingSupport(new EditingSupport(tableViewerColumn.getViewer()){

            protected void setValue(Object element, Object newName) {
                if (element instanceof FileMasterRecord) {
                    FileMasterRecord m = (FileMasterRecord)element;
                    if (newName != null && !newName.toString().isEmpty() && newName.toString().startsWith(".", 0)) {
                        if (newName.toString().length() > 7) {
                            newName = newName.toString().subSequence(0, 6);
                        }
                        m.setLabelForRecord((String)newName);
                    }
                    viewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof FileMasterRecord) {
                    FileMasterRecord m = (FileMasterRecord)element;
                    return String.format("%06d", m.getNumber());
                }
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                int limit = 6;
                TextCellEditor textEditor = new TextCellEditor((Composite)viewer.getTable());
                if (element instanceof FileMasterRecord) {
                    FileMasterRecord m = (FileMasterRecord)element;
                    FMPCursor fmpCursor = new FMPCursor(m.getNumber(), "", 1, 0);
                    CharFormatMode.this.editorView.setCursor(fmpCursor);
                    limit = ((FileMasterRecordField)m.getRecordFields().get(0)).getMaxLengthP();
                    if (limit == 0) {
                        limit = 6;
                    }
                }
                ((Text)textEditor.getControl()).setTextLimit(limit);
                textEditor.getControl().addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        (this).CharFormatMode.this.editorView.getCursor().setCursorOffset(CharFormatMode.this.cursorPosition);
                    }
                });
                return textEditor;
            }

            protected boolean canEdit(Object element) {
                if (element instanceof FileMasterRecord) {
                    FileMasterRecord filemasterRecord = (FileMasterRecord)element;
                    FMPCursor fmpCursor = new FMPCursor(filemasterRecord.getNumber(), "", 1, 0);
                    CharFormatMode.this.editorView.setCursor(fmpCursor);
                }
                return false;
            }
        });
    }

    private void buildInputForViewer(XMLRequest xmlResponse) {
        this.updateCurrentDS();
        this.initOldarrayFMRecord();
        if (this.fileMasterRecords != null) {
            this.fileMasterRecords.clear();
        }
        FileMasterRecord fileMasterRecord = new FileMasterRecord();
        int exludedRecords = 0;
        int keyPosition = 0;
        int keyLength = 0;
        if (xmlResponse != null && xmlResponse.getRoot().getNodeName().equals(Constants.ELEMENT_GUI_RESPONSE)) {
            NodeList recordList;
            String EmptyDataset;
            Element element = xmlResponse.getRoot();
            NodeList messageList = element.getElementsByTagName("Message");
            if (messageList.getLength() > 0 && (EmptyDataset = CharFormatMode.getTagValue("Message", (Element)messageList.item(0))).contains("CAWA725W")) {
                MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Information", (String)"This data set does not contain any records. To insert a record, use the Insert Record menu option");
            }
            if ((recordList = element.getElementsByTagName(Constants.ELEMENT_RECORD_LIST)).getLength() > 0) {
                this.hexDisplay = ((Element)recordList.item(0)).getAttribute(Constants.ATTRIBUTE_HEX);
            }
            NodeList nodeListRecord = element.getElementsByTagName(Constants.ELEMENT_RECORD);
            element.getAttribute(Constants.ATTRIBUTE_HEX);
            if (nodeListRecord.getLength() > 0) {
                this.fileMasterRecords = new ArrayList();
                if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength().isEmpty() && Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength()) > 0) {
                    keyPosition = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset());
                    keyLength = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength());
                }
                this.fileMasterRecords = new ArrayList();
                int i = 0;
                while (i < nodeListRecord.getLength()) {
                    FileMasterRecordField fileMasterRecordField;
                    fileMasterRecord = new FileMasterRecord();
                    exludedRecords = 0;
                    int recordNumber = Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_NUMBER));
                    fileMasterRecord.setNumber(recordNumber);
                    if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_RRN)) {
                        fileMasterRecord.setRRN(Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_RRN)));
                    }
                    if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_STATUS)) {
                        String recordStatus = ((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_STATUS);
                        fileMasterRecord.setStatus(recordStatus);
                    }
                    fileMasterRecord.setLastRecord(false);
                    String eof = ((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_EOF);
                    if (eof.endsWith("Y")) {
                        fileMasterRecord.setLastRecord(true);
                        PAGE_SIZE = fileMasterRecord.getNumber() + this.getLastIndex() - 2;
                        this.setTableSize(PAGE_SIZE + 1);
                        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
                        FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
                        fileMasterSession.setRecordCount(fileMasterRecord.getNumber());
                        this.askForRecordCount = false;
                    }
                    if (((Element)nodeListRecord.item(i)).hasAttribute(Constants.ATTRIBUTE_EXCLUDED)) {
                        fileMasterRecordField = new FileMasterRecordField();
                        fileMasterRecord.setExcluded(true);
                        exludedRecords = Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_EXCLUDED));
                        fileMasterRecordField.setCharData(String.valueOf(exludedRecords) + " Line(s) not Displayed");
                        fileMasterRecord.setNumberOfExcludedLines(exludedRecords);
                        fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                        this.fileMasterRecords.add(fileMasterRecord);
                    } else {
                        fileMasterRecord.setExcluded(false);
                        fileMasterRecord.setLength(Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute(Constants.ATTRIBUTE_LENGTH)));
                        Element recordField = (Element)((Element)((Element)nodeListRecord.item(i)).getElementsByTagName(Constants.ELEMENT_RECORD_FIELDS).item(0)).getElementsByTagName(Constants.ELEMENT_RECORD_FIELD).item(0);
                        if (recordField != null) {
                            NodeList protectedList;
                            fileMasterRecordField = new FileMasterRecordField();
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_POSITION)) {
                                fileMasterRecordField.setPosition(Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_POSITION)));
                            }
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_MAX_LENGTH_P)) {
                                fileMasterRecordField.setMaxLengthP(recordField.getAttribute(Constants.ATTRIBUTE_MAX_LENGTH_P));
                                if (fileMasterRecordField.getMaxLengthP() > this.currentRecordLength) {
                                    this.currentRecordLength = fileMasterRecordField.getMaxLengthP() + 3;
                                }
                            }
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_MAX_LENGTH_D)) {
                                fileMasterRecordField.setMaxLengthD(recordField.getAttribute(Constants.ATTRIBUTE_MAX_LENGTH_D));
                            }
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_ID)) {
                                fileMasterRecordField.setId(recordField.getAttribute(Constants.ATTRIBUTE_ID));
                            }
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_CHARDATAHEX)) {
                                fileMasterRecordField.setCharDataHex(recordField.getAttribute(Constants.ATTRIBUTE_CHARDATAHEX));
                            }
                            if (recordField.hasAttribute(Constants.ATTRIBUTE_CURSOR) && !this.editorView.getIsLineCommand()) {
                                this.log.log(Level.INFO, "recordField has cursor");
                                fileMasterRecordField.setCursorEnabled(true);
                                if (!this.isLocate) {
                                    fileMasterRecordField.setCursor(Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_CURSOR)));
                                }
                                this.tableLineNumber = fileMasterRecord.getNumber() - 1;
                            }
                            if ((protectedList = recordField.getElementsByTagName(Constants.ELEMENT_PROTECTED_LIST)).getLength() > 0) {
                                NodeList protectedNodeList = ((Element)protectedList.item(0)).getElementsByTagName(Constants.ELEMENT_RANGE);
                                int countProtectedList = 0;
                                while (countProtectedList < protectedNodeList.getLength()) {
                                    Element rangeElement = (Element)protectedNodeList.item(countProtectedList);
                                    FMPRange range = null;
                                    range = rangeElement.hasAttribute(Constants.ATTRIBUTE_HEX) ? new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), rangeElement.getAttribute(Constants.ATTRIBUTE_HEX)) : new FMPRange(rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_START), rangeElement.getAttribute(Constants.ATTRIBUTE_RANGE_END), "N");
                                    fileMasterRecordField.addProtectedRange(range);
                                    ++countProtectedList;
                                }
                            }
                            fileMasterRecordField.getLayoutField().setId(recordField.getAttribute(Constants.ATTRIBUTE_ID));
                            NodeList findList = recordField.getElementsByTagName(Constants.ELEMENT_FIND_LIST);
                            this.setUpFindListRange(fileMasterRecord, fileMasterRecordField, findList);
                            String charData = "";
                            if (recordField.getElementsByTagName(Constants.ELEMENT_CHAR_DATA).item(0).getFirstChild() != null) {
                                charData = recordField.getElementsByTagName(Constants.ELEMENT_CHAR_DATA).item(0).getFirstChild().getTextContent();
                            } else {
                                char[] array = new char[fileMasterRecord.getLength()];
                                Arrays.fill(array, ' ');
                                charData = new String(array);
                            }
                            if (EditorWizardPageOne.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && (EditorWizardPageOne.dataSet.getDsType().equalsIgnoreCase("K") || EditorWizardPageOne.dataSet.getDsType().equalsIgnoreCase("T"))) {
                                if (keyPosition == 1) {
                                    if (charData.length() == keyLength) {
                                        String vsamKey = charData.substring(keyPosition - 1, keyLength);
                                        this.log.log(Level.INFO, "1 vsamKey: " + vsamKey);
                                        fileMasterRecordField.setVsamKey(vsamKey);
                                    } else {
                                        fileMasterRecordField.setVsamKey(charData.substring(keyPosition - 1, keyLength));
                                    }
                                } else if (keyPosition > 0) {
                                    fileMasterRecordField.setVsamKey(charData.substring(keyPosition - 1, keyPosition + keyLength - 1));
                                }
                                fileMasterRecordField.setKeyPosition(String.valueOf(keyPosition));
                            }
                            fileMasterRecordField.setCharData(charData);
                            if (recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA).getLength() > 0) {
                                String hexData1 = recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA).item(0).getFirstChild().getTextContent();
                                fileMasterRecordField.setHexData1(hexData1);
                                String hexData2 = recordField.getElementsByTagName(Constants.ELEMENT_HEX_DATA2).item(0).getFirstChild().getTextContent();
                                fileMasterRecordField.setHexData2(hexData2);
                            }
                            fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                        }
                        this.fileMasterRecords.add(fileMasterRecord);
                    }
                    ++i;
                }
            }
        } else if (xmlResponse != null && xmlResponse.getRoot().getNodeName().equals(Constants.ELEMENT_MF_REQUEST)) {
            this.editorView.ParsingMFRequest(xmlResponse);
        }
    }

    public void setXmlResponse(XMLRequest xml) {
        int vSliderSel = 0;
        if (!this.vSlider.isDisposed()) {
            vSliderSel = this.vSlider.getSelection();
        }
        if (ORIGINAL_PAGE_SIZE > 0) {
            CharFormatMode.resetRecordCount();
        }
        this.updateCurrentDS();
        this.buildInputForViewer(xml);
        this.setTableSize(PAGE_SIZE + 1);
        if (this.updateDisplay) {
            this.setUpdateCurrentDisplay(true);
            if (this.fileMasterRecords != null && this.fileMasterRecords.size() > 0) {
                this.updateTbl(((FileMasterRecord)this.fileMasterRecords.get(0)).getNumber(), ((FileMasterRecord)this.fileMasterRecords.get(0)).getNumber(), ((FileMasterRecord)this.fileMasterRecords.get(this.fileMasterRecords.size() - 1)).getNumber());
            }
        } else {
            this.setUpdateCurrentDisplay(false);
        }
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.refresh();
        }
        if (this.prevEvent != null) {
            if (this.fileMasterRecords != null && this.fileMasterRecords.size() > 0 && this.isLocate) {
                this.prevEvent.index = ((FileMasterRecord)this.fileMasterRecords.get(0)).getNumber();
                if (this.prevEvent.index % COUNT != 0) {
                    if (this.prevEvent.index > this.currentIndex) {
                        ++this.prevEvent.index;
                    } else {
                        this.dispUp = true;
                    }
                }
            }
            if (this.dispMessage && this.isLocate) {
                this.dispMessage = false;
            }
        }
        if (this.isLocate || this.isFind() || this.isSwitch || this.isExcluded) {
            this.isLocate = false;
            this.isSwitch = false;
            if (this.isExcluded) {
                this.isExcluded = false;
                if (this.tableLineNumber > 0 && this.fileMasterRecordsUsedAsInputByTableViewer.get(this.tableLineNumber - 1) instanceof FileMasterRecord) {
                    this.setSelection(this.tableViewer, this.tableLineNumber - 1);
                }
                if (this.tableLineNumber >= this.tableViewer.getTable().getTopIndex() + this.getLastIndex()) {
                    this.tableViewer.getTable().setTopIndex(this.tableLineNumber - 1);
                    this.vSlider.setSelection(this.tableLineNumber - 1);
                    if (this.tableViewer.getTable().getTopIndex() + this.getLastIndex() < this.fileMasterRecordsUsedAsInputByTableViewer.size() && this.fileMasterRecordsUsedAsInputByTableViewer.get(this.tableViewer.getTable().getTopIndex() + this.getLastIndex()) instanceof FileMasterRecord) {
                        if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(this.tableViewer.getTable().getTopIndex() + this.getLastIndex())).getRecordFields().size() == 0) {
                            this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;
                            this.setUpdateCurrentDisplay(true);
                            this.setCallMF(true);
                        } else {
                            this.setCallMF(false);
                        }
                    }
                } else {
                    this.setCallMF(false);
                }
            } else {
                this.setSelection(this.tableViewer, this.tableLineNumber);
                this.tableViewer.getTable().setTopIndex(this.tableLineNumber);
                this.vSlider.setSelection(this.tableLineNumber);
            }
        }
        if (this.isReset) {
            this.isReset = false;
        }
        if (this.isFlip) {
            this.isFlip = false;
        }
        if (!this.tableViewer.getTable().isDisposed()) {
            this.currentIndex = this.tableViewer.getTable().getTopIndex();
            this.vSlider.setSelection(this.tableViewer.getTable().getTopIndex());
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private List<FileMasterRecord> createModel(int offset, boolean directionUp) {
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        this.log.log(Level.INFO, "secondarId" + secondaryID);
        FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
        if (fileMasterSession == null) {
            this.log.log(Level.INFO, "fileMasterSession is null");
            return this.fileMasterRecords;
        }
        RunGetGetRecords runner = directionUp ? new RunGetGetRecords(fileMasterSession.getServer(), fileMasterSession.getUuid(), offset, this.getLastIndex(), "UP", "C", fileMasterSession.getHexMode()) : new RunGetGetRecords(fileMasterSession.getServer(), fileMasterSession.getUuid(), offset, this.getLastIndex(), "C", fileMasterSession.getHexMode());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        this.buildInputForViewer(xmlResponse);
        return this.fileMasterRecords;
    }

    @Override
    public void run() {
        int currentIndex = this.oldIndex;
        try {
            this.execute = false;
            Thread.sleep(700L);
            if (this.isUpdateCurrentDisplay()) {
                while (currentIndex != this.oldIndex) {
                    Thread.sleep(700L);
                    currentIndex = this.oldIndex;
                }
            } else {
                Thread.sleep(700L);
                currentIndex = this.oldIndex;
            }
            this.execute = true;
            Display.getDefault().asyncExec(this.getChunk);
            return;
        }
        catch (InterruptedException e) {
            this.log.log(Level.INFO, "InterruptedException occurred");
            return;
        }
    }

    private void updateTbl(int startingRowNumber, int start, int end) {
        this.log.log(Level.INFO, "cursor/start/end: " + this.tableLineNumber + ":" + start + ":" + end);
        int[] selection = this.tableViewer.getTable().getSelectionIndices();
        this.setUpdateCurrentDisplay(false);
        if (this.isCallMF()) {
            this.createModel(start, false);
            this.updateTableDisplay();
            if (!this.tableViewer.getTable().isDisposed()) {
                this.tableViewer.getTable().redraw();
                this.vSlider.setMaximum(PAGE_SIZE - this.getLastIndex() + 11);
                this.vSlider.setSelection(this.tableViewer.getTable().getTopIndex());
            }
        }
        start = startingRowNumber;
        int count = 0;
        while (count < this.fileMasterRecords.size()) {
            if (start + count < this.fileMasterRecordsUsedAsInputByTableViewer.size() + 1) {
                this.fileMasterRecordsUsedAsInputByTableViewer.set(start + count - 1, this.fileMasterRecords.get(count));
                ((FileMasterRecord)this.fileMasterRecords.get(count)).setTableRowNumber(start + count - 1);
            }
            ++count;
        }
        if (!this.isContentProviderSet()) {
            this.setContentProvider();
        }
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.setInput((Object)this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new Object[this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
            int i = start - 1;
            while (i < end - 1) {
                if (i < this.tableViewer.getTable().getItemCount()) {
                    TableItem tableItem = this.tableViewer.getTable().getItem(i);
                    if (i < this.fileMasterRecordsUsedAsInputByTableViewer.size() && this.fileMasterRecordsUsedAsInputByTableViewer.get(i) instanceof FileMasterRecord) {
                        if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).getRecordFields().size() > 0) {
                            String charData = ((FileMasterRecordField)((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).getRecordFields().get(0)).getCharData();
                            tableItem.setText(charData);
                        }
                        if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).isLastRecord()) break;
                    }
                }
                ++i;
            }
            if (this.fileMasterRecordsUsedAsInputByTableViewer.size() == 0) {
                this.setTableSize(0);
            } else {
                i = 0;
                while (i < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                    if (this.fileMasterRecordsUsedAsInputByTableViewer.get(i) instanceof FileMasterRecord && ((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).isLastRecord()) {
                        this.setTableSize(i + this.getLastIndex());
                        break;
                    }
                    ++i;
                }
            }
            if (this.isLocate) {
                if (this.dispUp) {
                    this.dispUp = false;
                    this.setSelection(this.tableViewer, this.tableLineNumber);
                    this.getChunk(this.tableLineNumber + 5);
                } else {
                    this.setSelection(this.tableViewer, this.tableLineNumber);
                }
            }
            this.tableViewer.refresh();
            this.tableViewer.getTable().deselectAll();
            this.tableViewer.getTable().select(selection);
            if (!this.tableViewer.getTable().isFocusControl()) {
                this.tableViewer.getTable().setFocus();
            }
        }
        if (!this.tableViewer.getTable().isDisposed() && this.tableViewer.getTable().getSelection().length > 0 && this.selectionData.isEmpty() && this.tableViewer.getTable().getSelection()[0].getData() instanceof FileMasterRecord) {
            this.selectionData.put(0, (FileMasterRecord)this.tableViewer.getTable().getSelection()[0].getData());
        }
        if (this.editorView.getIsLineCommand() && this.startRownumber > 0 && this.startRownumber != startingRowNumber) {
            this.updateCurrentDisplay = true;
        }
        this.editorView.updateRecordRangeStatus("C");
        if (this.isLocate) {
            this.setUpdateCurrentDisplay(true);
            this.setCallMF(true);
        }
        if (this.isFlip) {
            this.isFlip = false;
            this.tableViewer.getTable().setTopIndex(start - 1 < 0 ? 0 : start - 1);
        }
    }

    private void getChunk(int currentIndex) {
        if (this.dontExecuteGetChunkWhenOpeningDataSet) {
            this.dontExecuteGetChunkWhenOpeningDataSet = false;
            return;
        }
        if (this.dontExecuteGetChunkAfterExcludeAllClick) {
            this.dontExecuteGetChunkAfterExcludeAllClick = false;
            return;
        }
        this.startRownumber = currentIndex + 1;
        if (this.currentIndex != currentIndex || this.isUpdateCurrentDisplay()) {
            int index = currentIndex;
            int start = index + 1;
            int end = start + COUNT - 1;
            if (!this.tableViewer.getTable().isDisposed()) {
                if (end > this.tableViewer.getTable().getItemCount()) {
                    this.setTableSize(end + 1);
                }
                if (start <= this.tableViewer.getTable().getItemCount()) {
                    this.updateTbl(this.startRownumber, start, end);
                }
            }
            if (this.currentStartVal == this.currentLastVal && this.currentStartVal == 0) {
                this.currentStartVal = start;
                this.currentLastVal = end;
            }
            if (this.isCallMF()) {
                this.currentIndex = currentIndex;
            }
            this.setCallMF(true);
            this.log.log(Level.INFO, "currentIndex after" + currentIndex);
        }
    }

    private int getRecordCount(FileMasterServer server, int recordCount) {
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        String uuid = this.editorView.getCurrentSession(secondaryID).getUuid();
        String displayMode = this.editorView.getCurrentSession(secondaryID).getDisplayMode();
        RunGetGetRecords runner = new RunGetGetRecords(server, uuid, -1, recordCount, displayMode, "N");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        Element element = xmlResponse.getRoot();
        NodeList nodeListRecord = element.getElementsByTagName("Record");
        if (nodeListRecord.getLength() > 0) {
            return Integer.parseInt(((Element)nodeListRecord.item(nodeListRecord.getLength() - 1)).getAttribute("number"));
        }
        return 0;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue == null) {
            return "";
        }
        return nValue.getNodeValue();
    }

    public int getStart() {
        return this.currentStartVal + COUNT;
    }

    public int getEnd() {
        return this.currentLastVal;
    }

    public boolean isUpdateCurrentDisplay() {
        return this.updateCurrentDisplay;
    }

    public void setUpdateCurrentDisplay(boolean updateCurrentDisplay) {
        this.updateCurrentDisplay = updateCurrentDisplay;
    }

    public boolean isHexMode() {
        return this.isHexMode;
    }

    public void setHexMode(boolean isHexMode) {
        this.isHexMode = isHexMode;
    }

    public String isHexDisplay() {
        if (this.hexDisplay == null) {
            return "";
        }
        return this.hexDisplay;
    }

    private boolean isContentProviderSet() {
        if (this.tableViewer == null) {
            return false;
        }
        return this.tableViewer.getContentProvider() != null;
    }

    private void setContentProvider() {
        if (this.tableViewer != null) {
            this.tableViewer.setContentProvider((IContentProvider)new EditorContentProvider(this.tableViewer));
        }
    }

    public void setCursor(int cursor) {
        this.tableLineNumber = cursor - 1;
    }

    public void setLocate(boolean isLocate) {
        this.isLocate = isLocate;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public void clearHits() {
        this.hitNumber = -1;
        this.hitIndex = -1;
    }

    public FileMasterRecord getFirstVisibleRecord() {
        return (FileMasterRecord)this.fileMasterRecords.get(0);
    }

    public int getHitNumber() {
        return this.hitNumber;
    }

    public void setHitNumber(int hitNumber) {
        this.hitNumber = hitNumber;
    }

    public ArrayList<FileMasterRecord> getArrayFmRecord() {
        return this.fileMasterRecords;
    }

    public void setSelection(TableViewer tableViewer, int selectionIndex) {
        FMPCursor cursor = this.editorView.getCursor();
        int recordNumber = selectionIndex + 1;
        this.log.log(Level.INFO, "setting recordNumber to: " + recordNumber);
        tableViewer.getTable().setSelection(selectionIndex);
        if (this.isLocate) {
            cursor.setCursorOffset(1);
        }
        cursor.setRecordNumber(recordNumber);
        this.editorView.setCursor(cursor);
    }

    public void setHighlight(int lineNumber, int rangeIndex) {
        this.hitNumber = lineNumber;
        this.hitIndex = rangeIndex;
        this.tableLineNumber = lineNumber - 1;
        this.tableViewer.getTable().setSelection(this.hitNumber - 1);
        this.editorView.getCursor().setRecordNumber(this.hitNumber);
    }

    public void setHightlightAll(int lineNumber) {
        FMPCursor cursor = this.editorView.getCursor();
        this.hitNumber = -1;
        this.hitIndex = -1;
        this.tableLineNumber = lineNumber - 1;
        this.tableViewer.refresh();
        this.tableViewer.getTable().setTopIndex(lineNumber - 1);
        this.tableViewer.getTable().setSelection(lineNumber - 1);
        this.vSlider.setSelection(lineNumber - 1);
        cursor.setRecordNumber(lineNumber);
        this.editorView.setCursor(cursor);
    }

    public int getHitIndex() {
        return this.hitIndex;
    }

    public static void resetRecordCount() {
        PAGE_SIZE = ORIGINAL_PAGE_SIZE;
    }

    public void updateItemCount() {
        this.setTableSize(PAGE_SIZE + 1);
    }

    public boolean isSequentialSelection() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        boolean cnd_1 = false;
        boolean cnd_2 = false;
        int i = 0;
        while (i < selectedItems.length - 1) {
            int index_i = this.tableViewer.getTable().indexOf(selectedItems[i]);
            int index_i_plus_1 = this.tableViewer.getTable().indexOf(selectedItems[i + 1]);
            boolean bl = cnd_1 = !this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + 1;
            if (this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" ")))) {
                cnd_2 = true;
            }
            if (cnd_1 || cnd_2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int firstSelected() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            return this.selectionData.get(this.tableViewer.getTable().indexOf(selectedItems[0])).getNumber();
        }
        return -1;
    }

    public int lastSelected() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[selectedItems.length - 1]);
            if (!this.selectionData.get(index).isExcluded()) {
                return this.selectionData.get(index).getNumber();
            }
            return this.selectionData.get(index).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1;
        }
        return -1;
    }

    public int getRecordCountInSelection() {
        int recordCount = 0;
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[i]);
            if (!this.selectionData.get(index).isExcluded()) {
                ++recordCount;
            } else if (this.selectionData.get(index).isExcluded()) {
                recordCount += Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" ")));
            }
            ++i;
        }
        return recordCount;
    }

    public ArrayList<LineRange> getSelectedRanges() {
        ArrayList<LineRange> ranges = new ArrayList<LineRange>();
        LineRange range = new LineRange();
        boolean isRangeOpen = false;
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0 && !this.selectionData.containsKey(this.tableViewer.getTable().indexOf(selectedItems[0]))) {
            this.setSelectionData();
        }
        if (selectedItems.length == 0) {
            range = new LineRange();
            range.setStart(0);
            range.setEnd(0);
            ranges.add(range);
            return ranges;
        }
        int i = 0;
        while (i < selectedItems.length) {
            int index_i = this.tableViewer.getTable().indexOf(selectedItems[i]);
            if (this.selectionData.get(index_i) != null) {
                if (!isRangeOpen) {
                    range = new LineRange();
                    ranges.add(range);
                    range.setStart(this.selectionData.get(index_i).getNumber());
                    isRangeOpen = true;
                }
                if (i != selectedItems.length - 1) {
                    int index_i_plus_1 = this.tableViewer.getTable().indexOf(selectedItems[i + 1]);
                    boolean cnd_1 = false;
                    boolean cnd_2 = false;
                    boolean bl = cnd_1 = !this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + 1;
                    if (this.selectionData.get(index_i).isExcluded() && this.selectionData.get(index_i_plus_1).getNumber() != this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" ")))) {
                        cnd_2 = true;
                    }
                    if (cnd_1 || cnd_2) {
                        if (!this.selectionData.get(index_i).isExcluded()) {
                            range.setEnd(this.selectionData.get(index_i).getNumber());
                        } else {
                            range.setEnd(this.selectionData.get(index_i).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index_i).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1);
                        }
                        isRangeOpen = false;
                    }
                }
            } else {
                range.setStart(0);
                range.setEnd(0);
                ranges.add(range);
                return ranges;
            }
            ++i;
        }
        if (isRangeOpen) {
            int index = this.tableViewer.getTable().indexOf(selectedItems[selectedItems.length - 1]);
            if (!this.selectionData.get(index).isExcluded()) {
                range.setEnd(this.selectionData.get(index).getNumber());
            } else {
                range.setEnd(this.selectionData.get(index).getNumber() + Integer.parseInt(((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().substring(0, ((FileMasterRecordField)this.selectionData.get(index).getRecordFields().get(0)).getCharData().indexOf(" "))) - 1);
            }
        }
        return ranges;
    }

    public int getSelectedRecordLength() {
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems.length > 0) {
            if (this.selectionData.get(0) != null) {
                if (this.selectionData.get(0).isExcluded()) {
                    return ((EditorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getProfile().getMaxLength();
                }
                return this.selectionData.get(0).getLength();
            }
            return ((EditorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getProfile().getMaxLength();
        }
        return -1;
    }

    public void increaseRecordCount(int numberOfRecords) {
        int i = 0;
        while (i < numberOfRecords) {
            this.fileMasterRecordsUsedAsInputByTableViewer.add(new FileMasterRecord());
            ++i;
        }
    }

    private void updateCurrentDS() {
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        if (this.editorView.getCurrentSession(secondaryID) != null) {
            EditorWizardPageOne.dataSet = this.editorView.getCurrentSession(secondaryID).getDatasets()[0];
        }
    }

    public boolean isOneRecordSelected() {
        return this.tableViewer.getTable().getSelection().length == 1;
    }

    public CharacterDataEditingSupport getCharacterDataEditingSupport() {
        return this.characterDataEditingSupport;
    }

    public void setSwitch(boolean isSwitch) {
        this.isSwitch = isSwitch;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public void updateTableBasedOnFindResult(XMLResponseParser xmlResponseParser) {
        this.initOldarrayFMRecord();
        this.disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
        ArrayList<FileMasterRecord> fileMasterRecords = this.getFileMasterRecordsBasedOnXmlResponseFromMainframe(xmlResponseParser.getXmlRequest());
        int cursor = xmlResponseParser.getCursorPosition();
        int position = xmlResponseParser.getCursorPositionBase();
        int recordNumber = xmlResponseParser.getCursorPositionLineNumber();
        int fieldId = xmlResponseParser.getCursorFieldId();
        int actualPositionOfCursor = position + cursor - 1;
        if (fileMasterRecords.size() == 0) {
            return;
        }
        int start = fileMasterRecords.get(0).getNumber();
        int count = 0;
        while (count < fileMasterRecords.size()) {
            if (start + count < this.fileMasterRecordsUsedAsInputByTableViewer.size() + 1 && (fileMasterRecords.get(count).getNumber() - 1 >= start + count - 1 || fileMasterRecords.get(count).isExcluded())) {
                this.fileMasterRecordsUsedAsInputByTableViewer.set(start + count - 1, fileMasterRecords.get(count));
            }
            ++count;
        }
        this.setTableSize(ORIGINAL_PAGE_SIZE + 1);
        if (this.fileMasterRecordsUsedAsInputByTableViewer.size() == 0) {
            this.setTableSize(0);
        } else {
            int fmRecCount = 0;
            int i = 0;
            while (i < this.fileMasterRecordsUsedAsInputByTableViewer.size()) {
                if (this.fileMasterRecordsUsedAsInputByTableViewer.get(i) instanceof FileMasterRecord) {
                    ++fmRecCount;
                    if (((FileMasterRecord)this.fileMasterRecordsUsedAsInputByTableViewer.get(i)).isLastRecord()) {
                        this.setTableSize(i + this.getLastIndex());
                        break;
                    }
                }
                ++i;
            }
            if (PAGE_SIZE != ORIGINAL_PAGE_SIZE) {
                CharFormatMode.resetRecordCount();
            }
        }
        int topIndex = fileMasterRecords.get(0).getNumber() - 1;
        this.vSlider.setSelection(topIndex);
        this.tableViewer.setInput((Object)this.fileMasterRecordsUsedAsInputByTableViewer.toArray(new Object[this.fileMasterRecordsUsedAsInputByTableViewer.size()]));
        ArrayList rangeLineNumberList = xmlResponseParser.getRangeLineNumber();
        ArrayList rangeBeginList = xmlResponseParser.getRangeBegin();
        ArrayList rangeIndexList = xmlResponseParser.getRangeIndex();
        this.hiliteAllHits = true;
        int x = 0;
        while (x < rangeLineNumberList.size()) {
            int lineNumber = (Integer)rangeLineNumberList.get(x);
            if (lineNumber == recordNumber) {
                int begin = (Integer)rangeBeginList.get(x);
                if (begin == cursor) {
                    int rangeIndex = (Integer)rangeIndexList.get(x);
                    this.setHighlight(lineNumber, rangeIndex);
                }
            } else {
                this.setHighlight(recordNumber, 0);
            }
            ++x;
        }
        this.tableViewer.getTable().setTopIndex(topIndex);
        if (recordNumber != -1) {
            FMPCursor fmpCursor = new FMPCursor(recordNumber, "", 1, actualPositionOfCursor - 1, fieldId);
            this.editorView.setCursor(fmpCursor);
        }
        if (actualPositionOfCursor > -1 && (actualPositionOfCursor + 1 <= this.startOfData_inChar || actualPositionOfCursor + 1 >= this.endOfData_inChar)) {
            this.HScrollToChar(actualPositionOfCursor - 1);
        }
    }

    private void HScrollToChar(int charPos) {
        this.hSlider.setSelection(charPos * this.getPixelSizeOfCharacter());
        this.hSlider.notifyListeners(13, new Event());
    }

    private void setSliderAttr() {
        this.hSlider.setEnabled(true);
        this.startOfData_inChar = this.hSlider.getSelection() / this.getPixelSizeOfCharacter() + 1;
        this.endOfData_inChar = this.startOfData_inChar + this.tableViewer.getTable().getBounds().width / this.getPixelSizeOfCharacter() - 10 - 2;
        this.hSlider.setMaximum(this.currentRecordLength * this.getPixelSizeOfCharacter() - (this.tableViewer.getTable().getBounds().width - 10 * this.getPixelSizeOfCharacter()));
        this.hSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.hSlider.setBounds(2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().width, this.getDefaultSizeOfSliders() * 2);
        this.vSlider.setBounds(this.tableContainer.getBounds().width + this.tableViewer.getTable().getBorderWidth() * 2, this.tableViewer.getTable().getBounds().y + 3 * this.tableViewer.getTable().getBorderWidth(), this.getDefaultSizeOfSliders() * 2, this.tableViewer.getTable().getBounds().height);
        this.vSlider.setMaximum(PAGE_SIZE - this.getLastIndex() + 11);
        this.vSlider.setIncrement(1);
        this.vSlider.setPageIncrement(this.getLastIndex());
        if (this.endOfData_inChar - this.startOfData_inChar > this.currentRecordLength - 4 && this.startOfData_inChar == 1) {
            this.hSlider.setEnabled(false);
        }
        this.getEditorView().getStatusLineRecordNumberRangeInfo().setText("Columns: " + this.startOfData_inChar + "-" + Math.min(this.endOfData_inChar, this.currentRecordLength - 3));
    }

    protected int getHSliderSel() {
        if (!this.hSlider.isDisposed()) {
            return this.hSlider.getSelection();
        }
        return 0;
    }

    protected void setHSliderSel(int value) {
        this.hSlider.setSelection(value);
        this.hSlider.notifyListeners(13, new Event());
    }

    protected void setVSliderSel(int value) {
        this.vSlider.setSelection(value);
        this.vSlider.notifyListeners(13, new Event());
    }

    public void updateRealRecordCount(boolean doInitOldarrayFMRecord, int recordCount) {
        if (this.editorView.getCurrentSession(this.secondaryID).getRecordCount() == 0) {
            return;
        }
        PAGE_SIZE = this.getRecordCount(this.editorView.getActiveServer(), recordCount);
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
        fileMasterSession.setRecordCount(PAGE_SIZE);
        ORIGINAL_PAGE_SIZE = PAGE_SIZE;
        this.vSlider.setMaximum(PAGE_SIZE + 9);
        if (doInitOldarrayFMRecord) {
            this.initOldarrayFMRecord();
        }
        this.askForRecordCount = false;
        this.currentIndex = this.tableViewer.getTable().getTopIndex();
    }

    private void setTableSize(int value) {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().setItemCount(value);
        }
    }

    public FileMasterRecordField getFileMasterRecordField() {
        return this.fileMasterRecordField;
    }

    public void setFileMasterRecordField(FileMasterRecordField fileMasterRecordField) {
        this.fileMasterRecordField = fileMasterRecordField;
    }

    public void setDontExecuteGetChunkAfterExcludeAllClick(boolean dontExecuteGetChunkAfterExcludeAllClick) {
        this.dontExecuteGetChunkAfterExcludeAllClick = dontExecuteGetChunkAfterExcludeAllClick;
    }
}

