/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FormatMode {
    protected Composite parent;
    protected EditorView editorView;
    private int pixelSizeOfCharacter = -1;
    private int maximumNumberOfCharactersPerColumn = -1;
    private MenuManager menuManager;
    private boolean isFind = false;
    private boolean callMF = false;
    public boolean bypassFocusLost = false;
    private Shell shell;
    private Text text;
    private GC gc;
    protected boolean disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = false;

    public FormatMode(Composite parent, EditorView editorView) {
        this.parent = parent;
        this.editorView = editorView;
    }

    public EditorView getEditorView() {
        return this.editorView;
    }

    protected int getPixelSizeOfCharacter() {
        if (this.pixelSizeOfCharacter == -1) {
            if (this.shell == null) {
                this.shell = new Shell(Display.getDefault());
            }
            if (this.text == null) {
                this.text = new Text((Composite)this.shell, 0);
            }
            this.text.setFont(this.editorView.font);
            if (this.gc == null) {
                this.gc = new GC((Drawable)this.text);
            }
            this.pixelSizeOfCharacter = this.gc.textExtent((String)"W").x;
        }
        return this.pixelSizeOfCharacter;
    }

    protected int getDefaultSizeOfSliders() {
        if (this.shell == null) {
            this.shell = new Shell(Display.getDefault());
        }
        if (this.text == null) {
            this.text = new Text((Composite)this.shell, 0);
        }
        this.text.setFont(this.editorView.font);
        if (this.gc == null) {
            this.gc = new GC((Drawable)this.text);
        }
        return this.gc.textExtent((String)"W").x;
    }

    protected int getMaximumNumberOfCharactersPerColumn() {
        if (this.maximumNumberOfCharactersPerColumn == -1) {
            int x = 32752 / this.getPixelSizeOfCharacter();
            this.maximumNumberOfCharactersPerColumn = x >= 1000 ? x / 1000 * 1000 : (x >= 100 ? x / 100 * 100 : (x >= 10 ? x / 10 * 10 : 1));
        }
        if (this.maximumNumberOfCharactersPerColumn > 1000) {
            this.maximumNumberOfCharactersPerColumn = 1000;
        }
        return this.maximumNumberOfCharactersPerColumn;
    }

    protected void setMenuManager(MenuManager popupMenuMgr) {
        this.menuManager = popupMenuMgr;
    }

    protected MenuManager getMenuManager() {
        return this.menuManager;
    }

    public void setFind(boolean isFind) {
        this.isFind = isFind;
    }

    public boolean isFind() {
        return this.isFind;
    }

    public boolean isCallMF() {
        return this.callMF;
    }

    public void setCallMF(boolean callMF) {
        this.callMF = callMF;
    }

    public IWorkbenchPage getWorkbenchPage() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        return page;
    }

    public String getSecondaryId() {
        IWorkbenchPart workbenchPart = this.getWorkbenchPage().getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        return secondaryId;
    }

    public FileMasterServer getFileMasterServer() {
        FileMasterServer fileMasterServer = null;
        IWorkbenchPart workbenchPart = this.getWorkbenchPage().getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        if (workbenchPart instanceof EditorView) {
            fileMasterServer = ((EditorView)workbenchPart).getServer(secondaryId);
        }
        return fileMasterServer;
    }

    public String getUUID() {
        IWorkbenchPart workbenchPart = this.getWorkbenchPage().getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        String uuid = ((EditorView)workbenchPart).getUUID(secondaryId);
        return uuid;
    }
}

