/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SRFPositionLabelProvider
extends OwnerDrawLabelProvider {
    private TextStyle errorStyle;
    private Shell shell = new Shell();
    private SRFField srfField;
    private TextLayout layout = new TextLayout((Device)this.shell.getDisplay());
    private SingleRecordFormatMode singleRecordFormatMode;
    private Font font;

    public SRFPositionLabelProvider(Font font, SingleRecordFormatMode singleRecordFormatMode) {
        this.singleRecordFormatMode = singleRecordFormatMode;
        this.font = font;
        this.createErrorStyle();
    }

    public String getText(Object element) {
        if (element instanceof SRFField) {
            return ((SRFField)element).getPosition();
        }
        return "";
    }

    protected void measure(Event event, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof SRFField)) {
            return;
        }
        if (event == null) {
            return;
        }
        event.gc.setFont(this.font);
        Point size = event.gc.textExtent("H");
        event.height = size.y;
    }

    protected void paint(Event event, Object element) {
        if (element != null && element instanceof SRFField) {
            this.srfField = (SRFField)element;
            TextStyle plain = new TextStyle(this.font, null, null);
            if (this.srfField.getFields().size() == 0) {
                this.layout.setText("");
                this.layout.setStyle(plain, 0, 20000);
            }
            this.layout.setText(this.srfField.getPosition());
            this.layout.setStyle(plain, 0, this.layout.getText().length());
            int colWidth = this.singleRecordFormatMode.getTableViewer().getTable().getColumn(1).getWidth();
            if (colWidth != 0) {
                this.layout.setWidth(colWidth);
            } else {
                this.layout.setWidth(-1);
            }
            this.layout.setAlignment(131072);
            if (this.srfField.isColorFieldName()) {
                this.layout.setStyle(this.errorStyle, 0, this.srfField.getPosition().length());
            }
            this.layout.draw(event.gc, event.x, event.y);
        }
    }

    private void createErrorStyle() {
        this.errorStyle = new TextStyle(this.font, this.shell.getDisplay().getSystemColor(3), this.shell.getDisplay().getSystemColor(25));
    }
}

