/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.customlayout.wizards.UpdateCRLPage;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SaveAsWizardPage
extends FileMasterWizard {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.saveCustomLayoutPage";
    private Combo memberNameCombo;
    private CRLClass crl;
    private UpdateCRLPage updateCRLPage;

    public SaveAsWizardPage(FileMasterServer server, CRLClass crl) {
        super("SaveCRLAs", "", server);
        this.setTitle("Save Custom Layout");
        this.setDescription("Enter the data set and the member name to save the CRL as.");
        this.crl = crl;
    }

    public SaveAsWizardPage(FileMasterServer server) {
        super("SaveCRLAs", "", server);
        this.setTitle("Save Custom Layout");
        this.setDescription("Enter the data set and the member name to save the CRL as.");
    }

    public void createControl(Composite parent) {
        TrayDialog.setDialogHelpAvailable((boolean)false);
        super.createControl(parent);
        super.createDataSet();
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListSaveAsWizardPage");
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog && ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof UpdateCRLPage) {
            this.updateCRLPage = (UpdateCRLPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage();
        }
        Label memberNameLabel = new Label(this.dataSetComposite, 0);
        memberNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        memberNameLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 0);
        this.memberNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Combo)this.memberNameCombo, (int)37);
        this.memberNameCombo.setTextLimit(8);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        FMHistory.intializeComboBoxes((Combo)this.memberNameCombo, (String)"MemberListSaveAsWizardPage");
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&OK");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.error = new String();
        this.error = this.validateDataSet(this.error);
        this.error = this.validateMember(this.error);
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String validateDataSet(String error) {
        switch (Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true)) {
            case 3: {
                error = String.valueOf(error) + Validator.errorMsg[3] + "\n";
                this.dataSetSelectBtn.setEnabled(true);
                break;
            }
            case 1: {
                error = String.valueOf(error) + Validator.errorMsg[1] + "\n";
                this.dataSetSelectBtn.setEnabled(false);
                break;
            }
            case 2: 
            case 4: {
                error = String.valueOf(error) + Validator.errorMsg[Validator.dataset((String)this.dataSetCombo.getText(), (boolean)true)] + "\n ";
                this.dataSetSelectBtn.setEnabled(false);
                break;
            }
            case 0: {
                this.setDescription("");
                this.dataSetSelectBtn.setEnabled(false);
            }
        }
        return error;
    }

    private String validateMember(String error) {
        if (!error.isEmpty()) {
            return error;
        }
        if (this.memberNameCombo.getText().contains("*")) {
            error = String.valueOf(error) + Validator.errorMsg[7] + "\n";
        }
        if (error.length() == 0) {
            switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                case 5: {
                    error = String.valueOf(error) + Validator.errorMsg[5] + "\n";
                    break;
                }
                case 6: {
                    error = String.valueOf(error) + Validator.errorMsg[6] + "\n";
                    break;
                }
                case 7: {
                    error = String.valueOf(error) + Validator.errorMsg[7] + "\n";
                    break;
                }
            }
        }
        return error;
    }

    public boolean doFinish() {
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListSaveAsWizardPage");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberListSaveAsWizardPage");
        this.crl.setDatasetName(this.dataSetCombo.getText());
        this.crl.setMemberName(this.memberNameCombo.getText());
        if (this.updateCRLPage != null) {
            this.updateCRLPage.setCRL(this.crl);
            return true;
        }
        return false;
    }
}

