/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster;

import com.ca.filemaster.AllocateNewParmPDSWizard;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetCopyDS;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage2;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllocateNewParmPDS
extends WizardPage
implements ModifyListener {
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.allocParmPds";
    Composite container;
    Composite dataSetCom;
    Group allocGrp;
    Group parmGrp;
    private Label dataSetName;
    private Label copyPds;
    private Text dataSetText;
    private Text copyPdsText;
    private Button allocateEmptybtn;
    private Button allocAndCopySelbtn;
    private Button allocAndCopyAllbtn;
    private String cpyPDSTextValue;
    private String newPDSName;
    private FileMasterServer server;
    private ArrayList<FileMasterMember> membersList = new ArrayList();

    public AllocateNewParmPDS(String pageName, String cpyPDSTextValue, String newPDSName, FileMasterServer server) {
        super(pageName);
        this.setTitle("Parm Files Preferences");
        this.cpyPDSTextValue = cpyPDSTextValue;
        this.newPDSName = newPDSName;
        this.server = server;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.allocParmPds");
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.dataSetCom = new Composite(this.container, 0);
        this.dataSetCom.setLayout((Layout)new GridLayout(2, false));
        GridData gd_dataSetCom = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.dataSetCom.setLayoutData((Object)gd_dataSetCom);
        this.dataSetName = new Label(this.dataSetCom, 0);
        this.dataSetName.setText("&DSN of new parm PDS:");
        this.dataSetText = new Text(this.dataSetCom, 2048);
        TextUtil.setWidth((Text)this.dataSetText, (int)28);
        this.dataSetText.setTextLimit(44);
        this.dataSetText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.dataSetText.addModifyListener((ModifyListener)this);
        this.dataSetText.setText(this.newPDSName);
        this.allocGrp = new Group(this.container, 0);
        this.allocGrp.setLayout((Layout)new GridLayout(1, false));
        GridData gd_allocGrp = new GridData(4, 0x1000000, true, false, 1, 1);
        this.allocGrp.setLayoutData((Object)gd_allocGrp);
        this.allocGrp.setSize(this.allocGrp.computeSize(-1, -1));
        this.allocGrp.setText("Allocation options");
        this.allocateEmptybtn = new Button((Composite)this.allocGrp, 16);
        this.allocateEmptybtn.setText("&Allocate empty");
        this.allocateEmptybtn.setSelection(true);
        this.allocAndCopySelbtn = new Button((Composite)this.allocGrp, 16);
        this.allocAndCopySelbtn.setText("Allocate and copy &selected members");
        this.allocAndCopyAllbtn = new Button((Composite)this.allocGrp, 16);
        this.allocAndCopyAllbtn.setText("Allocate and &copy all members");
        this.parmGrp = new Group(this.container, 0);
        this.parmGrp.setLayout((Layout)new GridLayout(2, false));
        GridData gd_parmGrp = new GridData(4, 0x1000000, true, false, 1, 1);
        this.parmGrp.setLayoutData((Object)gd_parmGrp);
        this.parmGrp.setSize(this.parmGrp.computeSize(-1, -1));
        this.parmGrp.setText("Parm PDS");
        this.copyPds = new Label((Composite)this.parmGrp, 0);
        this.copyPds.setText("Copy from &PDS:");
        this.copyPdsText = new Text((Composite)this.parmGrp, 2056);
        TextUtil.setWidth((Text)this.copyPdsText, (int)32);
        this.copyPdsText.setTextLimit(44);
        this.copyPdsText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.copyPdsText.addModifyListener((ModifyListener)this);
        this.copyPdsText.setText(this.cpyPDSTextValue);
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        if (this.cpyPDSTextValue.isEmpty()) {
            this.allocAndCopySelbtn.setEnabled(false);
            this.allocAndCopyAllbtn.setEnabled(false);
        }
    }

    public void modifyText(ModifyEvent e) {
        boolean canFlipToNextPage = this.isPageComplete();
        this.setPageComplete(canFlipToNextPage);
        if (canFlipToNextPage) {
            ((AllocateNewDataSetWizardPage1)((AllocateNewParmPDSWizard)this.getWizard()).getPage("allocateNewPDSDataSetWizardPage1")).updateDataSet(this.dataSetText.getText().trim());
            ((AllocateNewDataSetWizardPage2)((AllocateNewParmPDSWizard)this.getWizard()).getPage("allocateNewPDSDataSetWizardPage2")).updateDataSet(this.dataSetText.getText().trim());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        ((AllocateNewDataSetWizardPage1)((AllocateNewParmPDSWizard)this.getWizard()).getPage("allocateNewPDSDataSetWizardPage1")).insertDSNToField(this.cpyPDSTextValue);
        return ((AllocateNewParmPDSWizard)this.getWizard()).getPage("allocateNewPDSDataSetWizardPage1");
    }

    public boolean isPageComplete() {
        String error = new String();
        if (this.dataSetText != null) {
            switch (Validator.dataset(this.dataSetText.getText(), true)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(this.dataSetText.getText(), true)] + "\n ";
                    break;
                }
            }
        }
        if (error.length() > 0) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void insertMembers(FileMasterMember[] members) {
        int i = 0;
        while (i < members.length) {
            this.membersList.add(members[i]);
            ++i;
        }
    }

    public boolean doFinish() {
        if (this.allocateEmptybtn.getSelection()) {
            return true;
        }
        ArrayList<FileMasterDataset> datasetsList = new ArrayList<FileMasterDataset>();
        FileMasterDataset fromDataSet = new FileMasterDataset(null);
        FileMasterDataset toDataSet = new FileMasterDataset(null);
        fromDataSet.setName(this.cpyPDSTextValue);
        toDataSet.setName(this.dataSetText.getText().trim());
        datasetsList.add(0, fromDataSet);
        datasetsList.add(1, toDataSet);
        FileMasterDataset layoutDataset = new FileMasterDataset(null);
        FileMasterMember layoutMembers = new FileMasterMember(null);
        layoutDataset.setName("");
        datasetsList.add(2, layoutDataset);
        layoutMembers.setName("");
        if (this.allocAndCopySelbtn.getSelection()) {
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new MemberWizard(null, fromDataSet, this.server, false));
            dialog.create();
            dialog.open();
            if (this.membersList.isEmpty()) {
                return true;
            }
        } else if (this.allocAndCopyAllbtn.getSelection()) {
            FileMasterMember allMembers = new FileMasterMember(null);
            allMembers.setName("*");
            this.membersList.add(allMembers);
        }
        ArrayList<String> selCrit = new ArrayList<String>();
        selCrit.add(0, "");
        RunGetCopyDS runner = new RunGetCopyDS(this.server, datasetsList, this.membersList, "N", "false", "S", layoutMembers, selCrit, "PDS");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest response = runner.getXml();
        this.handleResponse(response);
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        ArrayList<String> contentAL = new ArrayList<String>();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Line");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + AllocateNewParmPDS.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = AllocateNewParmPDS.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = AllocateNewParmPDS.getTagValue("Line", lineElement);
                        contentAL.add(line);
                        ++i;
                    }
                    this.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                }
            }
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    private IViewPart updateReportsView(String[] content) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            if (!content.toString().isEmpty()) {
                IViewPart view = page.showView("com.ca.filemaster.views.reportsview", UUID.randomUUID().toString(), 1);
                if (view instanceof ReportView) {
                    ((ReportView)view).updateReportViewer(content);
                }
                return view;
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getNewDataSetName() {
        return this.dataSetText.getText().trim();
    }
}

