/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.FMPGDGDataset;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.runners.RunGetWCdsn;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonMFCalls {
    public static String RETURN_CODE = "";
    public static String MESSAGE = "";
    protected static final String FILE_PREFIX = "com.ca.testingtools.";
    private static FileMasterDataset dataSetResponse;
    private static FileMasterMember memberResponse;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(CommonMFCalls.class.getName());
    }

    public static FileMasterDataset getFQDSN(String dataSetName, String volume, FileMasterServer server) {
        return CommonMFCalls.getFQDSN(dataSetName, volume, server, false);
    }

    public static FileMasterDataset getFQDSN(String dataSetName, String volume, FileMasterServer server, boolean showErrors) {
        logger.log(Level.INFO, "Data Set: " + dataSetName);
        RETURN_CODE = "";
        MESSAGE = "";
        dataSetResponse = new FileMasterDataset(null);
        dataSetResponse.setName(dataSetName.trim().toUpperCase());
        dataSetName = dataSetName.trim().toUpperCase();
        volume = volume.trim().toUpperCase();
        FileMasterDataset dataSetRequest = new FileMasterDataset(null);
        String DSLength = Integer.toHexString(dataSetName.length());
        if (dataSetName.startsWith("\"")) {
            dataSetName = dataSetName.substring(1, dataSetName.length() - 1);
        }
        dataSetRequest.setName(dataSetName);
        if (!volume.isEmpty()) {
            dataSetRequest.setVolume(volume);
        }
        dataSetRequest.setDSLength(DSLength);
        RunGetWCdsn runner = new RunGetWCdsn(dataSetRequest, server, volume, false);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                if (showErrors) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                }
            } else {
                NodeList mvsDatasetInfo = element.getElementsByTagName("MvsDataSetInfo");
                NodeList vsamDatasetInfo = element.getElementsByTagName("VsamDataSetInfo");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                Node rcNode = retCode.item(0);
                Element rcElement = (Element)rcNode;
                RETURN_CODE = CommonMFCalls.getTagValue("ReturnCode", rcElement);
                NodeList messages = element.getElementsByTagName("Message");
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    MESSAGE = String.valueOf(MESSAGE) + CommonMFCalls.getTagValue("Message", msgElement);
                    showErrors = true;
                    ++i;
                }
                if (mvsDatasetInfo.getLength() == 0 && vsamDatasetInfo.getLength() == 0 && !RETURN_CODE.equals("0")) {
                    if (showErrors) {
                        TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + RETURN_CODE), (Throwable)new Throwable(MESSAGE));
                    }
                } else {
                    NodeList datasetUsagenodes = element.getElementsByTagName("GetDSNInfoResponse");
                    switch (((Element)datasetUsagenodes.item(0)).getAttribute("fileType").toUpperCase().charAt(0)) {
                        case 'A': 
                        case 'H': 
                        case 'L': 
                        case 'P': 
                        case 'S': 
                        case 'V': 
                        case 'X': {
                            CommonMFCalls.getMvsDatasetUsages(element);
                            CommonMFCalls.getMvsDatasetDefinitions(element);
                            dataSetResponse.setDsType(((Element)datasetUsagenodes.item(0)).getAttribute("fileType"));
                            dataSetResponse.setDsOrg(CommonMFCalls.fileType2DSOrg(dataSetResponse.getDsType()));
                            return dataSetResponse;
                        }
                        case 'E': 
                        case 'K': 
                        case 'N': 
                        case 'R': 
                        case 'Y': {
                            FMPVSAMDataset vsamResponse = new FMPVSAMDataset(null);
                            vsamResponse.setName(dataSetName);
                            vsamResponse.setDsType(((Element)datasetUsagenodes.item(0)).getAttribute("fileType"));
                            vsamResponse.setDsOrg(CommonMFCalls.fileType2DSOrg(vsamResponse.getDsType()));
                            vsamResponse = CommonMFCalls.getVSAMDatasetDefinitions(vsamResponse, element);
                            return vsamResponse;
                        }
                        case 'I': {
                            CommonMFCalls.getArchivedDataset(element);
                            return dataSetResponse;
                        }
                        case 'T': {
                            FMPVSAMDataset pathResponse = new FMPVSAMDataset(null);
                            pathResponse.setName(dataSetName);
                            pathResponse.setDsType(((Element)datasetUsagenodes.item(0)).getAttribute("fileType"));
                            pathResponse.setDsOrg(CommonMFCalls.fileType2DSOrg(pathResponse.getDsType()));
                            FMPVSAMDataset vsamResponse = CommonMFCalls.getPathDatasetDefinitions(pathResponse, element);
                            return pathResponse;
                        }
                        case 'G': {
                            FMPGDGDataset gdgResponse = new FMPGDGDataset(null);
                            gdgResponse = CommonMFCalls.getGDGDatasetDefinitions(gdgResponse, element);
                            gdgResponse.setDsType(((Element)datasetUsagenodes.item(0)).getAttribute("fileType"));
                            gdgResponse.setDsOrg(CommonMFCalls.fileType2DSOrg(gdgResponse.getDsType()));
                            return gdgResponse;
                        }
                    }
                }
            }
        }
        return dataSetResponse;
    }

    private static FileMasterDataset getArchivedDataset(Element element) {
        NodeList datasetDefinitionnodes = element.getElementsByTagName("MvsDataSetDefinition");
        NodeList volumenodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Volume");
        NodeList sernodes = ((Element)volumenodes.item(0)).getElementsByTagName("Ser");
        dataSetResponse.setName(((Element)datasetDefinitionnodes.item(0)).getAttribute("dsname"));
        dataSetResponse.setVolPrivate(((Element)volumenodes.item(0)).getAttribute("private"));
        dataSetResponse.setVolSeqnr(((Element)volumenodes.item(0)).getAttribute("seqnr"));
        dataSetResponse.setVolCount(((Element)volumenodes.item(0)).getAttribute("count"));
        if (sernodes.getLength() > 0) {
            ArrayList<String> volSerials = new ArrayList<String>();
            int i = 0;
            while (i < sernodes.getLength()) {
                volSerials.add(CommonMFCalls.getTagValue("Ser", (Element)sernodes.item(i)));
                ++i;
            }
            dataSetResponse.setVolumes(volSerials);
        }
        return dataSetResponse;
    }

    private static FileMasterDataset getMvsDatasetUsages(Element element) {
        NodeList datasetUsagenodes = element.getElementsByTagName("MvsDataSetUsage");
        if (datasetUsagenodes.item(0) != null) {
            NodeList usednodes = ((Element)datasetUsagenodes.item(0)).getElementsByTagName("Used");
            NodeList allocatednodes = ((Element)datasetUsagenodes.item(0)).getElementsByTagName("Allocated");
            NodeList extentallocationnodes = ((Element)datasetUsagenodes.item(0)).getElementsByTagName("ExtentAllocation");
            NodeList directoryblocksnodes = ((Element)datasetUsagenodes.item(0)).getElementsByTagName("DirectoryBlocks");
            dataSetResponse.setAliasName(((Element)datasetUsagenodes.item(0)).getAttribute("aliasName"));
            dataSetResponse.setDsOrg(((Element)datasetUsagenodes.item(0)).getAttribute("dsorgText"));
            dataSetResponse.setSmsDsorg(((Element)datasetUsagenodes.item(0)).getAttribute("smsDsorg"));
            dataSetResponse.setDateCreated(((Element)datasetUsagenodes.item(0)).getAttribute("dateCreated"));
            dataSetResponse.setDateReferenced(((Element)datasetUsagenodes.item(0)).getAttribute("dateReferenced"));
            dataSetResponse.setUnits(((Element)datasetUsagenodes.item(0)).getAttribute("unitDevice"));
            dataSetResponse.setNumMembers(((Element)datasetUsagenodes.item(0)).getAttribute("numberMembers"));
            dataSetResponse.setNumberPages(((Element)datasetUsagenodes.item(0)).getAttribute("numberPages"));
            dataSetResponse.setUsedAllocUnit(((Element)usednodes.item(0)).getAttribute("allocationUnit"));
            dataSetResponse.setUsedAllocValue(((Element)usednodes.item(0)).getAttribute("allocationValue"));
            dataSetResponse.setAllocatedallocUnit(((Element)allocatednodes.item(0)).getAttribute("allocationUnit"));
            dataSetResponse.setAllocatedallocValue(((Element)allocatednodes.item(0)).getAttribute("allocationValue"));
            dataSetResponse.setExtentsAllocated(((Element)extentallocationnodes.item(0)).getAttribute("extentsAllocated"));
            dataSetResponse.setExtentsUsed(((Element)extentallocationnodes.item(0)).getAttribute("extentsUsed"));
            if (directoryblocksnodes.getLength() > 0) {
                dataSetResponse.setDircUsed(((Element)directoryblocksnodes.item(0)).getAttribute("dirUsed"));
            }
        }
        return dataSetResponse;
    }

    private static FileMasterDataset getMvsDatasetDefinitions(Element element) {
        NodeList datasetDefinitionnodes = element.getElementsByTagName("MvsDataSetDefinition");
        NodeList expdtnodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Expdt");
        if (expdtnodes.getLength() > 0) {
            NodeList dateNode = ((Element)expdtnodes.item(0)).getElementsByTagName("Date");
            dataSetResponse.setExpirationDate(CommonMFCalls.getTagValue("Date", (Element)dateNode.item(0)));
        }
        NodeList dcbnodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Dcb");
        NodeList spacenodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Space");
        NodeList volumenodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Volume");
        NodeList sernodes = ((Element)volumenodes.item(0)).getElementsByTagName("Ser");
        NodeList unitnodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Unit");
        NodeList smsnodes = ((Element)datasetDefinitionnodes.item(0)).getElementsByTagName("Sms");
        dataSetResponse.setName(((Element)datasetDefinitionnodes.item(0)).getAttribute("dsname"));
        dataSetResponse.setLrecl(((Element)dcbnodes.item(0)).getAttribute("lrecl"));
        dataSetResponse.setBlksize(((Element)dcbnodes.item(0)).getAttribute("blksize"));
        dataSetResponse.setRecfm(((Element)dcbnodes.item(0)).getAttribute("recfm"));
        dataSetResponse.setDcbDsOrg(((Element)dcbnodes.item(0)).getAttribute("dsorg"));
        dataSetResponse.setKeylen(((Element)dcbnodes.item(0)).getAttribute("keylen"));
        dataSetResponse.setUnits(((Element)spacenodes.item(0)).getAttribute("units"));
        dataSetResponse.setPrimaryAlloc(((Element)spacenodes.item(0)).getAttribute("primary"));
        dataSetResponse.setSecondaryAlloc(((Element)spacenodes.item(0)).getAttribute("secondary"));
        dataSetResponse.setDircMax(((Element)spacenodes.item(0)).getAttribute("directory"));
        dataSetResponse.setVolPrivate(((Element)volumenodes.item(0)).getAttribute("private"));
        dataSetResponse.setVolSeqnr(((Element)volumenodes.item(0)).getAttribute("seqnr"));
        dataSetResponse.setVolCount(((Element)volumenodes.item(0)).getAttribute("count"));
        if (sernodes.getLength() > 0) {
            dataSetResponse.setUsesVolumeSerial(true);
            ArrayList<String> volSerials = new ArrayList<String>();
            int i = 0;
            while (i < sernodes.getLength()) {
                volSerials.add(CommonMFCalls.getTagValue("Ser", (Element)sernodes.item(i)));
                ++i;
            }
            dataSetResponse.setVolumes(volSerials);
        }
        if (sernodes.getLength() > 0) {
            dataSetResponse.setUnitType(((Element)unitnodes.item(0)).getAttribute("type"));
            dataSetResponse.setUnitCount(((Element)unitnodes.item(0)).getAttribute("count"));
        }
        if (smsnodes.getLength() > 0) {
            dataSetResponse.setIsSMSdataset(true);
            dataSetResponse.setSmsStorage(((Element)smsnodes.item(0)).getAttribute("storclas"));
            dataSetResponse.setSmsManagement(((Element)smsnodes.item(0)).getAttribute("mgmtclas"));
            dataSetResponse.setSmsData(((Element)smsnodes.item(0)).getAttribute("dataclas"));
        }
        return dataSetResponse;
    }

    private static FMPVSAMDataset getVSAMDatasetDefinitions(FMPVSAMDataset vsam, Element element) {
        NodeList VSAMIndexUsagenodes;
        NodeList VSAMDefinitionnodes = element.getElementsByTagName("VsamDataSetDefinition");
        NodeList clusternodes = ((Element)VSAMDefinitionnodes.item(0)).getElementsByTagName("Cluster");
        NodeList keysnodes = ((Element)clusternodes.item(0)).getElementsByTagName("Keys");
        NodeList smsnodes = ((Element)clusternodes.item(0)).getElementsByTagName("Sms");
        NodeList recordsizenodes = ((Element)clusternodes.item(0)).getElementsByTagName("Recordsize");
        NodeList shareoptionsnodes = ((Element)clusternodes.item(0)).getElementsByTagName("Shareoptions");
        NodeList expdtnodes = ((Element)clusternodes.item(0)).getElementsByTagName("Expdt");
        NodeList VSAMUsagenodes = element.getElementsByTagName("VsamDataSetUsage");
        NodeList VSAMnodes = ((Element)VSAMUsagenodes.item(0)).getElementsByTagName("Vsam");
        NodeList VSAMClusterUsagenodes = ((Element)VSAMnodes.item(0)).getElementsByTagName("VsamClusterUsage");
        NodeList usagecountsnodes = ((Element)VSAMClusterUsagenodes.item(0)).getElementsByTagName("usageCounts");
        NodeList VSAMDataUsagenodes = ((Element)VSAMnodes.item(0)).getElementsByTagName("VsamDataUsage");
        NodeList DataAllocnodes = ((Element)VSAMDataUsagenodes.item(0)).getElementsByTagName("DataAlloc");
        NodeList Dataspacenodes = ((Element)DataAllocnodes.item(0)).getElementsByTagName("Space");
        NodeList Datavolumenodes = ((Element)DataAllocnodes.item(0)).getElementsByTagName("Volume");
        NodeList Datasernodes = ((Element)Datavolumenodes.item(0)).getElementsByTagName("Ser");
        NodeList Datafreespacenodes = ((Element)VSAMDataUsagenodes.item(0)).getElementsByTagName("freespacePercent");
        NodeList Datakeytextnodes = ((Element)VSAMDataUsagenodes.item(0)).getElementsByTagName("KeyText");
        vsam.setCluster(((Element)clusternodes.item(0)).getAttribute("dsname"));
        vsam.setVSAMFileType(((Element)clusternodes.item(0)).getAttribute("organization"));
        vsam.setBufferSpace(((Element)clusternodes.item(0)).getAttribute("bufferSpace"));
        vsam.setErase(((Element)clusternodes.item(0)).getAttribute("erase"));
        vsam.setLoadRestartable(((Element)clusternodes.item(0)).getAttribute("loadRestartable"));
        vsam.setSpanned(((Element)clusternodes.item(0)).getAttribute("spanned"));
        vsam.setReuse(((Element)clusternodes.item(0)).getAttribute("reuse"));
        vsam.setWriteCheck(((Element)clusternodes.item(0)).getAttribute("writeCheck"));
        vsam.setClusterControlIntervalSize(((Element)clusternodes.item(0)).getAttribute("controlIntervalSize"));
        vsam.setOwner(((Element)clusternodes.item(0)).getAttribute("owner"));
        vsam.setReplicateIndex(((Element)clusternodes.item(0)).getAttribute("replicateIndex"));
        vsam.setBaseDsn(((Element)clusternodes.item(0)).getAttribute("baseDsn"));
        if (keysnodes.getLength() > 0) {
            vsam.setOffset(((Element)keysnodes.item(0)).getAttribute("offset"));
            vsam.setLength(((Element)keysnodes.item(0)).getAttribute("length"));
        }
        if (smsnodes.getLength() > 0) {
            vsam.setIsSMSdataset(true);
            vsam.setSmsStorage(((Element)smsnodes.item(0)).getAttribute("storclas"));
            vsam.setSmsManagement(((Element)smsnodes.item(0)).getAttribute("mgmtclas"));
            vsam.setSmsData(((Element)smsnodes.item(0)).getAttribute("dataclas"));
        }
        if (recordsizenodes.getLength() > 0) {
            vsam.setAverage(((Element)recordsizenodes.item(0)).getAttribute("average"));
            vsam.setMaximum(((Element)recordsizenodes.item(0)).getAttribute("maximum"));
        }
        vsam.setCrossregion(((Element)shareoptionsnodes.item(0)).getAttribute("crossregion"));
        vsam.setCrosssystem(((Element)shareoptionsnodes.item(0)).getAttribute("crosssystem"));
        if (expdtnodes.getLength() > 0) {
            vsam.setExpirationDate(((Element)expdtnodes.item(0)).getAttribute("Date"));
        }
        vsam.setDateCreated(((Element)VSAMClusterUsagenodes.item(0)).getAttribute("dateCreated"));
        vsam.setTotal(((Element)usagecountsnodes.item(0)).getAttribute("total"));
        vsam.setActual(((Element)usagecountsnodes.item(0)).getAttribute("actual"));
        vsam.setDeleted(((Element)usagecountsnodes.item(0)).getAttribute("deleted"));
        vsam.setInserted(((Element)usagecountsnodes.item(0)).getAttribute("inserted"));
        vsam.setUpdated(((Element)usagecountsnodes.item(0)).getAttribute("updated"));
        vsam.setRetrieved(((Element)usagecountsnodes.item(0)).getAttribute("retrieved"));
        vsam.setDataExtentsUsed(((Element)VSAMDataUsagenodes.item(0)).getAttribute("extentsUsed"));
        vsam.setDataCiPerca(((Element)VSAMDataUsagenodes.item(0)).getAttribute("ciPerca"));
        vsam.setDataCiSplits(((Element)VSAMDataUsagenodes.item(0)).getAttribute("ciSplits"));
        vsam.setDataCaSplits(((Element)VSAMDataUsagenodes.item(0)).getAttribute("caSplits"));
        vsam.setDataFreespaceTotal(((Element)VSAMDataUsagenodes.item(0)).getAttribute("freespaceTotal"));
        vsam.setDataHighAllocatedRBA(((Element)VSAMDataUsagenodes.item(0)).getAttribute("highAllocatedRBA"));
        vsam.setDataHighUsedRBA(((Element)VSAMDataUsagenodes.item(0)).getAttribute("highUsedRBA"));
        vsam.setDataPercentFree(((Element)VSAMDataUsagenodes.item(0)).getAttribute("percentFree"));
        vsam.setDataPhyRecordSize(((Element)VSAMDataUsagenodes.item(0)).getAttribute("phyRecordSize"));
        vsam.setDataPhyRecordTrk(((Element)VSAMDataUsagenodes.item(0)).getAttribute("phyRecordTrk"));
        vsam.setDataTrksCA(((Element)VSAMDataUsagenodes.item(0)).getAttribute("trksCA"));
        vsam.setData(((Element)DataAllocnodes.item(0)).getAttribute("dsname"));
        vsam.setDataControlIntervalSize(((Element)DataAllocnodes.item(0)).getAttribute("controlIntervalSize"));
        vsam.setDataUnits(((Element)Dataspacenodes.item(0)).getAttribute("units"));
        vsam.setDataPrimary(((Element)Dataspacenodes.item(0)).getAttribute("primary"));
        vsam.setDataSecondary(((Element)Dataspacenodes.item(0)).getAttribute("secondary"));
        ArrayList<String> dataVolSerials = new ArrayList<String>();
        int i = 0;
        while (i < Datasernodes.getLength()) {
            dataVolSerials.add(CommonMFCalls.getTagValue("Ser", (Element)Datasernodes.item(i)));
            ++i;
        }
        vsam.setDataVolumes(dataVolSerials);
        if (Datafreespacenodes.getLength() > 0) {
            vsam.setDataCIpercent(((Element)Datafreespacenodes.item(0)).getAttribute("CIpercent"));
            vsam.setDataCApercent(((Element)Datafreespacenodes.item(0)).getAttribute("CApercent"));
        }
        if (Datakeytextnodes.getLength() > 0) {
            vsam.setKeypositionText(((Element)Datakeytextnodes.item(0)).getAttribute("keypositionText"));
            vsam.setKeylengthText(((Element)Datakeytextnodes.item(0)).getAttribute("keylengthText"));
        }
        if ((VSAMIndexUsagenodes = ((Element)VSAMnodes.item(0)).getElementsByTagName("VsamIndexUsage")).item(0) != null) {
            NodeList IndexAllocnodes = ((Element)VSAMIndexUsagenodes.item(0)).getElementsByTagName("IndexAlloc");
            NodeList Indexspacenodes = ((Element)IndexAllocnodes.item(0)).getElementsByTagName("Space");
            NodeList Indexvolumenodes = ((Element)IndexAllocnodes.item(0)).getElementsByTagName("Volume");
            NodeList Indexsernodes = ((Element)Indexvolumenodes.item(0)).getElementsByTagName("Ser");
            NodeList Indexfreespacenodes = ((Element)VSAMIndexUsagenodes.item(0)).getElementsByTagName("freespacePercent");
            vsam.setIndexExtentsUsed(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("extentsUsed"));
            vsam.setIndexCiPerca(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("ciPerca"));
            vsam.setIndexCiSplits(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("ciSplits"));
            vsam.setIndexCaSplits(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("caSplits"));
            vsam.setIndexFreespaceTotal(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("freespaceTotal"));
            vsam.setIndexHighAllocatedRBA(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("highAllocatedRBA"));
            vsam.setIndexHighUsedRBA(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("highUsedRBA"));
            vsam.setIndexPercentFree(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("percentFree"));
            vsam.setIndexPhyRecordSize(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("phyRecordSize"));
            vsam.setIndexPhyRecordTrk(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("phyRecordTrk"));
            vsam.setIndexTrksCA(((Element)VSAMIndexUsagenodes.item(0)).getAttribute("trksCA"));
            vsam.setIndex(((Element)IndexAllocnodes.item(0)).getAttribute("dsname"));
            vsam.setIndexControlIntervalSize(((Element)IndexAllocnodes.item(0)).getAttribute("controlIntervalSize"));
            vsam.setIndexUnits(((Element)Indexspacenodes.item(0)).getAttribute("units"));
            vsam.setIndexPrimary(((Element)Indexspacenodes.item(0)).getAttribute("primary"));
            vsam.setIndexSecondary(((Element)Indexspacenodes.item(0)).getAttribute("secondary"));
            ArrayList<String> indexVolSerials = new ArrayList<String>();
            int i2 = 0;
            while (i2 < Indexsernodes.getLength()) {
                indexVolSerials.add(CommonMFCalls.getTagValue("Ser", (Element)Indexsernodes.item(i2)));
                ++i2;
            }
            vsam.setIndexVolumes(indexVolSerials);
            vsam.setIndexCIpercent(((Element)Indexfreespacenodes.item(0)).getAttribute("CIpercent"));
            vsam.setIndexCApercent(((Element)Indexfreespacenodes.item(0)).getAttribute("CApercent"));
        }
        return vsam;
    }

    private static FMPVSAMDataset getPathDatasetDefinitions(FMPVSAMDataset vsam, Element element) {
        NodeList VSAMUsagenodes = element.getElementsByTagName("VsamDataSetUsage");
        NodeList Pathnodes = ((Element)VSAMUsagenodes.item(0)).getElementsByTagName("Path");
        NodeList Aixnodes = ((Element)Pathnodes.item(0)).getElementsByTagName("AixValues");
        NodeList AixKeysnodes = ((Element)Aixnodes.item(0)).getElementsByTagName("Keys");
        NodeList AixPositionnodes = ((Element)Aixnodes.item(0)).getElementsByTagName("position");
        NodeList AixLengthnodes = ((Element)Aixnodes.item(0)).getElementsByTagName("length");
        NodeList Clusternodes = ((Element)Pathnodes.item(0)).getElementsByTagName("ClusterValues");
        NodeList ClusterKeysnodes = ((Element)Clusternodes.item(0)).getElementsByTagName("Keys");
        NodeList ClusterPositionnodes = ((Element)Clusternodes.item(0)).getElementsByTagName("position");
        NodeList ClusterLengthnodes = ((Element)Clusternodes.item(0)).getElementsByTagName("length");
        vsam.setPath(((Element)Pathnodes.item(0)).getAttribute("dsname"));
        if (((Element)Aixnodes.item(0)).getAttribute("dsnametxt").isEmpty()) {
            vsam.setAix(((Element)Aixnodes.item(0)).getAttribute("dsname"));
        } else {
            vsam.setAix(((Element)Aixnodes.item(0)).getAttribute("dsnametxt"));
        }
        if (AixKeysnodes.getLength() > 0) {
            vsam.setOffset(((Element)AixKeysnodes.item(0)).getAttribute("offset"));
            vsam.setLength(((Element)AixKeysnodes.item(0)).getAttribute("length"));
        }
        if (AixPositionnodes.getLength() > 0) {
            vsam.setOffset(CommonMFCalls.getTagValue("position", (Element)AixPositionnodes.item(0)));
        }
        if (AixLengthnodes.getLength() > 0) {
            vsam.setLength(CommonMFCalls.getTagValue("length", (Element)AixLengthnodes.item(0)));
        }
        if (((Element)Clusternodes.item(0)).getAttribute("dsnametxt").isEmpty()) {
            vsam.setCluster(((Element)Clusternodes.item(0)).getAttribute("dsname"));
        } else {
            vsam.setCluster(((Element)Clusternodes.item(0)).getAttribute("dsnametxt"));
        }
        if (ClusterKeysnodes.getLength() > 0) {
            vsam.setClusterOffset(((Element)ClusterKeysnodes.item(0)).getAttribute("offset"));
            vsam.setClusterLength(((Element)ClusterKeysnodes.item(0)).getAttribute("length"));
        }
        if (ClusterPositionnodes.getLength() > 0) {
            vsam.setClusterOffset(CommonMFCalls.getTagValue("position", (Element)ClusterPositionnodes.item(0)));
        }
        if (ClusterLengthnodes.getLength() > 0) {
            vsam.setClusterLength(CommonMFCalls.getTagValue("length", (Element)ClusterLengthnodes.item(0)));
        }
        return vsam;
    }

    private static FMPGDGDataset getGDGDatasetDefinitions(FMPGDGDataset gdg, Element element) {
        NodeList gdginfonodes = element.getElementsByTagName("GenerationDataSetInfo");
        NodeList gdgdefinitionnodes = ((Element)gdginfonodes.item(0)).getElementsByTagName("GdgDefinition");
        NodeList gdgusagenodes = ((Element)gdginfonodes.item(0)).getElementsByTagName("GdgUsage");
        NodeList gdgassocnodes = ((Element)gdgusagenodes.item(0)).getElementsByTagName("GdgAssociations");
        gdg.setName(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgname"));
        gdg.setGdgMaxGens(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgmaxgens"));
        gdg.setGdgExpirationDate(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgexpirationdate"));
        gdg.setGdgUnctlg(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgunctlg"));
        gdg.setGdgScratch(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgscratch"));
        gdg.setGdgOwnerid(((Element)gdgdefinitionnodes.item(0)).getAttribute("gdgOwnerid"));
        gdg.setDateCreated(((Element)gdgusagenodes.item(0)).getAttribute("dateCreated"));
        gdg.setGdgDateLastAltered(((Element)gdgusagenodes.item(0)).getAttribute("dateLastAltered"));
        if (gdgassocnodes.getLength() > 0) {
            gdg.setGdgAssocStart(((Element)gdgassocnodes.item(0)).getAttribute("start"));
            gdg.setGdgAssocEnd(((Element)gdgassocnodes.item(0)).getAttribute("end"));
        }
        return gdg;
    }

    public static String getTagValue(String sTag, Element eElement) {
        NodeList nlList;
        Node nValue;
        if (eElement != null && (nValue = (nlList = eElement.getChildNodes()).item(0)) != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public static XMLDocument createXMLDoc(String request) {
        try {
            File file = File.createTempFile(FILE_PREFIX, ".xml");
            file.deleteOnExit();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            bw.write(request);
            bw.flush();
            bw.close();
            XMLDocument xmlDoc = new XMLDocument(file);
            return xmlDoc;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (TTException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String fileType2DSOrg(String fileType) {
        if (fileType.equalsIgnoreCase("A")) {
            return "Direct Access";
        }
        if (fileType.equalsIgnoreCase("B")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("C")) {
            return "Catalog Entry";
        }
        if (fileType.equalsIgnoreCase("E")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("G")) {
            return "GDG";
        }
        if (fileType.equalsIgnoreCase("H")) {
            return "HFS";
        }
        if (fileType.equalsIgnoreCase("D")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("K")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("L")) {
            return "PDS";
        }
        if (fileType.equalsIgnoreCase("N")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("T")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("P")) {
            return "PDS";
        }
        if (fileType.equalsIgnoreCase("X")) {
            return "PDSE";
        }
        if (fileType.equalsIgnoreCase("S")) {
            return "Sequential";
        }
        if (fileType.equalsIgnoreCase("R")) {
            return "VSAM";
        }
        if (fileType.equalsIgnoreCase("V")) {
            return "Sequential";
        }
        if (fileType.equalsIgnoreCase("Y")) {
            return "VSAM";
        }
        return "";
    }

    public static FileMasterMember getFQMEM(String datasetName, String memberName, FileMasterServer server, String type) {
        boolean showErrors = true;
        RETURN_CODE = "";
        MESSAGE = "";
        memberName = memberName.trim().toUpperCase();
        memberResponse = new FileMasterMember(null);
        memberResponse.setName(memberName);
        FileMasterDataset dataSetRequest = new FileMasterDataset(null);
        dataSetRequest.setName(datasetName);
        FileMasterMember memberRequest = new FileMasterMember(null);
        memberRequest.setName(memberName);
        RunGetWCMEM runner = new RunGetWCMEM(dataSetRequest, server, memberRequest, false, type);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                if (showErrors) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                }
            } else {
                NodeList nodes = element.getElementsByTagName("MemberInfo");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                Node rcNode = retCode.item(0);
                Element rcElement = (Element)rcNode;
                RETURN_CODE = CommonMFCalls.getTagValue("ReturnCode", rcElement);
                NodeList messages = element.getElementsByTagName("Message");
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    MESSAGE = String.valueOf(MESSAGE) + CommonMFCalls.getTagValue("Message", msgElement);
                    ++i;
                }
                if (nodes.getLength() == 0) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + RETURN_CODE), (Throwable)new Throwable(MESSAGE));
                } else {
                    Element dsElement = (Element)nodes.item(0);
                    if (dsElement.hasAttribute("programSize")) {
                        memberResponse.setName(dsElement.getAttribute("name"));
                        memberResponse.setSize(dsElement.getAttribute("programSize"));
                        memberResponse.setAmode(dsElement.getAttribute("aMode"));
                        memberResponse.setRmode(dsElement.getAttribute("rMode"));
                        memberResponse.setLinkDate(dsElement.getAttribute("linkDate"));
                        memberResponse.setLinkTime(dsElement.getAttribute("linkTime"));
                        memberResponse.setReentrant(dsElement.getAttribute("reentrant"));
                        memberResponse.setReusable(dsElement.getAttribute("reusable"));
                        memberResponse.setRefreshable(dsElement.getAttribute("refreshable"));
                        memberResponse.setAuthCode(dsElement.getAttribute("authCode"));
                    } else {
                        memberResponse.setName(dsElement.getAttribute("name"));
                        if (dsElement.hasAttribute("description")) {
                            memberResponse.setCLDescription(dsElement.getAttribute("description"));
                        }
                        if (dsElement.hasAttribute("fmfiletype")) {
                            memberResponse.setType(dsElement.getAttribute("fmfiletype"));
                        }
                        memberResponse.setRecordCount(dsElement.getAttribute("recordCount"));
                        memberResponse.setDateCreated(dsElement.getAttribute("dateCreated"));
                        memberResponse.setDateChanged(dsElement.getAttribute("dateChanged"));
                        memberResponse.setTimeChanged(dsElement.getAttribute("timeChanged"));
                        memberResponse.setID(dsElement.getAttribute("userID"));
                    }
                }
            }
        }
        return memberResponse;
    }
}

