/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.Activator;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterDSName;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class FMDSNListTreeModel
extends PropertyChangeManager
implements IPropertyChangeListener {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static FMDSNListTreeModel model = null;
    protected static final String NAME = "name";
    protected static final String LEVEL = "level";
    protected FMXMLProfile dsnlistXML;
    protected static final String TREE_FILE_DSNLIST = "com.ca.testingtools.TREE_FILE_DSNLIST";
    protected String XMLPathName;
    private ArrayList<String> order = new ArrayList();
    private HashMap<String, IConfigurationElement> elementlist;
    private final ArrayList<TT_TreeItem> servers = new ArrayList();
    private final ArrayList<TT_TreeItem> datasets = new ArrayList();
    private static final int MOVEUP = 0;
    private static final int MOVEDOWN = 1;

    public FMDSNListTreeModel() {
        this.loadPlugins();
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getString(TREE_FILE_DSNLIST);
        if (filename == null || filename.isEmpty()) {
            filename = FMDSNListTreeModel.setFileName();
        }
        IPath propertyPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        this.XMLPathName = propertyPath.append(filename).toOSString();
        File pFile = new File(this.XMLPathName);
        if (pFile.exists()) {
            try {
                this.dsnlistXML = new FMXMLProfile(pFile);
                Element[] elementArray = this.dsnlistXML.getDSNListDatasets();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element dataset = elementArray[n2];
                    this.insertDataset(dataset);
                    ++n2;
                }
            }
            catch (TTException e) {
                this.dsnlistXML = new FMXMLProfile();
            }
        } else {
            this.dsnlistXML = new FMXMLProfile();
        }
    }

    public static synchronized FMDSNListTreeModel getInstance() {
        if (model == null) {
            model = new FMDSNListTreeModel();
        }
        return model;
    }

    protected void loadPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("com.ca.testingtools.profile");
        this.elementlist = new HashMap(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals("seperator")) {
                this.locate(element);
            } else {
                this.elementlist.put(element.getAttribute("id"), element);
            }
            ++n2;
        }
        for (IConfigurationElement element : this.elementlist.values()) {
            this.locate(element);
        }
        Iterator<String> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.elementlist.containsKey(key)) continue;
            iterator.remove();
        }
    }

    private void locate(IConfigurationElement element) {
        Position position;
        String name = element.getName();
        boolean seperator = "seperator".equals(name);
        String ID = element.getAttribute(seperator ? NAME : "id");
        String menuid = element.getAttribute("menuid");
        try {
            position = Position.valueOf(element.getAttribute("menulocation"));
        }
        catch (Exception e) {
            position = Position.last;
        }
        switch (position) {
            case first: {
                this.order.add(0, ID);
                break;
            }
            case last: {
                this.order.add(ID);
                break;
            }
            case before: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix > this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix, ID);
                break;
            }
            case after: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix >= this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix + 1, ID);
            }
        }
    }

    public static String setFileName() {
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getDefaultString("DEFAULT_FM_DSNLIST_TREE");
        SimpleDateFormat dflocaltime = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = dflocaltime.format(new Date());
        filename = filename.replace(".", "." + ts + ".");
        store.setValue(TREE_FILE_DSNLIST, filename);
        try {
            store.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return filename;
    }

    public void save() {
        try {
            this.dsnlistXML.toFile(this.XMLPathName);
        }
        catch (TTException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    private String insertEscapeChars(String name) {
        name = name.replace("%", "%25");
        name = name.replace("*", "%2A");
        name = name.replace("#", "%23");
        name = name.replace("$", "%24");
        name = name.replace("@", "%40");
        return name;
    }

    private String removeEscapeChars(String name) {
        name = name.replace("%23", "#");
        name = name.replace("%24", "$");
        name = name.replace("%40", "@");
        name = name.replace("%2A", "*");
        name = name.replace("%25", "%");
        return name;
    }

    public TT_TreeItem insertDataset(Element dataset) {
        String name = dataset.getAttribute(NAME);
        name = this.removeEscapeChars(name);
        String DSLength = dataset.getAttribute("DSLENGTH");
        String DSorg = dataset.getAttribute("DSORG");
        String FileType = dataset.getAttribute("FILETYPE");
        String Volume = dataset.getAttribute("VOLUME");
        String blkSize = dataset.getAttribute("BLKSIZE");
        FileMasterDataset datasetObject = new FileMasterDataset(null);
        TT_TreeItem datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)datasetObject);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setName(name);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setFileType(FileType);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setVolume(Volume);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDsOrg(DSorg);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDSLength(DSLength);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setBlksize(blkSize);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setLrecl(dataset.getAttribute("LRECL"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setExtents(dataset.getAttribute("EXTENTS"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDateCreated(dataset.getAttribute("DATECREATED"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDateReferenced(dataset.getAttribute("DATEREFERENCED"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDSLength(dataset.getAttribute("DSLENGTH"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setRecfm(dataset.getAttribute("RECFM"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setTracks(dataset.getAttribute("TRACKS"));
        this.datasets.add(datasetItem);
        this.insertMembers(dataset, datasetItem);
        return datasetItem;
    }

    protected void insertMembers(Element datasetElement, TT_TreeItem parent) {
        Element[] memberList;
        Element[] elementArray = memberList = this.dsnlistXML.getMembers(datasetElement);
        int n = memberList.length;
        int n2 = 0;
        while (n2 < n) {
            Element member = elementArray[n2];
            this.insertMember(parent, member);
            ++n2;
        }
    }

    public TT_TreeItem insertMember(TT_TreeItem parent, Element member) {
        String name = member.getAttribute(NAME);
        String type = member.getAttribute("type");
        FileMasterMember memberObject = new FileMasterMember(parent);
        TT_TreeItem memberItem = new TT_TreeItem(member, (ITreeWrappedItem)memberObject, name);
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setType(type);
        parent.addChild(memberItem);
        this.insertDSNames(member, memberItem);
        return memberItem;
    }

    protected void insertDSNames(Element dsnElement, TT_TreeItem parent) {
        Element[] dsnList;
        Element[] elementArray = dsnList = this.dsnlistXML.getDSName(dsnElement);
        int n = dsnList.length;
        int n2 = 0;
        while (n2 < n) {
            Element dsn = elementArray[n2];
            this.insertDSName(parent, dsn);
            ++n2;
        }
    }

    public TT_TreeItem insertDSName(TT_TreeItem parent, Element dsn) {
        String name = dsn.getAttribute(NAME);
        FileMasterDSName dsnObject = new FileMasterDSName(parent);
        TT_TreeItem dsnItem = new TT_TreeItem(dsn, (ITreeWrappedItem)dsnObject, name);
        parent.addChild(dsnItem);
        return dsnItem;
    }

    public Element addDataset(Element datasetNodeElement, FileMasterDataset dataSet) {
        Element top = this.dsnlistXML.getTop();
        Element nodechild = this.createElement("datasetnode");
        nodechild.setAttribute(NAME, dataSet.getName());
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("VOLUME", dataSet.getVolume());
        nodechild.setAttribute("FILETYPE", dataSet.getFileType());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("DSORG", dataSet.getDsOrg());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("BLKSIZE", dataSet.getBlksize());
        nodechild.setAttribute("DATECREATED", dataSet.getDateCreated());
        nodechild.setAttribute("DATEREFERENCED", dataSet.getDateReferenced());
        nodechild.setAttribute("EXTENTS", dataSet.getExtents());
        nodechild.setAttribute("LRECL", dataSet.getLrecl());
        nodechild.setAttribute("RECFM", dataSet.getRecfm());
        nodechild.setAttribute("TRACKS", dataSet.getTracks());
        top.appendChild(nodechild);
        return nodechild;
    }

    public Element addMember(Element memberNodeElement, String name, String type, String description) {
        Element nodechild = this.createElement("membernode");
        name = this.insertEscapeChars(name);
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("type", type);
        nodechild.setAttribute("description", description);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        memberNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addDSName(Element dsnNodeElement, String name) {
        Element nodechild = this.createElement("dsnamenode");
        name = this.insertEscapeChars(name);
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        dsnNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public TT_TreeItem findObject(Object object) {
        TT_TreeItem result = null;
        for (TT_TreeItem node : this.datasets) {
            result = node.findValue(object);
            if (result != null) break;
        }
        return result;
    }

    public int indexOf(TT_TreeItem item) {
        TT_TreeItem parent = item.getParent();
        if (parent == null) {
            return this.datasets.indexOf(item);
        }
        TT_TreeItem[] childs = (TT_TreeItem[])parent.getChildren();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].equals((Object)item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TT_TreeItem removeItem(Object element) {
        TT_TreeItem item = this.findObject(element);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.datasets.size() > 0) {
                return this.datasets.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem removeItem(Object element, TT_TreeItem elementParent) {
        TT_TreeItem item = this.findObjectInTree(element, elementParent);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem findObjectInTree(Object object, TT_TreeItem treeItem) {
        TT_TreeItem result = null;
        result = this.findObject(treeItem).findValue(object);
        return result;
    }

    public Element createElement(String name) {
        return this.dsnlistXML.createElement(name);
    }

    public TT_TreeItem[] getDatasets() {
        return this.datasets.toArray(new TT_TreeItem[this.datasets.size()]);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public TT_TreeItem reposition(Object element, int direction) {
        TT_TreeItem item = this.findObject(element);
        boolean isDataset = item.getParent() == null;
        int index = this.indexOf(item);
        if (isDataset) {
            Element[] dsnListDatasets = this.dsnlistXML.getDSNListDatasets();
            Element top = this.dsnlistXML.getTop();
            if (direction == 0) {
                top.insertBefore(dsnListDatasets[index], dsnListDatasets[index - 1]);
                TT_TreeItem temp = this.datasets.get(index - 1);
                this.datasets.set(index - 1, this.datasets.get(index));
                this.datasets.set(index, temp);
            } else if (direction == 1) {
                top.insertBefore(dsnListDatasets[index + 1], dsnListDatasets[index]);
                TT_TreeItem temp = this.datasets.get(index + 1);
                this.datasets.set(index + 1, this.datasets.get(index));
                this.datasets.set(index, temp);
            }
            this.save();
        } else {
            int parentIndex = this.indexOf(item.getParent());
            Element parentDatasetElement = item.getParent().getElement();
            Element[] layoutMembers = this.dsnlistXML.getMembers(parentDatasetElement);
            if (direction == 0) {
                parentDatasetElement.insertBefore(layoutMembers[index], layoutMembers[index - 1]);
                TT_TreeItem[] temp = (TT_TreeItem[])this.datasets.get(parentIndex).getChildren();
                this.datasets.get(parentIndex).removeChild(temp[index - 1]);
                this.datasets.get(parentIndex).removeChild(temp[index]);
                this.datasets.get(parentIndex).addChild(temp[index]);
                this.datasets.get(parentIndex).addChild(temp[index - 1]);
                int i = index + 1;
                while (i < temp.length) {
                    this.datasets.get(parentIndex).removeChild(temp[i]);
                    this.datasets.get(parentIndex).addChild(temp[i]);
                    ++i;
                }
            } else if (direction == 1) {
                parentDatasetElement.insertBefore(layoutMembers[index + 1], layoutMembers[index]);
                TT_TreeItem[] temp = (TT_TreeItem[])this.datasets.get(parentIndex).getChildren();
                this.datasets.get(parentIndex).removeChild(temp[index]);
                this.datasets.get(parentIndex).removeChild(temp[index + 1]);
                this.datasets.get(parentIndex).addChild(temp[index + 1]);
                this.datasets.get(parentIndex).addChild(temp[index]);
                int i = index + 2;
                while (i < temp.length) {
                    this.datasets.get(parentIndex).removeChild(temp[i]);
                    this.datasets.get(parentIndex).addChild(temp[i]);
                    ++i;
                }
            }
            this.save();
        }
        return item;
    }

    protected static enum Position {
        first,
        last,
        before,
        after;

    }
}

