/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.MemberSorter;
import com.ca.filemaster.ui.wizards.RecordCountLabelProvider;
import com.ca.filemaster.ui.wizards.TimeChangedLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FMMembersTable {
    private Composite container;
    private Group memberGroup;
    private CheckboxTableViewer viewer;
    private Listener sortListener;
    private Button clearSelBtn;
    private Button deleteListBtn;
    private static ArrayList<String> memberList;

    public FMMembersTable(Composite container) {
        this.container = container;
    }

    public void createTable() {
        Composite tableComp = new Composite(this.container, 0);
        GridLayout table_Layout = new GridLayout(1, false);
        tableComp.setLayout((Layout)table_Layout);
        this.memberGroup = new Group(this.container, 0);
        this.memberGroup.setSize(this.memberGroup.computeSize(-1, -1));
        this.memberGroup.setText("Members");
        this.memberGroup.setLayout((Layout)new GridLayout(1, false));
        this.memberGroup.setRedraw(true);
        this.createViewer((Composite)this.memberGroup);
        this.createButtons((Composite)this.memberGroup);
    }

    public void createButtons(Composite parent) {
        Composite btncomposite = new Composite(parent, 0);
        btncomposite.setLayout((Layout)new GridLayout(2, false));
        btncomposite.setSize(btncomposite.computeSize(-1, -1));
        this.clearSelBtn = new Button(btncomposite, 0x1000000);
        GridData gd_btnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnClear.widthHint = 120;
        this.clearSelBtn.setLayoutData((Object)gd_btnClear);
        this.clearSelBtn.setText("&Clear Selections");
        this.clearSelBtn.setEnabled(false);
        this.clearSelBtn.setEnabled(false);
        this.deleteListBtn = new Button(btncomposite, 0x1000000);
        this.deleteListBtn.setText("Dele&te List");
        this.deleteListBtn.setEnabled(false);
    }

    public Button getClearSelBtn() {
        return this.clearSelBtn;
    }

    public Button getDeleteListBtn() {
        return this.deleteListBtn;
    }

    private void createViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            this.viewer.getTable().setLinesVisible(true);
            ++i;
        }
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_table.heightHint = 160;
        gd_table.widthHint = 620;
        this.viewer.getTable().setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(null);
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"Member", "Record Count", "Created", "Changed", "Time Changed", "ID"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100};
        this.viewer.setSorter((ViewerSorter)new MemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.viewer.getTable().setSortColumn(tableColumn);
                    this.viewer.getTable().setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RecordCountLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TimeChangedLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = FMMembersTable.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                FMMembersTable.this.viewer.refresh();
            }
        };
    }

    public void insertMembersToTable(List<FileMasterMember> members) {
        if (members == null) {
            return;
        }
        ArrayList<FileMasterMember> oldMembers = new ArrayList<FileMasterMember>();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            if (this.viewer.getTable().getItem(i).getChecked()) {
                oldMembers.add((FileMasterMember)((Object)this.viewer.getElementAt(i)));
            }
            ++i;
        }
        i = 0;
        while (i < members.size()) {
            oldMembers.add(members.get(i));
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)oldMembers.toArray());
        this.viewer.setAllChecked(true);
        if (this.viewer.getTable().getItemCount() == 0) {
            this.clearSelBtn.setEnabled(false);
        }
        if (this.viewer.getCheckedElements().length == this.viewer.getTable().getItemCount()) {
            this.clearSelBtn.setText("&Clear Selections");
        } else {
            this.clearSelBtn.setText("Select &All");
        }
        if (members.size() > 0) {
            i = 0;
            while (i < this.viewer.getTable().getItemCount()) {
                ((FileMasterMember)((Object)this.viewer.getTable().getItems()[i].getData())).setChecked(true);
                ++i;
            }
            this.clearSelBtn.setEnabled(true);
            this.deleteListBtn.setEnabled(true);
        }
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public ArrayList<String> getPrintTblMembers() {
        memberList = new ArrayList();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            memberList.add(((FileMasterMember)((Object)this.viewer.getTable().getItems()[i].getData())).getName());
            ++i;
        }
        return memberList;
    }
}

