/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.utilities.CompareGenericWizardPage1;
import com.ca.filemaster.utility.compare.CompareProgramPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage1;
import com.ca.filemaster.utility.compare.CompareWizardPage2;
import com.ca.filemaster.utility.compare.CompareWizardPage3;
import com.ca.filemaster.utility.compare.CompareWizardPage4;
import com.ca.filemaster.utility.compare.CompareWizardPage5;
import com.ca.filemaster.utility.compare.ProgramCompareSummaryPage;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.HashMap;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;

public class CompareGenericWizard
extends Wizard {
    private FileMasterServer server;
    private CompareGenericWizardPage1 page1pgm;
    private CompareWizardPage1 page1;
    private CompareWizardPage2 page2;
    private CompareWizardPage4 page4;
    private CompareWizardPage5 page5;
    private CompareProgramPage3 page3Pgm;
    private ProgramCompareSummaryPage summaryPage;
    private FileMasterDataset dataSet;

    public CompareGenericWizard() {
        this.setWindowTitle("New Data Set");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Compare Utility");
        if (selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() != null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
            } else {
                this.server = (FileMasterServer)treeItem.getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getValue();
            }
        }
    }

    public void addPages() {
        if (this.getPageCount() == 0) {
            this.setForcePreviousAndNextButtons(true);
            TrayDialog.setDialogHelpAvailable((boolean)true);
            this.page1pgm = new CompareGenericWizardPage1(this.server);
            this.addPage((IWizardPage)this.page1pgm);
            this.page1 = new CompareWizardPage1("Old Data Set", this.server, this.dataSet, null, "");
            HashMap<String, String> map = new HashMap<String, String>();
            this.addPage((IWizardPage)this.page1);
            this.page2 = new CompareWizardPage2("New Data Set", this.server, this.dataSet, map, false);
            this.addPage((IWizardPage)this.page2);
            this.addPage((IWizardPage)new CompareWizardPage3("Options", this.server, "", ""));
            this.page4 = new CompareWizardPage4();
            this.addPage((IWizardPage)this.page4);
            this.page5 = new CompareWizardPage5();
            this.addPage((IWizardPage)this.page5);
            this.page3Pgm = new CompareProgramPage3("Compare Program Options");
            this.summaryPage = new ProgramCompareSummaryPage();
            this.addPage((IWizardPage)this.page3Pgm);
            this.addPage((IWizardPage)this.summaryPage);
        }
    }

    public void addComparePgmPages() {
        this.page3Pgm = new CompareProgramPage3("Options");
        this.summaryPage = new ProgramCompareSummaryPage();
        this.addPage((IWizardPage)this.page3Pgm);
        this.addPage((IWizardPage)this.summaryPage);
        this.summaryPage.createControl((Composite)this.getShell());
    }

    public void addComparePages(String serverName, String layoutDS, String layoutMem) {
        this.addPage((IWizardPage)new CompareWizardPage3("Options", this.server, layoutDS, layoutMem));
        this.page4 = new CompareWizardPage4();
        this.addPage((IWizardPage)this.page4);
        this.page5 = new CompareWizardPage5();
        this.addPage((IWizardPage)this.page5);
        this.page5.createControl((Composite)this.getShell());
    }

    public boolean canFinish() {
        return this.page1pgm.canFinish();
    }

    public boolean performFinish() {
        this.page1.insertIntoDirecotryList();
        this.page2.insertIntoDirecotryList();
        return this.page1pgm.doFinish();
    }
}

