/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.utility.copy.CopyVSAMFromWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMSummaryPage;
import com.ca.filemaster.utility.copy.CopyVSAMToWizardPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.VSAMSelectionCrtLayoutWizardPage;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CopyVSAMUtilityWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private CopyVSAMFromWizardPage page1;
    private SelectionCrtLayoutWizardPage page3;
    private IStructuredSelection selection;
    private FileMasterDataset dataSet;
    private FileMasterServer server;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Copy VSAM Utility");
        this.selection = selection;
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        if (this.selection.getFirstElement() != null) {
            TT_TreeItem treeItem = (TT_TreeItem)this.selection.getFirstElement();
            if (treeItem.getParent() == null) {
                this.server = (FileMasterServer)treeItem.getValue();
            } else if (treeItem.getParent().getParent() != null) {
                this.server = (FileMasterServer)treeItem.getParent().getParent().getValue();
                this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
            } else {
                this.dataSet = (FileMasterDataset)treeItem.getValue();
                this.server = (FileMasterServer)treeItem.getParent().getValue();
            }
            this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getText(), "", this.server);
            if (CommonMFCalls.RETURN_CODE.equals("0") && this.dataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                this.dataSet.setName(((FMPVSAMDataset)this.dataSet).getCluster());
            }
        }
        this.page1 = new CopyVSAMFromWizardPage("Copy VSAM From", this.server, this.dataSet, true);
        this.addPage((IWizardPage)this.page1);
        this.page3 = new VSAMSelectionCrtLayoutWizardPage("Options", this.server.getName(), this.dataSet.getName(), "", "", "");
        this.addPage((IWizardPage)this.page3);
        CopyVSAMSummaryPage page4 = new CopyVSAMSummaryPage("Copy VSAM Summary");
        this.addPage((IWizardPage)page4);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Copy VSAM From")) {
            return false;
        }
        return ((CopyVSAMToWizardPage)this.page1.getNextPage()).isPageComplete() && this.page3.isPageComplete();
    }

    public boolean performFinish() {
        return ((CopyVSAMToWizardPage)this.page1.getNextPage()).doFinish();
    }
}

