/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.print;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utilities.AllocateNewDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizard;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PrintUtilityWizardPageThree
extends WizardPage
implements ModifyListener,
SelectionListener {
    public static final int DESTINATION_PRINTER = 1;
    public static final int EXTERNAL_JES_NODE = 2;
    public static final int SYSOUT_WRITER_NAME = 3;
    public static final int PRINT_DATA_SET_NAME = 4;
    protected Composite mainComposite;
    private Composite placeHolderComposite;
    private Composite fileTypeComposite;
    private Composite printDestComposite;
    public static Button destPrinterRadioButton;
    public static Button extJESRadioButton;
    public static Button writerNameRadioButton;
    public static Button dsetNameRadioButton;
    public Button newDispRadioButton;
    public Button oldDispRadioButton;
    public Button shrDispRadioButton;
    public Button pdsRadioButton;
    public Button seqRadioButton;
    public Button vsamRadioButton;
    public Button allocateButton;
    public static Button btnSetPrintDestination;
    public static Combo sysOutClassCombo;
    public static Combo destPrinterCombo;
    public static Combo extJESnodeCombo;
    public static Combo extJESuserCombo;
    public static Combo dsetNameCombo;
    public static Combo memberNameCombo;
    public static Combo writerNameCombo;
    private Label useridAtJESLabel;
    private Label memberNameLabel;
    boolean destPrinterSelected;
    boolean extJESSelected;
    boolean writerNameSelected;
    boolean dsetNameSelected;
    public String error;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.printOne";
    private final String CONTEXT_HELP_ID_ChgLogPrint = "com.ca.filemaster.help.PrintChgLogOpt";
    private TestingToolsWizardDialog dialog = null;
    public static Spinner numberOfCopiesSpinner;
    private FileMasterServer server;
    private Group grpDataSetDisposition;
    private Group grpNewAllocation;
    private Map<String, String> map;
    private boolean isChangelogPrint = false;

    protected PrintUtilityWizardPageThree(String titlePageThree, String serverName) {
        super(titlePageThree);
        this.setTitle(titlePageThree);
        this.destPrinterSelected = true;
        this.server = FMServerTreeModel.getInstance().getServer(serverName);
        this.dsetNameSelected = false;
        this.writerNameSelected = false;
        this.extJESSelected = false;
        this.isChangelogPrint = true;
    }

    protected PrintUtilityWizardPageThree(String titlePageThree, String serverName, Map<String, String> map) {
        super(titlePageThree);
        this.setTitle(titlePageThree);
        this.destPrinterSelected = true;
        this.server = FMServerTreeModel.getInstance().getServer(serverName);
        this.dsetNameSelected = false;
        this.writerNameSelected = false;
        this.extJESSelected = false;
        this.map = map;
    }

    public void createControl(Composite parent) {
        if (this.isChangelogPrint) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.PrintChgLogOpt");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.printOne");
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(this.mainComposite, 0);
        composite.setSize(composite.computeSize(-1, -1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblSysoutClass = new Label(composite, 0);
        GridData gd_lblSysoutClass = new GridData(16384, 4, false, false, 1, 1);
        gd_lblSysoutClass.heightHint = 15;
        lblSysoutClass.setLayoutData((Object)gd_lblSysoutClass);
        lblSysoutClass.setSize(66, 15);
        lblSysoutClass.setText("S&ysout class:");
        sysOutClassCombo = new Combo(composite, 8);
        GridData gd_sysOutClassCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_sysOutClassCombo.widthHint = 89;
        sysOutClassCombo.setLayoutData((Object)gd_sysOutClassCombo);
        sysOutClassCombo.setVisibleItemCount(100);
        sysOutClassCombo.setItems(new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*"});
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblNewLabel.setSize(98, 15);
        lblNewLabel.setText("Nu&mber of copies:");
        numberOfCopiesSpinner = new Spinner(composite, 2048);
        numberOfCopiesSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        numberOfCopiesSpinner.setTextLimit(3);
        numberOfCopiesSpinner.setSelection(1);
        numberOfCopiesSpinner.setMaximum(999);
        numberOfCopiesSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        this.placeHolderComposite = new Composite(this.mainComposite, 0);
        GridData gd_placeHolderComposite = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_placeHolderComposite.heightHint = 20;
        this.placeHolderComposite.setLayoutData((Object)gd_placeHolderComposite);
        this.placeHolderComposite.setSize(this.placeHolderComposite.computeSize(-1, -1));
        btnSetPrintDestination = new Button(this.mainComposite, 32);
        btnSetPrintDestination.setText("&Define print destination");
        final Group grpPrintDestination = new Group(this.mainComposite, 0);
        grpPrintDestination.setEnabled(false);
        grpPrintDestination.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpPrintDestination.setText("Print destination");
        grpPrintDestination.setLayout((Layout)new GridLayout(1, false));
        this.printDestComposite = new Composite((Composite)grpPrintDestination, 0);
        this.printDestComposite.setSize(this.printDestComposite.computeSize(-1, -1));
        GridData gd_grpPrintDestination = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_grpPrintDestination.widthHint = 537;
        this.printDestComposite.setLayoutData((Object)gd_grpPrintDestination);
        this.printDestComposite.setLayout((Layout)new GridLayout(2, false));
        destPrinterRadioButton = new Button(this.printDestComposite, 16);
        destPrinterRadioButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        destPrinterRadioButton.setEnabled(false);
        destPrinterRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                destPrinterCombo.setEnabled(true);
                extJESnodeCombo.setEnabled(false);
                dsetNameCombo.setEnabled(false);
                memberNameCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.memberNameLabel.setEnabled(false);
                writerNameCombo.setEnabled(false);
                extJESuserCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(false);
                PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(false);
                PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        destPrinterRadioButton.setText("Des&tination printer:");
        destPrinterCombo = new Combo(this.printDestComposite, 0);
        destPrinterCombo.setEnabled(false);
        destPrinterCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        destPrinterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        destPrinterCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        destPrinterCombo.setTextLimit(8);
        extJESRadioButton = new Button(this.printDestComposite, 16);
        extJESRadioButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        extJESRadioButton.setEnabled(false);
        extJESRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                destPrinterCombo.setEnabled(false);
                extJESnodeCombo.setEnabled(true);
                dsetNameCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.memberNameLabel.setEnabled(false);
                memberNameCombo.setEnabled(false);
                writerNameCombo.setEnabled(false);
                extJESuserCombo.setEnabled(true);
                PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(false);
                PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(true);
                PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        extJESRadioButton.setText("Exte&rnal JES node:");
        extJESnodeCombo = new Combo(this.printDestComposite, 0);
        extJESnodeCombo.setEnabled(false);
        extJESnodeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        extJESnodeCombo.setTextLimit(8);
        this.useridAtJESLabel = new Label(this.printDestComposite, 0);
        GridData gd_useridAtJESLabel = new GridData(16384, 4, false, false, 1, 1);
        gd_useridAtJESLabel.horizontalIndent = 18;
        this.useridAtJESLabel.setLayoutData((Object)gd_useridAtJESLabel);
        this.useridAtJESLabel.setEnabled(false);
        this.useridAtJESLabel.setText("&Userid at JES node:");
        extJESuserCombo = new Combo(this.printDestComposite, 0);
        extJESuserCombo.setEnabled(false);
        extJESuserCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        extJESuserCombo.setTextLimit(8);
        extJESuserCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        extJESuserCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        writerNameRadioButton = new Button(this.printDestComposite, 16);
        writerNameRadioButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        writerNameRadioButton.setEnabled(false);
        writerNameRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                destPrinterCombo.setEnabled(false);
                extJESnodeCombo.setEnabled(false);
                dsetNameCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.memberNameLabel.setEnabled(false);
                memberNameCombo.setEnabled(false);
                writerNameCombo.setEnabled(true);
                extJESuserCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(false);
                PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(false);
                PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(false);
                PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        writerNameRadioButton.setText("Sysout &writer name:");
        writerNameCombo = new Combo(this.printDestComposite, 0);
        writerNameCombo.setEnabled(false);
        writerNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        writerNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        writerNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        writerNameCombo.setTextLimit(8);
        dsetNameRadioButton = new Button(this.printDestComposite, 16);
        dsetNameRadioButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        dsetNameRadioButton.setEnabled(false);
        dsetNameRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                destPrinterCombo.setEnabled(false);
                extJESnodeCombo.setEnabled(false);
                dsetNameCombo.setEnabled(true);
                PrintUtilityWizardPageThree.this.memberNameLabel.setEnabled(true);
                memberNameCombo.setEnabled(true);
                writerNameCombo.setEnabled(false);
                extJESuserCombo.setEnabled(false);
                PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(true);
                PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(true);
                PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(true);
                PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(true);
                PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(true);
                PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(false);
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        dsetNameRadioButton.setText("Print data set nam&e:");
        dsetNameCombo = new Combo(this.printDestComposite, 0);
        dsetNameCombo.setEnabled(false);
        dsetNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        dsetNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        dsetNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        dsetNameCombo.setTextLimit(44);
        this.memberNameLabel = new Label(this.printDestComposite, 0);
        GridData gd_memberNameLabel = new GridData(16384, 4, false, false, 1, 1);
        gd_memberNameLabel.horizontalIndent = 18;
        this.memberNameLabel.setLayoutData((Object)gd_memberNameLabel);
        this.memberNameLabel.setEnabled(false);
        this.memberNameLabel.setText("Pr&int member name:");
        memberNameCombo = new Combo(this.printDestComposite, 0);
        memberNameCombo.setEnabled(false);
        memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        memberNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        memberNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        memberNameCombo.setTextLimit(8);
        this.grpDataSetDisposition = new Group(this.printDestComposite, 0);
        this.grpDataSetDisposition.setText("Data set disposition");
        GridData gd_grpDataSetDisposition = new GridData(4, 4, false, false, 2, 1);
        gd_grpDataSetDisposition.horizontalIndent = 15;
        this.grpDataSetDisposition.setLayoutData((Object)gd_grpDataSetDisposition);
        this.grpDataSetDisposition.setLayout((Layout)new GridLayout(1, false));
        Composite dispositionComposite = new Composite((Composite)this.grpDataSetDisposition, 0);
        dispositionComposite.setSize(dispositionComposite.computeSize(-1, -1));
        dispositionComposite.setLayout((Layout)new GridLayout(3, false));
        this.shrDispRadioButton = new Button(dispositionComposite, 16);
        this.shrDispRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
            }
        });
        this.shrDispRadioButton.setEnabled(false);
        this.shrDispRadioButton.setText("S&HR");
        this.oldDispRadioButton = new Button(dispositionComposite, 16);
        this.oldDispRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
            }
        });
        this.oldDispRadioButton.setEnabled(false);
        this.oldDispRadioButton.setText("M&OD");
        this.newDispRadioButton = new Button(dispositionComposite, 16);
        this.newDispRadioButton.setEnabled(false);
        this.newDispRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Validator.printDataset(dsetNameCombo.getText()) == 0) {
                    PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(true);
                }
            }
        });
        this.newDispRadioButton.setText("N&EW");
        this.newDispRadioButton.addSelectionListener((SelectionListener)this);
        this.shrDispRadioButton.addSelectionListener((SelectionListener)this);
        this.oldDispRadioButton.addSelectionListener((SelectionListener)this);
        sysOutClassCombo.select(0);
        this.grpNewAllocation = new Group(this.printDestComposite, 0);
        this.grpNewAllocation.setText("New allocation");
        GridData gd_grpNewAllocation = new GridData(4, 4, false, false, 2, 1);
        gd_grpNewAllocation.horizontalIndent = 15;
        this.grpNewAllocation.setLayoutData((Object)gd_grpNewAllocation);
        this.grpNewAllocation.setLayout((Layout)new GridLayout(1, false));
        this.fileTypeComposite = new Composite((Composite)this.grpNewAllocation, 0);
        this.fileTypeComposite.setSize(this.fileTypeComposite.computeSize(-1, -1));
        this.fileTypeComposite.setLayout((Layout)new GridLayout(4, false));
        this.pdsRadioButton = new Button(this.fileTypeComposite, 16);
        this.pdsRadioButton.setText("&PDS");
        this.pdsRadioButton.setEnabled(false);
        this.seqRadioButton = new Button(this.fileTypeComposite, 16);
        this.seqRadioButton.setText("SE&Q");
        this.seqRadioButton.setEnabled(false);
        this.vsamRadioButton = new Button(this.fileTypeComposite, 16);
        this.vsamRadioButton.setText("VS&AM");
        this.vsamRadioButton.setEnabled(false);
        this.allocateButton = new Button(this.fileTypeComposite, 0);
        this.allocateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintUtilityWizardPageThree.this.vsamRadioButton.getSelection()) {
                    PrintUtilityWizardPageThree.this.dialog = new TestingToolsWizardDialog(PrintUtilityWizardPageThree.this.getShell(), (IWizard)new AllocateNewVSAMDataSetWizard(dsetNameCombo.getText(), PrintUtilityWizardPageThree.this.server, ""));
                    PrintUtilityWizardPageThree.this.dialog.create();
                    PrintUtilityWizardPageThree.this.dialog.open();
                } else if (PrintUtilityWizardPageThree.this.pdsRadioButton.getSelection()) {
                    PrintUtilityWizardPageThree.this.dialog = new TestingToolsWizardDialog(PrintUtilityWizardPageThree.this.getShell(), (IWizard)new AllocateNewDataSetWizard(true, dsetNameCombo.getText().trim(), false, PrintUtilityWizardPageThree.this.server));
                    PrintUtilityWizardPageThree.this.dialog.create();
                    PrintUtilityWizardPageThree.this.dialog.open();
                } else if (PrintUtilityWizardPageThree.this.seqRadioButton.getSelection()) {
                    PrintUtilityWizardPageThree.this.dialog = new TestingToolsWizardDialog(PrintUtilityWizardPageThree.this.getShell(), (IWizard)new AllocateNewDataSetWizard(false, dsetNameCombo.getText().trim(), false, PrintUtilityWizardPageThree.this.server));
                    PrintUtilityWizardPageThree.this.dialog.create();
                    PrintUtilityWizardPageThree.this.dialog.open();
                }
            }
        });
        this.allocateButton.setEnabled(false);
        this.allocateButton.setText("Allo&cate...");
        btnSetPrintDestination.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintUtilityWizardPageThree.this.destPrinterSelected = destPrinterRadioButton.getSelection();
                PrintUtilityWizardPageThree.this.extJESSelected = extJESRadioButton.getSelection();
                PrintUtilityWizardPageThree.this.writerNameSelected = writerNameRadioButton.getSelection();
                PrintUtilityWizardPageThree.this.dsetNameSelected = dsetNameRadioButton.getSelection();
                if (!((Button)e.getSource()).getSelection()) {
                    grpPrintDestination.setEnabled(false);
                    destPrinterRadioButton.setEnabled(false);
                    extJESRadioButton.setEnabled(false);
                    writerNameRadioButton.setEnabled(false);
                    dsetNameRadioButton.setEnabled(false);
                    destPrinterCombo.setEnabled(false);
                    extJESnodeCombo.setEnabled(false);
                    extJESuserCombo.setEnabled(false);
                    writerNameCombo.setEnabled(false);
                    dsetNameCombo.setEnabled(false);
                    memberNameCombo.setEnabled(false);
                    PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(false);
                    PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(false);
                    PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(false);
                    PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(false);
                    PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(false);
                    PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(false);
                } else {
                    grpPrintDestination.setEnabled(true);
                    destPrinterRadioButton.setEnabled(true);
                    extJESRadioButton.setEnabled(true);
                    writerNameRadioButton.setEnabled(true);
                    dsetNameRadioButton.setEnabled(true);
                    destPrinterRadioButton.setSelection(PrintUtilityWizardPageThree.this.destPrinterSelected);
                    destPrinterCombo.setEnabled(PrintUtilityWizardPageThree.this.destPrinterSelected);
                    extJESRadioButton.setSelection(PrintUtilityWizardPageThree.this.extJESSelected);
                    extJESnodeCombo.setEnabled(PrintUtilityWizardPageThree.this.extJESSelected);
                    extJESuserCombo.setEnabled(PrintUtilityWizardPageThree.this.extJESSelected);
                    PrintUtilityWizardPageThree.this.useridAtJESLabel.setEnabled(PrintUtilityWizardPageThree.this.extJESSelected);
                    writerNameRadioButton.setSelection(PrintUtilityWizardPageThree.this.writerNameSelected);
                    writerNameCombo.setEnabled(PrintUtilityWizardPageThree.this.writerNameSelected);
                    dsetNameRadioButton.setSelection(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    dsetNameCombo.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    memberNameCombo.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    PrintUtilityWizardPageThree.this.grpDataSetDisposition.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    PrintUtilityWizardPageThree.this.newDispRadioButton.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    PrintUtilityWizardPageThree.this.oldDispRadioButton.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    PrintUtilityWizardPageThree.this.shrDispRadioButton.setEnabled(PrintUtilityWizardPageThree.this.dsetNameSelected);
                    if (PrintUtilityWizardPageThree.this.newDispRadioButton.getSelection() && Validator.printDataset(dsetNameCombo.getText()) == 0) {
                        PrintUtilityWizardPageThree.this.setAllocateGroupEnabled(true);
                    }
                }
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        extJESnodeCombo.setEnabled(false);
        extJESuserCombo.setEnabled(false);
        extJESnodeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        extJESnodeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrintUtilityWizardPageThree.this.setPageComplete(PrintUtilityWizardPageThree.this.isPageComplete());
            }
        });
        FMHistory.intializeComboBoxes(destPrinterCombo, "PrintUtilPgThreeDestPrinterCombo");
        FMHistory.intializeComboBoxes(extJESnodeCombo, "PrintUtilPgThreeExtJESnodeCombo");
        FMHistory.intializeComboBoxes(extJESuserCombo, "PrintUtilPgThreeExtJESuserCombo");
        FMHistory.intializeComboBoxes(writerNameCombo, "PrintUtilPgThreeWriterNameCombo");
        FMHistory.intializeComboBoxes(dsetNameCombo, "PrintUtilPgThreeDsetNameCombo");
        FMHistory.intializeComboBoxes(memberNameCombo, "PrintUtilPgThreeMemberNameCombo");
        sysOutClassCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getSysoutClass());
        destPrinterCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getDestPrinter());
        extJESnodeCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getExtJESNode());
        extJESuserCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getUserJESNode());
        writerNameCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getSysoutWriter());
        btnSetPrintDestination.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().isDefinePrintDest());
        this.shrDispRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getDataSetDisposition().equals("SHR"));
        this.oldDispRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getDataSetDisposition().equals("MOD"));
        this.newDispRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getDataSetDisposition().equals("NEW"));
        if (this.server.getFmpPreferences().getFmPrintPrefs().getNewAllocationType().isEmpty()) {
            this.pdsRadioButton.setSelection(true);
        } else {
            this.pdsRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getNewAllocationType().equals("PDS"));
            this.seqRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getNewAllocationType().equals("SEQ"));
            this.vsamRadioButton.setSelection(this.server.getFmpPreferences().getFmPrintPrefs().getNewAllocationType().equals("VSAM"));
        }
        dsetNameCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getPrintDSN());
        memberNameCombo.setText(this.server.getFmpPreferences().getFmPrintPrefs().getPrintMember());
        switch (this.server.getFmpPreferences().getFmPrintPrefs().getPrintDestSel()) {
            case 1: {
                destPrinterRadioButton.setSelection(true);
                extJESRadioButton.setSelection(false);
                writerNameRadioButton.setSelection(false);
                dsetNameRadioButton.setSelection(false);
                break;
            }
            case 2: {
                destPrinterRadioButton.setSelection(false);
                extJESRadioButton.setSelection(true);
                writerNameRadioButton.setSelection(false);
                dsetNameRadioButton.setSelection(false);
                break;
            }
            case 3: {
                destPrinterRadioButton.setSelection(false);
                extJESRadioButton.setSelection(false);
                writerNameRadioButton.setSelection(true);
                dsetNameRadioButton.setSelection(false);
                break;
            }
            case 4: {
                destPrinterRadioButton.setSelection(false);
                extJESRadioButton.setSelection(false);
                writerNameRadioButton.setSelection(false);
                dsetNameRadioButton.setSelection(true);
                break;
            }
            default: {
                destPrinterRadioButton.setSelection(true);
                extJESRadioButton.setSelection(false);
                writerNameRadioButton.setSelection(false);
                dsetNameRadioButton.setSelection(false);
            }
        }
        btnSetPrintDestination.notifyListeners(13, new Event());
        this.setControl((Control)this.mainComposite);
        this.setPageComplete(this.isPageComplete());
        if (this.getWizard() != null) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (PrintUtilityWizardPageThree.this.getWizard().getContainer().getCurrentPage().getName().endsWith("Print Output Control") && PrintUtilityWizardPageThree.this.map != null) {
                        PrintUtilityWizardPageThree.this.map.put("Action", "Preview");
                        PrintUtilityWizardPageThree.this.getWizard().getContainer().showPage(PrintUtilityWizardPageThree.this.getWizard().getPage("Summary"));
                    }
                }
            });
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.map != null) {
            if (FMPreferences.disabledPreview()) {
                this.map.put("Action", "Finish");
            } else {
                this.map.put("Action", "Preview");
            }
            if (!FMPreferences.disabledPreview()) {
                ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
            }
        }
        sysOutClassCombo.setFocus();
    }

    public boolean isPageComplete() {
        this.error = "";
        if (!numberOfCopiesSpinner.getText().isEmpty()) {
            if (Integer.valueOf(numberOfCopiesSpinner.getText()) == 0) {
                this.error = String.valueOf(this.error) + "Number of copies can not be zero\n ";
            } else if (Integer.valueOf(numberOfCopiesSpinner.getText()) > 255) {
                this.error = String.valueOf(this.error) + "Maximum number of copies is 255\n ";
            }
        }
        if (btnSetPrintDestination.getSelection()) {
            if (destPrinterRadioButton.getSelection()) {
                switch (Validator.printerID(destPrinterCombo.getText())) {
                    case 33: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[33] + "\n";
                        break;
                    }
                    case 31: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[31] + "\n";
                        break;
                    }
                    case 32: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[32] + "\n";
                    }
                }
            } else if (extJESRadioButton.getSelection()) {
                switch (Validator.nodeJES(extJESnodeCombo.getText())) {
                    case 36: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[36] + "\n ";
                        break;
                    }
                    case 34: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[34] + "\n ";
                        break;
                    }
                    case 35: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[35] + "\n ";
                    }
                }
                switch (Validator.userJES(extJESuserCombo.getText())) {
                    case 39: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[39] + "\n";
                        break;
                    }
                    case 37: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[37] + "\n";
                        break;
                    }
                    case 38: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[38] + "\n";
                    }
                }
            } else if (writerNameRadioButton.getSelection()) {
                switch (Validator.sysoutWriter(writerNameCombo.getText())) {
                    case 40: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[40] + "\n";
                        break;
                    }
                    case 41: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[41] + "\n";
                    }
                }
            } else if (dsetNameRadioButton.getSelection()) {
                switch (Validator.dataset(dsetNameCombo.getText(), true)) {
                    case 1: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[42] + "\n ";
                        this.setAllocateGroupEnabled(false);
                        break;
                    }
                    case 2: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[43] + "\n ";
                        this.setAllocateGroupEnabled(false);
                        break;
                    }
                    case 4: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[44] + "\n ";
                        this.setAllocateGroupEnabled(false);
                        break;
                    }
                    case 0: {
                        if (!this.newDispRadioButton.getSelection()) break;
                        this.setAllocateGroupEnabled(true);
                    }
                }
                switch (Validator.member(memberNameCombo.getText(), false)) {
                    case 7: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[49] + "\n";
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[48] + "\n";
                        break;
                    }
                }
            }
        }
        if (this.error.length() != 0) {
            this.setErrorMessage(this.error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setAllocateGroupEnabled(boolean enabled) {
        this.grpNewAllocation.setEnabled(enabled);
        this.pdsRadioButton.setEnabled(enabled);
        this.seqRadioButton.setEnabled(enabled);
        this.vsamRadioButton.setEnabled(enabled);
        this.allocateButton.setEnabled(enabled);
    }

    public boolean doFinish() {
        FMHistory.insertHistory(destPrinterCombo, "PrintUtilPgThreeDestPrinterCombo");
        FMHistory.insertHistory(extJESnodeCombo, "PrintUtilPgThreeExtJESnodeCombo");
        FMHistory.insertHistory(extJESuserCombo, "PrintUtilPgThreeExtJESuserCombo");
        FMHistory.insertHistory(writerNameCombo, "PrintUtilPgThreeWriterNameCombo");
        FMHistory.insertHistory(dsetNameCombo, "PrintUtilPgThreeDsetNameCombo");
        FMHistory.insertHistory(memberNameCombo, "PrintUtilPgThreeMemberNameCombo");
        return true;
    }

    public void setDisp(String dataSetDisposition) {
        this.newDispRadioButton.setSelection(false);
        this.oldDispRadioButton.setSelection(false);
        this.shrDispRadioButton.setSelection(false);
        this.setAllocateGroupEnabled(false);
        if (dataSetDisposition.equals("SHR")) {
            this.shrDispRadioButton.setSelection(true);
        } else if (dataSetDisposition.equals("MOD")) {
            this.oldDispRadioButton.setSelection(true);
        } else if (dataSetDisposition.equals("NEW")) {
            this.newDispRadioButton.setSelection(true);
            this.setAllocateGroupEnabled(true);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void setNewAllocationType(String newAllocationType) {
        if (newAllocationType.equals("PDS")) {
            this.pdsRadioButton.setSelection(true);
        } else if (newAllocationType.equals("SEQ")) {
            this.seqRadioButton.setSelection(true);
        } else if (newAllocationType.equals("VSAM")) {
            this.vsamRadioButton.setSelection(true);
        }
    }

    public String getSysoutClass() {
        if (sysOutClassCombo == null) {
            return "A";
        }
        return sysOutClassCombo.getText();
    }

    public String getNumberOfCopies() {
        if (numberOfCopiesSpinner == null) {
            return "1";
        }
        return numberOfCopiesSpinner.getText();
    }

    public String getDestinationPrinter() {
        if (destPrinterCombo == null) {
            return "";
        }
        return destPrinterCombo.getText();
    }

    public String getExternalJESNode() {
        if (extJESnodeCombo == null) {
            return "";
        }
        return extJESnodeCombo.getText();
    }

    public String getUseridAtJESNode() {
        if (extJESuserCombo == null) {
            return "";
        }
        return extJESuserCombo.getText();
    }

    public String getSysoutWriterName() {
        if (writerNameCombo == null) {
            return "";
        }
        return writerNameCombo.getText();
    }

    public String getPrintDataSetName() {
        if (dsetNameCombo == null) {
            return "";
        }
        return dsetNameCombo.getText();
    }

    public String getPrintMemberName() {
        if (memberNameCombo == null) {
            return "";
        }
        return memberNameCombo.getText();
    }

    public String getDataSetDisposition() {
        if (this.oldDispRadioButton == null) {
            return "SHR";
        }
        if (this.oldDispRadioButton.getSelection()) {
            return "MOD";
        }
        if (this.newDispRadioButton.getSelection()) {
            return "NEW";
        }
        return "SHR";
    }

    public String getNewAllocationType() {
        if (this.seqRadioButton.getSelection()) {
            return "SEQ";
        }
        if (this.vsamRadioButton.getSelection()) {
            return "VSAM";
        }
        return "PDS";
    }

    public boolean definePrintDestination() {
        if (btnSetPrintDestination == null) {
            return false;
        }
        return btnSetPrintDestination.getSelection();
    }

    public int getPrintdestination() {
        if (btnSetPrintDestination == null) {
            return 0;
        }
        if (destPrinterRadioButton.getSelection()) {
            return 1;
        }
        if (extJESRadioButton.getSelection()) {
            return 2;
        }
        if (writerNameRadioButton.getSelection()) {
            return 3;
        }
        if (dsetNameRadioButton.getSelection()) {
            return 4;
        }
        return 0;
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("&Allocate...")) {
            if (this.vsamRadioButton.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewVSAMDataSetWizard(dsetNameCombo.getText(), this.server, ""));
                this.dialog.create();
                this.dialog.open();
            } else if (this.pdsRadioButton.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(true, dsetNameCombo.getText().trim(), false, this.server));
                this.dialog.create();
                this.dialog.open();
            } else if (this.seqRadioButton.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(false, dsetNameCombo.getText().trim(), false, this.server));
                this.dialog.create();
                this.dialog.open();
            }
        } else if (((Button)source).getText().equals("S&HR") || ((Button)source).getText().equals("&OLD")) {
            this.setAllocateGroupEnabled(false);
        } else if (((Button)source).getText().equals("N&EW")) {
            this.setAllocateGroupEnabled(true);
            this.setPageComplete(this.isPageComplete());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

