/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.model;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.IMSDatabase;
import com.ca.fmp.ims.model.RequestType;
import com.ca.fmp.ims.model.generated.CatalogedDataSetType;
import com.ca.fmp.ims.model.generated.DLIFileEntryType;
import com.ca.fmp.ims.model.generated.DLIFileListType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.EditType;
import com.ca.fmp.ims.model.generated.OpenDBActionType;
import com.ca.fmp.ims.model.generated.OpenDatabaseType;
import com.ca.fmp.ims.model.generated.SelCritLinesType;
import com.ca.fmp.ims.model.generated.SelectionCriteriaType;
import com.ca.fmp.ims.model.generated.YorNType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenDatabaseRequestType
extends RequestType {
    public static final int MAX_CHARACTERS_FOR_SELCRITLINE = 74;
    private String imsEnvPDS;
    private String imsENV;
    private String dbdName;
    private String dbdTest1;
    private String dbdTest2;
    private FileMasterServer server;
    private ArrayList<String> selCritConds = new ArrayList();
    private String layoutdsn = "";
    private String customLaydsn = "";
    private String description = "";
    private DisplayModeType displayMode;
    private EditModeType editMode;
    private IMSDatabase imsDB;
    private OpenDBActionType action;
    private String PSBName;
    private long PCBNum;
    private boolean useSecondaryIndex;
    private String secondaryIndexDBD;

    public OpenDatabaseRequestType(FileMasterServer server, IMSDatabase imsDB, String description, ArrayList<String> selCritConds, OpenDBActionType action) {
        super(server);
        this.server = server;
        this.imsEnvPDS = imsDB.getIMSEmvironmentPDS();
        this.imsENV = imsDB.getIMSEnvironment();
        this.dbdName = imsDB.getDBDName();
        this.imsDB = imsDB;
        this.selCritConds = selCritConds;
        this.layoutdsn = imsDB.getLayoutDataset();
        this.customLaydsn = imsDB.getCRLDataset();
        this.description = description;
        this.displayMode = imsDB.getDisplayMode();
        this.editMode = imsDB.getEditMode();
        this.action = action;
        this.PSBName = imsDB.getPSBName();
        this.PCBNum = imsDB.getPCBnum();
        this.useSecondaryIndex = imsDB.getSecondaryIndex();
        this.secondaryIndexDBD = imsDB.getSecondaryIndexDBD();
    }

    public File createXml() {
        OpenDatabaseType openDatabaseType = new OpenDatabaseType();
        openDatabaseType.setDisplayMode(this.displayMode);
        openDatabaseType.setEditMode(this.editMode);
        openDatabaseType.setEnvname(this.imsENV);
        if (this.dbdName != null && this.dbdName.length() > 0) {
            openDatabaseType.setDbdname(this.dbdName);
        }
        openDatabaseType.setEnvdsn(this.imsEnvPDS);
        openDatabaseType.setAction(this.action);
        if (this.PSBName != null && this.PSBName.length() > 0) {
            openDatabaseType.setPsbname(this.PSBName);
            if (this.PCBNum != 0L) {
                openDatabaseType.setPcbnum(this.PCBNum);
            }
        }
        if (this.useSecondaryIndex) {
            openDatabaseType.setSIXProcessing(YorNType.Y);
            if (this.secondaryIndexDBD != null && this.secondaryIndexDBD.length() > 0) {
                openDatabaseType.setSIXdbdname(this.secondaryIndexDBD);
            }
        }
        DLIFileListType dliFileListType = new DLIFileListType();
        if (this.imsDB.getDbdDatasets() != null) {
            int i = 0;
            while (i < this.imsDB.getDbdDatasets().size()) {
                DLIFileEntryType dliFileEntryType1 = new DLIFileEntryType();
                dliFileEntryType1.setDdname(this.imsDB.getDbdDatasets().get(i).getDDName());
                dliFileEntryType1.setDbdname(this.imsDB.getDbdDatasets().get(i).getDBDName());
                dliFileEntryType1.setDsname(this.imsDB.getDbdDatasets().get(i).getFmdataset().getName());
                dliFileListType.getDLIFileEntry().add(dliFileEntryType1);
                ++i;
            }
            openDatabaseType.setDLIFileList(dliFileListType);
        }
        if (!this.selCritConds.isEmpty()) {
            SelectionCriteriaType selCrit = new SelectionCriteriaType();
            SelCritLinesType selCritLines = new SelCritLinesType();
            String header = "*** CA File Master Plus for IMS r8   Selection Criteria       ";
            selCritLines.getSelCritLine().add(header);
            selCritLines.getSelCritLine().add("\"" + this.description + "\"");
            this.parseToMultipleSelCritLines(selCritLines);
            selCrit.setSelCritLines(selCritLines);
            openDatabaseType.setSelectionCriteria(selCrit);
        }
        if (this.layoutdsn != null && !this.layoutdsn.isEmpty()) {
            CatalogedDataSetType cataloglaydsn = new CatalogedDataSetType();
            cataloglaydsn.setDsname(this.layoutdsn);
            openDatabaseType.setLayout(cataloglaydsn);
        }
        if (this.customLaydsn != null && !this.customLaydsn.isEmpty()) {
            CatalogedDataSetType cataloglaydsn = new CatalogedDataSetType();
            cataloglaydsn.setDsname(this.customLaydsn);
            openDatabaseType.setCustomLayout(cataloglaydsn);
        }
        EditType editType = new EditType();
        editType.setOpenDatabase(openDatabaseType);
        this.guiRequestType.setEdit(editType);
        this.guiRequestType.setGUIsession(this.uuid);
        return this.marshal();
    }

    protected void parseToMultipleSelCritLines(SelCritLinesType selCritLines) {
        int i = 0;
        while (i < this.selCritConds.size()) {
            String selectionCriteriaCondition = this.selCritConds.get(i);
            if (selectionCriteriaCondition.length() < 75) {
                selCritLines.getSelCritLine().add(selectionCriteriaCondition);
            } else {
                String newValueForToken;
                String x;
                ArrayList<String> matchList = new ArrayList<String>();
                Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
                Matcher regexMatcher = regex.matcher(selectionCriteriaCondition);
                while (regexMatcher.find()) {
                    matchList.add(regexMatcher.group());
                }
                int j = 0;
                while (j < matchList.size()) {
                    x = (String)matchList.get(j);
                    if (x.startsWith("\"") || x.startsWith("'") || x.startsWith(")")) {
                        String previousToken = (String)matchList.get(j - 1);
                        if (!((x.startsWith("\"") || x.startsWith("'")) && (previousToken.equals("EQ") || previousToken.equals("==") || previousToken.equals("NE") || previousToken.equals("!=") || previousToken.equals("GT") || previousToken.equals(">") || previousToken.equals("LT") || previousToken.equals("<") || previousToken.equals("GE") || previousToken.equals(">=") || previousToken.equals("LE") || previousToken.equals("<=") || previousToken.equals("CO")))) {
                            newValueForToken = String.valueOf(previousToken) + x;
                            matchList.remove(j - 1);
                            matchList.remove(j - 1);
                            matchList.add(j - 1, newValueForToken);
                            --j;
                        }
                    }
                    ++j;
                }
                int m = 0;
                while (m < matchList.size()) {
                    x = (String)matchList.get(m);
                    if (x.length() > 74) {
                        List<String> bee = OpenDatabaseRequestType.splitEqually(x, 74);
                        matchList.remove(m);
                        for (String b : bee) {
                            matchList.add(m, b);
                            ++m;
                        }
                    }
                    ++m;
                }
                int k = 0;
                while (k < matchList.size() - 1) {
                    x = (String)matchList.get(k);
                    String y = (String)matchList.get(k + 1);
                    if (x.length() + y.length() < 74) {
                        newValueForToken = String.valueOf(x) + " " + y;
                        matchList.remove(k);
                        matchList.remove(k);
                        matchList.add(k, newValueForToken);
                        --k;
                    }
                    ++k;
                }
                for (String part : matchList) {
                    selCritLines.getSelCritLine().add(part);
                }
            }
            ++i;
        }
    }

    private static List<String> splitEqually(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        int start = 0;
        while (start < text.length()) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
            start += size;
        }
        return ret;
    }

    public static void main(String[] args) {
    }
}

