/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.model;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.generated.MFResponseType;
import com.ca.fmp.ims.model.generated.ObjectFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ResponseType {
    protected ObjectFactory of;
    protected MFResponseType mfResponseType;
    protected static final String FILE_PREFIX = "com.ca.testingtools.";
    protected String uuid;
    private FileMasterServer server;

    public ResponseType(FileMasterServer server) {
        this.server = server;
        this.of = new ObjectFactory();
        this.mfResponseType = this.of.createMFResponseType();
        this.mfResponseType.setGUIsession(this.getSession());
    }

    public File marshal() {
        try {
            File xFile = File.createTempFile(FILE_PREFIX, ".xml");
            xFile.deleteOnExit();
            JAXBElement<MFResponseType> element = this.of.createMFResponse(this.mfResponseType);
            JAXBContext jc = JAXBContext.newInstance((String)"com.ca.fmp.ims.model.generated");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"ISO-8859-1");
            m.marshal(element, xFile);
            return xFile;
        }
        catch (JAXBException jaxbException) {
            jaxbException.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getSession() {
        try {
            this.uuid = FileMasterSession.getUUID((FileMasterServer)this.server, (boolean)false, (boolean)false);
            if (this.uuid != null && this.uuid.isEmpty()) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.uuid;
    }

    public String getUUID() {
        return this.uuid;
    }
}

