/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

import com.ca.fmp.ims.model.IMSSegment;

public class LevelLabelProvider extends StyledCellLabelProvider {
	
	int pixelSizeOfCharacter;
	TextLayout layout;
	
	public LevelLabelProvider(int pixelSizeOfCharacter, TextLayout layout){
		this.pixelSizeOfCharacter = pixelSizeOfCharacter;
		this.layout = layout;
	}

	@Override
	protected void paint(Event event, Object element) {
		
		IMSSegment segment = (IMSSegment) element;
		
		layout.setText(String.valueOf(segment.getSegLevel()));
		layout.setFont(JFaceResources.getTextFont());
		layout.setWidth(((TableItem)event.item).getBounds(0).width);
		layout.setAlignment(SWT.RIGHT);
		layout.draw(event.gc, event.x - pixelSizeOfCharacter, event.y);
		
	}
}
