/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.handlers;
/**
 * 
 * @author navri01
 */
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;

public class ResetPasswordHandler extends AbstractHandler implements IElementUpdater {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private static final FMServerTreeModel model = FMServerTreeModel.getInstance();	
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection){
			TT_TreeItem item = FMServerTreeModel.getInstance().findObject(((IStructuredSelection) selection).getFirstElement());
			if (item != null){
				TTServer server =item.getServer();
				if (server != null)
					server.logOff();
			}
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	
	public void updateElement(UIElement element, Map parameters) {
		// TODO Auto-generated method stub
		
	}

	
	public boolean isEnabled() {
		return model.getServers().length > 0;
	}

	
	public void setEnabled(Object evaluationContext) {
		// TODO Auto-generated method stub
		super.setEnabled(evaluationContext);
	}

}
