/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Text;

/**
 * 2014/09/05 carel06
 * - copied TraverseListenerBase class from MVS codebase 
 * - removing any instance of FileMasterRecord and FileMasterRecordField,
 *   we are trying to be independent of whatever model (FileMasterRecordField vs. SegmentField)
 *   we are using.
 * 
 * @author carel06
 */
public abstract class TraverseListenerBase implements TraverseListener {

	Logger log = Logger.getLogger(TraverseListenerBase.class.getName());
	protected TextCellEditor textCellEditor;
	private boolean keyTraverse;
	
	public TraverseListenerBase(TextCellEditor textCellEditor) {
		super();
		this.textCellEditor = textCellEditor;
	}
	
	@Override
	public void keyTraversed(TraverseEvent traverseEvent) {
		log.log(Level.INFO, "traverse listener event: " + traverseEvent.detail + " doit: " + traverseEvent.doit);
		int caretLineNumber = -1;
		int caretLineCount = -1;
		
		setkeyTraversed(true);
		Object textCellEditorControl = textCellEditor.getControl();
		if(textCellEditorControl instanceof Text && !textCellEditor.getControl().isDisposed()) {
			Text text = (Text) textCellEditorControl;
			caretLineNumber = text.getCaretLineNumber();
			
			// carel06  - Defect 1909
			// getting the line count via text.getLineCount() is faulty.
			// it returns 2 when I am using the dataset AD1QA.FMMVS90.ALTER.RRDS.FIXED.SHORT
			// From not on, manually figuring out the line count
			String lineDelimeter = text.getLineDelimiter();
			String contentOfTextWidget = text.getText();
			String[] contentsOfTextWidgetSplitIntoSeparateLines = contentOfTextWidget.split(lineDelimeter);
			caretLineCount = contentsOfTextWidgetSplitIntoSeparateLines.length; 
			log.log(Level.INFO, "abc: " +  Arrays.toString(contentsOfTextWidgetSplitIntoSeparateLines));
			log.log(Level.INFO, "text line delimeter: " + lineDelimeter);
			log.log(Level.INFO, "text caret line number: " + caretLineNumber);
			log.log(Level.INFO, "text line count: " + caretLineCount);
		}
		
		if(traverseEvent.detail == SWT.TRAVERSE_RETURN) {
			log.log(Level.INFO, "TRAVERSE_RETURN");
			moveToNext(traverseEvent);
			// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
			traverseEvent.detail = SWT.TRAVERSE_NONE;
			traverseEvent.doit = true;
		} else if(traverseEvent.detail == SWT.TRAVERSE_PAGE_NEXT) {
			log.log(Level.INFO, "TRAVERSE_PAGE_NEXT");
			moveToNext(traverseEvent);
			// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
			traverseEvent.detail = SWT.TRAVERSE_NONE;
			traverseEvent.doit = true;
		} else if(traverseEvent.detail == SWT.TRAVERSE_PAGE_PREVIOUS) {
			log.log(Level.INFO, "TRAVERSE_PAGE_PREVIOUS");
			moveToPrevious(traverseEvent);
			// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
			traverseEvent.detail = SWT.TRAVERSE_NONE;
			traverseEvent.doit = true;
		} else if(traverseEvent.detail == SWT.TRAVERSE_TAB_NEXT) {
			log.log(Level.INFO, "TRAVERSE_TAB_NEXT");
			//moveToNext(traverseEvent);
			// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
			textCellEditor.deactivate();
			traverseEvent.detail = SWT.TRAVERSE_NONE;
			traverseEvent.doit = true;
		} else if(traverseEvent.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
			log.log(Level.INFO, "TRAVERSE_TAB_PREVIOUS");
			//moveToPrevious(traverseEvent);
			// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
			textCellEditor.deactivate();
			traverseEvent.detail = SWT.TRAVERSE_NONE;
			traverseEvent.doit = true;
		} else if(traverseEvent.detail == SWT.TRAVERSE_ARROW_NEXT){
			log.log(Level.INFO, "TRAVERSE_ARROW_NEXT");
			// Differentiate arrow left from up
			if(traverseEvent.keyCode == SWT.ARROW_DOWN) {
				// if you are at the bottom of the record field, you can move to the next record using the 
				// arrow key. if you are in charmode, you are already in the bottom line, if you have hex mode on,
				// you have to be at the bottom line
				if(caretLineNumber + 1 == caretLineCount) {
					// 20141008 carel06 Defect 3158
					// just ignore the down arrow key if you are at the bottom
                    // do nothing for now until we take up this feature in a story.
//					traverseEvent.doit = false;
                    
					moveToNext(traverseEvent);
					// How can the traversal event be used to override system traversal? When the return key is pressed in a single line text control, 
					// the detail field is TRAVERSE_RETURN and the doit field is true. This means that the return key will be processed by the default 
					// button, not the text widget. If the text widget has a default selection listener, it will not run because the return key will 
					// be processed by the default button. Imagine that the text control is being used as an in-place editor and return is used to 
					// dispose the widget. Setting doit to false will stop the system from activating the default button but the key will be delivered 
					// to the text control, running the key and selection listeners for the text. How can TRAVERSE_RETURN be implemented so that the 
					// default button will not be activated and the text widget will not see the return key? This is achieved by setting doit to 
					// true, and the detail to TRAVERSE_NONE.
					traverseEvent.detail = SWT.TRAVERSE_NONE;
					traverseEvent.doit = true;
				} else {
					log.log(Level.INFO, "not at the end of the record field");
					// do nothing and let the BaseKeyListener handle it.
				}
			} else if(traverseEvent.keyCode == SWT.ARROW_RIGHT) {
				log.log(Level.INFO, "ARROW RIGHT");
				// do nothing, let BaseKeyListener handle it
			} else {
				log.log(Level.WARNING, "Unknown keyCode: " + traverseEvent.keyCode);
			}
		} else if(traverseEvent.detail == SWT.TRAVERSE_ARROW_PREVIOUS) {
			log.log(Level.INFO, "TRAVERSE_ARROW_PREVIOUS");
			if(traverseEvent.keyCode == SWT.ARROW_UP) {
				// only move to the previous record if you are at the top of the line in the record field
				if(caretLineNumber == 0) {
					// 20141008 carel06 Defect 3158
					// just ignore the down arrow key if you are at the bottom
                    // do nothing for now until we take up this feature in a story.
//					traverseEvent.doit = false;
					
					moveToPrevious(traverseEvent);
					// this will only be handled by the BaseTableTraverseListener and not the BaseKeyListener
					traverseEvent.detail = SWT.TRAVERSE_NONE;
					traverseEvent.doit = true;
				}
			} else if(traverseEvent.keyCode == SWT.ARROW_LEFT) {
				log.log(Level.INFO, "ARROW LEFT");
				// do nothing, let BaseKeyListener handle it
			} else {
				log.log(Level.WARNING, "Unknown keyCode: " + traverseEvent.keyCode);
			}
		} else {
			log.log(Level.INFO, "unrecognized traverse event: " + traverseEvent.detail);
		}
	}

	protected abstract void moveToNext(TraverseEvent traverseEvent); 
	protected abstract void moveToPrevious(TraverseEvent traverseEvent);
	
	public boolean iskeyTraversed(){
		return keyTraverse;
	}
	
	public void setkeyTraversed(boolean keyTraverse){
		this.keyTraverse = keyTraverse;
	}
}
