/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;


import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.ManagePrefsRequest;
import com.ca.fmp.ims.model.WCdsnRequestType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsType;
import com.ca.fmp.ims.model.generated.PrefsActionType;
import com.ca.fmp.ims.model.generated.PrefsParmFilesType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.wizards.DatasetWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class ConfigureMFSettingsWizardPage extends WizardPage implements
		ModifyListener,SelectionListener,FocusListener {
	
	private Composite container;
	private Composite restoreDefualtsContainer;
	
	private FileMasterDataset dataset;	
	protected TestingToolsWizardDialog dialog = null;	
	private GUIResponseType response;
	private FileMasterServer fileMasterServer;
	private FMServerTreeModel model = FMServerTreeModel.getInstance();	
	
	private Label lblCustomRecordLayouts;
	private	Combo comboCustomRecordLayouts;
	private Button btnSelectCustomRecordLayouts;
	
	private Label lblSegmentXREF; 
	private Combo comboSegmentXREF;
	private Button btnSelectSegmentXREF;
	
	private Label lblIMSEnvironments;
	private Combo comboIMSEnvironments;
	private Button btnSelectIMSEnvironments;
	
	private Button btnRestoreDefaults;
	
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";		
	
	private final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.configureMFSettingsWizard"; 
	
	public ConfigureMFSettingsWizardPage(String pageName, FileMasterServer fileMasterServer) {
		super(pageName);
		setTitle("Configure Mainframe Settings");
		this.fileMasterServer = fileMasterServer;
	}
	
	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(3, false));
		container.setSize(container.computeSize(SWT.DEFAULT, SWT.DEFAULT));		
								
             
		lblCustomRecordLayouts = new Label(container, SWT.NONE);
		lblCustomRecordLayouts.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblCustomRecordLayouts.setText("Custom &Record Layouts:");		
		comboCustomRecordLayouts = new Combo(container, SWT.NONE);
		comboCustomRecordLayouts.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		FMHistory.intializeComboBoxes(comboCustomRecordLayouts,"CustomRecordLayoutsCombo");
		comboCustomRecordLayouts.setTextLimit(44);
		comboCustomRecordLayouts.addModifyListener(this);
		comboCustomRecordLayouts.addVerifyListener(new verifytoUpperCase());
		btnSelectCustomRecordLayouts = new Button(container, SWT.NONE);
		btnSelectCustomRecordLayouts.setText("Se&lect...");
        btnSelectCustomRecordLayouts.setEnabled(true);	
        btnSelectCustomRecordLayouts.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doSelectCustomRecordLayouts();
			}
		});                
        comboCustomRecordLayouts.setText(fileMasterServer.getFmpPreferences().getCustRecLay()); //getPrefsParmFiles().getCustRecLay());
        
        
		lblSegmentXREF = new Label(container, SWT.NONE);
		lblSegmentXREF.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblSegmentXREF.setText("Segment &XREF:");		
		comboSegmentXREF = new Combo(container, SWT.NONE);
		comboSegmentXREF.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		FMHistory.intializeComboBoxes(comboSegmentXREF,"SegmentXREFCombo");
		comboSegmentXREF.setTextLimit(44);
		comboSegmentXREF.addModifyListener(this);
		comboSegmentXREF.addVerifyListener(new verifytoUpperCase());		
		btnSelectSegmentXREF = new Button(container, SWT.NONE);
		btnSelectSegmentXREF.setText("Sele&ct...");
        btnSelectSegmentXREF.setEnabled(true);
        btnSelectSegmentXREF.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doSelectSegmentXREF();
			}
		});          
        comboSegmentXREF.setText(fileMasterServer.getFmpPreferences().getSegmentXref());
        
                
		lblIMSEnvironments = new Label(container, SWT.NONE);
		lblIMSEnvironments.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblIMSEnvironments.setText("&IMS Environments:");		
		comboIMSEnvironments = new Combo(container, SWT.NONE);
		comboIMSEnvironments.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		FMHistory.intializeComboBoxes(comboIMSEnvironments,"IMSEnvironmentsCombo");
		comboIMSEnvironments.setTextLimit(44);
		comboIMSEnvironments.addModifyListener(this);
		comboIMSEnvironments.addVerifyListener(new verifytoUpperCase());		
		btnSelectIMSEnvironments = new Button(container, SWT.NONE);
		btnSelectIMSEnvironments.setText("Selec&t...");
        btnSelectIMSEnvironments.setEnabled(true);
        btnSelectIMSEnvironments.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doSelectIMSEnvironments();
			}
		});           
        comboIMSEnvironments.setText(fileMasterServer.getFmpPreferences().getEnvirons());
        
        
        restoreDefualtsContainer = new Composite(container, SWT.NONE);
		restoreDefualtsContainer.setLayout(new RowLayout(SWT.HORIZONTAL));
		GridData gd_restoreDefualtsContainer = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 3, 1);
		gd_restoreDefualtsContainer.heightHint = 223;
		restoreDefualtsContainer.setLayoutData(gd_restoreDefualtsContainer);
				             						                     
		btnRestoreDefaults = new Button(restoreDefualtsContainer, SWT.NONE);
        btnRestoreDefaults.setText("Rest&ore Values");
        btnRestoreDefaults.setEnabled(true);
        btnRestoreDefaults.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doRestoreDefualts();
			}
		});
            
                
		setControl(container);	
		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(IDialogConstants.FINISH_ID).setText("OK");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}
	
	public Combo getCustomRecordLayoutsCombo() {
		return comboCustomRecordLayouts;
	}
	
	public Combo getSegmentXREFCombo() {
		return comboSegmentXREF;
	}
	
	public Combo getIMSEnvironmentsCombo() {
		return comboIMSEnvironments;
	}	
	
	protected void doRestoreDefualts() {														
		ManagePrefsType managePrefsType= new ManagePrefsType();		
		managePrefsType.setAction(PrefsActionType.G);
	
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new ManagePrefsRequest(fileMasterServer, managePrefsType).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException e) {
			e.printStackTrace();
		}				
											
		HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(fileMasterServer, map, "opendb", true, xmlDocument);
		
		if(req.getResult() == Status.CANCEL_STATUS){
			return;
		}
		
		// Extract needed element
		GUIResponseType response = req.getGuiResponseType();
		if (response == null) {
			return;
		}
		
		ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
		if (managePrefsResponse == null) {
			return;
		}				
        
		comboCustomRecordLayouts.setText(managePrefsResponse.getPrefsParmFiles().getCustRecLay());
		comboSegmentXREF.setText(managePrefsResponse.getPrefsParmFiles().getSegmentXref());
	    comboIMSEnvironments.setText(managePrefsResponse.getPrefsParmFiles().getEnvirons());		
	}

	@Override
	public boolean canFlipToNextPage() {
		return true;
	}	

	protected void doSelectCustomRecordLayouts() {
		String datasetName = comboCustomRecordLayouts.getText().trim().toUpperCase();
		String DSLength = Integer.toHexString(comboCustomRecordLayouts.getText().length());

		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}

		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		dataset.setDSLength(DSLength);
		if(getWCResponse(dataset)){
			DatasetWizard wizard = new DatasetWizard(response, fileMasterServer);
			dialog = new TestingToolsWizardDialog(getShell(), wizard);
			dialog.create();
			DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
				@Override
				public void widgetSelected(SelectionEvent e) {
					dataset = DatasetWizardPage.getSelectedDSN();
					comboCustomRecordLayouts.setText(dataset.getName());
				}
			
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
				
				}
		    });
			dialog.open();
		}			
	}

	protected void doSelectSegmentXREF() {
		String datasetName = comboSegmentXREF.getText().trim().toUpperCase();
		String DSLength = Integer.toHexString(comboSegmentXREF.getText().length());

		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}

		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		dataset.setDSLength(DSLength);
		if(getWCResponse(dataset)){
			DatasetWizard wizard = new DatasetWizard(response, fileMasterServer);
			dialog = new TestingToolsWizardDialog(getShell(), wizard);
			dialog.create();
			DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
				@Override
				public void widgetSelected(SelectionEvent e) {
					dataset = DatasetWizardPage.getSelectedDSN();
					comboSegmentXREF.setText(dataset.getName());
				}
			
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
				
				}
		    });
			dialog.open();
		}			
	}

	protected void doSelectIMSEnvironments() {
		String datasetName = comboIMSEnvironments.getText().trim().toUpperCase();
		String DSLength = Integer.toHexString(comboIMSEnvironments.getText().length());

		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}

		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		dataset.setDSLength(DSLength);
		if(getWCResponse(dataset)){
			DatasetWizard wizard = new DatasetWizard(response, fileMasterServer);
			dialog = new TestingToolsWizardDialog(getShell(), wizard);
			dialog.create();
			DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
				@Override
				public void widgetSelected(SelectionEvent e) {
					dataset = DatasetWizardPage.getSelectedDSN();
					comboIMSEnvironments.setText(dataset.getName());
				}
			
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
				
				}
		    });
			dialog.open();
		}			
	}	
		
	@Override
	public void modifyText(ModifyEvent e) {
		setPageComplete(isPageComplete());
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {			

	}
	
	private boolean getWCResponse(FileMasterDataset dataset) {
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCdsnRequestType(fileMasterServer,dataset.getName()).createXml());
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(fileMasterServer, map, "opendb", true, xmlDocument);
		if(req.getResult()==Status.CANCEL_STATUS){
			return false;
		}
		response = req.getGuiResponseType();
		if(response==null)
			return false;
		//No error therefore proceed with further processing.
		if(response.getFunctionRC()==0 && response.getReturnCode() ==0){
			int numOfDsnReturned = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo().size();
	}
		else{
			for(int i=0;i<response.getMessages().getMessage().size();i++){
			String shortText = response.getMessages().getMessage().get(i).getShortText();
			String messageID = response.getMessages().getMessage().get(i).getMessageId();
			List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
			TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));

		}
			return false;
		}
		return true;
	}	

	public boolean isPageComplete() {				
		if(comboCustomRecordLayouts==null ||
		   comboSegmentXREF==null || comboIMSEnvironments==null ){
			return false;
		}
					
		String comboCustomRecordLayoutsString = comboCustomRecordLayouts.getText();
		String comboSegmentXREFString = comboSegmentXREF.getText();
		String comboIMSEnvironmentsString = comboIMSEnvironments.getText();				
		
		String error = "";
						
		switch (Validator.dataset(comboCustomRecordLayoutsString, true)) {
			case Validator.DS_WILDCARD:
				 error = error + Validator.errorMsg[Validator.DS_WILDCARD]
						 + "\n";
			     btnSelectCustomRecordLayouts.setEnabled(true);
			     break;
			case Validator.DS_INVALID:
			case Validator.DS_LONG:
		    case Validator.DS_MISSING:
				 error = error + Validator.errorMsg[Validator.dataset(comboCustomRecordLayoutsString, true)] + "\n ";
				 btnSelectCustomRecordLayouts.setEnabled(false);
				 break;
			case Validator.NO_ERROR:
				 btnSelectCustomRecordLayouts.setEnabled(false);
				 break;
		}
		
		switch (Validator.dataset(comboSegmentXREFString, true)) {
			case Validator.DS_WILDCARD:
			     error = error + Validator.errorMsg[Validator.DS_WILDCARD]
					     + "\n";
			     btnSelectSegmentXREF.setEnabled(true);
			     break;
			case Validator.DS_INVALID:
			case Validator.DS_LONG:
		    case Validator.DS_MISSING:
				 error = error + Validator.errorMsg[Validator.dataset(comboSegmentXREFString, true)] + "\n ";
				 btnSelectSegmentXREF.setEnabled(false);
				 break;
			case Validator.NO_ERROR:
				 btnSelectSegmentXREF.setEnabled(false);
				 break;
		}		
		
		switch (Validator.dataset(comboIMSEnvironmentsString, true)) {
			case Validator.DS_WILDCARD:
			     error = error + Validator.errorMsg[Validator.DS_WILDCARD]
				  	     + "\n";
			     btnSelectIMSEnvironments.setEnabled(true);
			     break;
		    case Validator.DS_INVALID:
		    case Validator.DS_LONG:
		    case Validator.DS_MISSING:
			     error = error + Validator.errorMsg[Validator.dataset(comboIMSEnvironmentsString, true)] + "\n ";
			     btnSelectIMSEnvironments.setEnabled(false);
			     break;
		    case Validator.NO_ERROR:
			     btnSelectIMSEnvironments.setEnabled(false);
			     break;
		}			
				
		if (error.length() > 0) {
			setErrorMessage(error);
			return false;
		}

		setErrorMessage(null);

		return true;
	}

	public boolean doFinish() {							
		// Send the preferences to the MF; if errors are returned do not close the dialog			
		if (fileMasterServer.getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("Y")){											
			ManagePrefsType managePrefsType= new ManagePrefsType();		
			managePrefsType.setAction(PrefsActionType.S);
										
			PrefsParmFilesType prefsParmFilesType = new PrefsParmFilesType();
			prefsParmFilesType.setCustRecLay(comboCustomRecordLayouts.getText());
			prefsParmFilesType.setDsnLists(fileMasterServer.getFmpPreferences().getDSNLists());
			prefsParmFilesType.setEnvirons(comboIMSEnvironments.getText());
			prefsParmFilesType.setSegmentXref(comboSegmentXREF.getText());
			prefsParmFilesType.setSelCriteria(fileMasterServer.getFmpPreferences().getSelCriteria());
										
			managePrefsType.setPrefsParmFiles(prefsParmFilesType);
		
			XMLDocument xmlDocument = null;
			try {
				xmlDocument = new XMLDocument(new ManagePrefsRequest(fileMasterServer, managePrefsType).createXml());
				int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
	    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
	    		if(uuid.equalsIgnoreCase("\""))
	    			throw new TTException();
			} catch (TTException e) {
				e.printStackTrace();
			}				
												
			HashMap<String, Object> hashMap = new HashMap<String, Object>();
			SendRequestToMainframe req = new SendRequestToMainframe(fileMasterServer, hashMap, "opendb", true, xmlDocument);
			
			if(req.getResult() == Status.CANCEL_STATUS){
				return false;
			}
			
			// Extract needed element
			GUIResponseType response = req.getGuiResponseType();
			if (response == null) {
				return false;
			}
							
			ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
			if (managePrefsResponse == null) {
				return false;
			}
			
			if(response.getMessages()!=null){			
				showError(response);
				return false;
			}			
		}
				
		FMHistory.insertHistory(getCustomRecordLayoutsCombo(), "CustomRecordLayoutsCombo"); 	
		FMHistory.insertHistory(getSegmentXREFCombo(), "SegmentXREFCombo"); 	
		FMHistory.insertHistory(getIMSEnvironmentsCombo(), "IMSEnvironmentsCombo");		
		
		fileMasterServer.getFmpPreferences().setSelCriteria(fileMasterServer.getFmpPreferences().getSelCriteria());
		fileMasterServer.getFmpPreferences().setCustRecLay(comboCustomRecordLayouts.getText());
		fileMasterServer.getFmpPreferences().setSegmentXref(comboSegmentXREF.getText());
		fileMasterServer.getFmpPreferences().setEnvirons(comboIMSEnvironments.getText());
						
		model.updatePrefs(fileMasterServer.getElement(),
				          fileMasterServer.getFmpPreferences().getDSNLists(),
				          fileMasterServer.getFmpPreferences().getSelCriteria(), comboCustomRecordLayouts.getText(), comboSegmentXREF.getText(), comboIMSEnvironments.getText());
		model.updateserver(fileMasterServer.getElement(), fileMasterServer, "Y");
		model.updateModelPrefs(fileMasterServer.getElement(), fileMasterServer);		
		model.save();		
											
		return true;
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	@Override
    public void focusGained(FocusEvent e) {
          setPageComplete(isPageComplete());
    }

    @Override
    public void focusLost(FocusEvent e) {
          
    }
    
	private void showError(GUIResponseType guiResponseType) {
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageText = new ArrayList<String>();
		messageIDFinal = new String();
		messageTextFinal = new String();
		for(int i=0;i<guiResponseType.getMessages().getMessage().size();i++){
			shortText.add(guiResponseType.getMessages().getMessage().get(i).getShortText());
			messageID.add(guiResponseType.getMessages().getMessage().get(i).getMessageId());
			if(guiResponseType.getMessages().getMessage().get(i).getMessageText()!=null)
			messageText.add(guiResponseType.getMessages().getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ; 
			title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";	
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));	
	}        
}
