/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.VPATSortDialog;
import com.ca.fmp.ims.model.generated.DataSetInfoType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.view.wizards.DSNLabelProvider;
import com.ca.fmp.ims.view.wizards.FileTypeLabelProvider;
import com.ca.fmp.ims.view.wizards.FilesDatasetWizardPageSorter;
import com.ca.fmp.ims.view.wizards.VolumeLabelProvider;
import com.ca.testingtools.ui.TextUtil;

public class DatasetWizardPage extends WizardPage {
    
	private static TableViewer tableViewer;
	private static final int DATASET  = 0;
	private static final int VOLUME = 1;
	private static final int FILETYPE = 2;
	public static final int dsorgStr = 3;
	public static final int lrecl = 4;
	public static final int blkSize = 5;
	public static final int recfm = 6;
	public static final int tracks = 7;
	public static final int extents = 8;
	public static final int dateCreated = 9;
	public static final int dateReferenced = 10;
	private Listener sortListener;
	private Listener sortListenerVPAT;  //grake02 26/OCT/2016 	
	private final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.datasetWildCardWizard"; 
	private ArrayList<FileMasterDataset> fmdsList;
	public static Button dsnValue;
	private Text numberOfDS;
	 private GUIResponseType response;

	public DatasetWizardPage(GUIResponseType response, FileMasterServer server) {
		super("new data set");
		setTitle("Select Data Set");
		this.response = response;
	}

	@Override
	public void createControl(Composite parent) {

		Composite container = new Composite(parent, SWT.NONE);
		GridLayout container_layout = new GridLayout(1, false);
		container.setLayout(container_layout);	
		Composite select_dataset_composite = new Composite(container, SWT.NULL);
		select_dataset_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		select_dataset_composite.setLayout(new GridLayout(1, false));
		createViewer(select_dataset_composite);
		numberOfDS = new Text(select_dataset_composite, SWT.READ_ONLY);
		numberOfDS.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		TextUtil.setWidth(numberOfDS, 14);
		numberOfDS.setEnabled(false);
		doSelect();

		setControl(container);

		getShell().getDefaultButton().setText("OK");
		dsnValue = new Button(parent, SWT.NONE);
		dsnValue.setEnabled(false);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);

		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}


	private void createViewer(Composite parent) {
		tableViewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);

		tableViewer.getTable().setLinesVisible(true);
		tableViewer.getTable().setHeaderVisible(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_table.heightHint = 300;
		//gd_table.widthHint = 500;
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				setPageComplete(isPageComplete());

			}
		});
		tableViewer.getTable().setLayoutData(gd_table);
		setupColumnListener();
		createColumns(parent, tableViewer);
		
        //grake02 24/OCT/2016 - invoke sort dialog so that application is 508 compliant
		setupVPATColumnSorter();


		tableViewer.setContentProvider(new ArrayContentProvider());	


	}

	private void setupColumnListener() {
		sortListener = new Listener(){


			public void handleEvent(final Event event) {
				final TableColumn column =  (TableColumn)event.widget;
				final Table table = tableViewer.getTable();
				if (column.equals(table.getSortColumn())){
					final int direction = table.getSortDirection();
					switch (direction){
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					table.setSortDirection(SWT.UP);
				}
				tableViewer.refresh();
			}
		};

	}

	private void createColumns(Composite parent, TableViewer viewer2) {
		String[] titles = { "Data Set Name", "Volume", "File Type"};
		int[] bounds = { 300, 100, 100 };
		Table table = tableViewer.getTable();
		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableColumn = new TableViewerColumn(tableViewer,
					bounds[i]);
			switch (i) {
			case DATASET:
				tableColumn.setLabelProvider(new DSNLabelProvider());		
				break;
			case VOLUME:
				tableColumn.setLabelProvider(new VolumeLabelProvider());
				break;
			case FILETYPE:
				tableColumn.setLabelProvider(new FileTypeLabelProvider());
				break;
				/*case dsorgStr:
				tableColumn.setLabelProvider(new DSOrgLabelProvider());
				break;
			case lrecl:
				tableColumn.setLabelProvider(new LRECLLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case blkSize:
				tableColumn.setLabelProvider(new BLKSizeLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case recfm:
				tableColumn.setLabelProvider(new RECFMLabelProvider());
				break;
			case tracks:
				tableColumn.setLabelProvider(new TracksLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case extents:
				tableColumn.setLabelProvider(new ExtentsLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case dateCreated:
				tableColumn.setLabelProvider(new DateCreatedLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
			case dateReferenced:
				tableColumn.setLabelProvider(new DateReferencedLabelProvider());
				tableColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
				 */}
			tableColumn.getColumn().setText(titles[i]);
			tableColumn.getColumn().setWidth(bounds[i]);
			tableColumn.getColumn().addListener(SWT.Selection, sortListener);
		}

		tableViewer.setSorter(new FilesDatasetWizardPageSorter());
		table.setSortColumn(table.getColumn(0));
		table.setSortDirection(SWT.UP);

	}
	public TableViewer getViewer() {
		return tableViewer;
	}
	
	@Override
	public boolean isPageComplete () {
		if(tableViewer.getTable().getSelectionCount()==1) {
			return true;			
		} else {
			return false;			
		}
	}
	
	private void doSelect() {
		fmdsList = new ArrayList<FileMasterDataset>();
		tableViewer.getTable().removeAll();
		// Parse the xml and populate the table with the dataset entries
		if (response != null) {
			if(response.getWildCardDataSetResponse().getDataSetInfoList()==null)
				return;
			int numOfDSNReturned = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo().size();
			List<DataSetInfoType> dsnList = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo();
			for (int i = 0; i < numOfDSNReturned; i++) {

				FileMasterDataset dataset = new FileMasterDataset(null);
				dataset.setName(dsnList.get(i).getDsname());
				dataset.setFileType(dsnList.get(i).getFileType() == null?"":dsnList.get(i).getFileType().value());
				dataset.setVolume(dsnList.get(i).getVolumeSerial() == null?"":dsnList.get(i).getVolumeSerial());
				fmdsList.add(dataset);
			}


			tableViewer.setInput(fmdsList.toArray(new FileMasterDataset[fmdsList.size()]));
			// after opening the dialog,
			// the first row is selected immediately
			tableViewer.getTable().setFocus();
			tableViewer.getTable().setSelection(0);
			tableViewer.refresh();
            
			if(numOfDSNReturned==1){
				numberOfDS.setText(numOfDSNReturned+" data set returned.");
			}
			else{
				numberOfDS.setText(numOfDSNReturned+" data sets returned.");
			}
			numberOfDS.setEnabled(true);
		}

		//session
	}

	public boolean doFinish() {
		dsnValue.notifyListeners(SWT.Selection, new Event());
		return true;
	}
	
	public static FileMasterDataset getSelectedDSN(){
		//return tableViewer.getSelection().toString().substring(1, tableViewer.getSelection().toString().length()-1);
		return (FileMasterDataset)tableViewer.getElementAt(tableViewer.getTable().getSelectionIndex());
	}
	
	//grake02 26/OCT/2016 - create filter filter for 508 compliant problem.
	private void setupVPATColumnSorter()
	{
        //grake02 26/OCT/2016 - invoke sort dialog so that application is 508 compliant
		sortListenerVPAT = new Listener() 
        {
        	public void handleEvent(Event event) 
        	{
	            if (event.keyCode == SWT.F12)
	            {
	            	VPATSortDialog VPATdialog = new VPATSortDialog(getShell(), tableViewer);
	            	VPATdialog.create();
	            	if (VPATdialog.open() == Window.OK)
	            	{
	            		tableViewer.refresh();
	            	}
	            }
	        }
	    };
	    
	    getShell().getDisplay().addFilter(SWT.KeyDown, sortListenerVPAT);      				
	}
	
	public void dispose()
	{
		getShell().getDisplay().removeFilter(SWT.KeyDown, sortListenerVPAT);  //grake02 26/OCT/2016
		super.dispose();
	}	
}
