/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;      

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

import com.ca.fmp.ims.common.Constants;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.LocateRequest;
import com.ca.fmp.ims.model.ShowCKeyRequest;
import com.ca.fmp.ims.model.generated.CKeyEntryType;
import com.ca.fmp.ims.model.generated.CKeyFieldType;
import com.ca.fmp.ims.model.generated.CKeyType;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.RangeListType;
import com.ca.fmp.ims.model.generated.RangeType;
import com.ca.fmp.ims.model.generated.SegmentType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.ckey.ConcatenatedKeyValueLabelProvider;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.fmp.ims.view.handlers.FileMasterPlusKeyListener;
import com.ca.fmp.ims.view.handlers.LocateKeyKeyListener;
import com.ca.fmp.ims.view.handlers.TraverseListenerTable;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;

public class LocateKeyCommandWizardPage extends WizardPage implements SelectionListener{
	
	private static final String TITLE = "Locate Key";
	private static String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.LocateKey";
	
	private static final String HEX_BUTTON_ID = "com.ca.fmp.ims.view.commands.ckey.hex";
	private static final String CHAR_BUTTON_ID = "com.ca.fmp.ims.view.commands.ckey.charFormat";
	private static final String SF_BUTTON_ID = "com.ca.fmp.ims.view.commands.ckey.sfFormat";
	
	private Composite container;
	
	private TableViewer viewer;
	private TableViewer initWidthTable;	
	
	private YorNType ckeyHex = YorNType.N;
	private DisplayModeType ckeyDisplay = DisplayModeType.C;
	
	Label subTitleLabel;
	private MenuManager popupMenuMgr;	
	
	private Action hexAction;
	private Action sfFormatAction;
	private Action charFormatAction;
	
	private ToolItem singleFormatItem;
	private ToolItem charFormatItem;
	private ToolItem hexOnOffItem;
	
	private SegmentType currentSegment;
	private int segmentLevel;
	
	private boolean overTypeError = false;
	private boolean overtyped = false;
	
	protected FileMasterPlusKeyListener fileMasterPlusKeyListener;
	protected LocateKeyKeyListener locateKeyKeyListener;
	
	private EditorView editorView;
	
	private int xPosMouse = -1;
	private int dataColumnBegin;
	
	protected Slider slider;
	
	public LocateKeyCommandWizardPage() {
		super(TITLE);
		setTitle("Change Key Values");
	}

	@Override
	public void createControl(Composite parent) {
		
		//Get current segment and create copy
		editorView = getEditorView();
		currentSegment =  copySegmentType(getEditorView().getCurrentSegment().segmentType);
		segmentLevel = getEditorView().getCurrentSegment().getSegLevel();
		setCurrentSegment(currentSegment);
		
		container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, false));	
		PlatformUI.getWorkbench().getHelpSystem()
		.setHelp(parent, CONTEXT_HELP_ID);
		
		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		ImageDescriptor charImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-character-16.png"), null));
		ImageDescriptor singleImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-single-16.png"), null));
		ImageDescriptor hexImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/hex-mode-16.png"), null));
		
		//Create Pop-up menu in table 
		hexAction = new Action("Hexadecimal") {
			@Override
			public void run() {				
				if(ckeyHex == YorNType.Y){
					viewer.getTable().forceFocus();
					if (!overTypeError){
						ckeyHex = YorNType.N;
						if(ckeyDisplay == DisplayModeType.C){
							viewer.getTable().dispose();
							createCharTable(container);
						}
						if (overtyped) {
							updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
						} else {
							updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
						}					
						hexAction.setChecked(false);
						hexOnOffItem.setSelection(false);
					} else {
						hexAction.setChecked(true);
						hexOnOffItem.setSelection(true);	
						}
				} else {
					viewer.getTable().forceFocus();
					if (!overTypeError){
						ckeyHex = YorNType.Y;
						if(ckeyDisplay == DisplayModeType.C){
							viewer.getTable().dispose();
							createCharTable(container);
						}
						if (overtyped) {
							updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
						} else {
							updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
						}	
						hexAction.setChecked(true);
						hexOnOffItem.setSelection(true);
					} else {
						hexAction.setChecked(true);
						hexOnOffItem.setSelection(true);	
						}					
					}				
				}
		};	
		hexAction.setId(HEX_BUTTON_ID);
		hexAction.setActionDefinitionId(HEX_BUTTON_ID);
		hexAction.setImageDescriptor(hexImage);
		hexAction.setToolTipText("Hexadecimal");

		charFormatAction = new Action("Character Format") {
			@Override
			public void run() {			
				viewer.getTable().forceFocus();
				if (!overTypeError){
					viewer.getTable().dispose();
					ckeyDisplay = DisplayModeType.C;
					createCharTable(container);
					if (overtyped) {
						updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
					} else {
						updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
					}
				} else {
					updateControlsState();
				}
			}
		};
		charFormatAction.setImageDescriptor(charImage);
		charFormatAction.setId(CHAR_BUTTON_ID);
		charFormatAction.setActionDefinitionId(CHAR_BUTTON_ID);
		
		sfFormatAction = new Action("Single Record Format") {
			@Override
			public void run() {				
				viewer.getTable().forceFocus();
				if (!overTypeError){
					viewer.getTable().dispose();
					ckeyDisplay = DisplayModeType.S;
					createSFTable(container);
					if (overtyped) {
						updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
					} else {
						updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
					}
				} else {
					updateControlsState();
				}
			} 
		};
		sfFormatAction.setImageDescriptor(singleImage);
		sfFormatAction.setId(SF_BUTTON_ID);
		sfFormatAction.setActionDefinitionId(SF_BUTTON_ID);

		popupMenuMgr = new MenuManager("#PopupMenu");
		popupMenuMgr.setRemoveAllWhenShown(true);
		popupMenuMgr.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager m) {
				popupMenuMgr.add(charFormatAction);
				popupMenuMgr.add(sfFormatAction);	
				popupMenuMgr.add(hexAction);
			}					
	    });
		
		// Create tool bar items 
		createToolbar(container);
		
		//Get current mode of Editor View, used to setup mode in this dialog
		ckeyDisplay = editorView.getDisplayMode();
		ckeyHex = editorView.getHexToggled();
		
		//Set dialog size 
		initDialogWidth(container);
		initWidthTable.getTable().dispose();
		setControl(container);
		
		if(ckeyDisplay == DisplayModeType.C){
			createCharTable(container);
		} else if(ckeyDisplay == DisplayModeType.S){
			createSFTable(container);
		}
		
		if(ckeyHex == YorNType.Y){
			hexAction.setChecked(true);
			hexOnOffItem.setSelection(true);
		} else {
			hexAction.setChecked(false);
			hexOnOffItem.setSelection(false);
		}

		// Update table with current segment CK
		updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
		
		//Add OK button
		getShell().getDefaultButton().setText("OK");

	}
	
	private void createCharTable(Composite parent){
		viewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);
		
		final Table table = viewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		Shell shell = new Shell();
		table.setFont(JFaceResources.getTextFont());

		final TextLayout segmentLayout = new TextLayout(shell.getDisplay());
		TableViewerColumn colSegment = new TableViewerColumn(viewer, SWT.NONE);
		colSegment.getColumn().setText("Segment  ");
		colSegment.getColumn().setResizable(true);
		colSegment.getColumn().pack();
		colSegment.setLabelProvider(new StyledCellLabelProvider(){
			@Override
			protected void paint(Event event, Object element) {
				segmentLayout.setFont(JFaceResources.getTextFont());
				segmentLayout.setText(((TableItem)event.item).getText(0));
				segmentLayout.draw(event.gc, event.x, event.y);
			}
		});
		
		TextLayout keyValueLayout = new TextLayout(shell.getDisplay());
		TableViewerColumn colKeyValue = new TableViewerColumn(viewer, SWT.NONE);
		colKeyValue.getColumn().setText("Key Value");
		colKeyValue.getColumn().setResizable(true);
		colKeyValue.getColumn().pack();
		colKeyValue.setLabelProvider(new ConcatenatedKeyValueLabelProvider(keyValueLayout, shell));	

		//Enable to over-type current segment key 
		colKeyValue.setEditingSupport(new EditingSupport(colKeyValue.getViewer()) {
				
			@Override
			protected void setValue(Object element, Object value) {		
			}
			
			@Override
			protected Object getValue(Object element) {
				CKeyEntryType cKeyEntry = null;
		        
		        if(element instanceof CKeyEntryType) {
		        	cKeyEntry = (CKeyEntryType) element;		        	
		        	String charData = cKeyEntry.getCKeyField().get(0).getCharData();
		        	String hexData1 = cKeyEntry.getCKeyField().get(0).getHexData1();
		        	String hexData2 = cKeyEntry.getCKeyField().get(0).getHexData2();
		        	
			        if(hexData1 == null) {
			          	return charData;
			        } else {	
						return (charData + Constants.LINE_SEPARATOR + hexData1 + Constants.LINE_SEPARATOR + hexData2);
			        } 			           
		        } else {
		        	return null;
		        }			
			}
			
			@Override
			protected CellEditor getCellEditor(final Object element) {	
				final TextCellEditor textEditor = new TextCellEditor(viewer.getTable(),SWT.MULTI);
				final Text text = (Text) textEditor.getControl();		
				
				text.setFont(viewer.getTable().getFont());
				
				Menu cellMenu = popupMenuMgr.createContextMenu(text);
				text.setMenu(cellMenu);
				
				if(element instanceof CKeyEntryType) {
					CKeyEntryType cKeyEntry = (CKeyEntryType) element;
					if (cKeyEntry.getCKeyField().get(0).getHexData1() != null){
						((Text) textEditor.getControl()).setTextLimit(cKeyEntry.getCKeyField().get(0).getCharData().length() + Constants.LINE_SEPARATOR.length()
						+ cKeyEntry.getCKeyField().get(0).getHexData1().length() + Constants.LINE_SEPARATOR.length()
						+ cKeyEntry.getCKeyField().get(0).getHexData2().length());
					}
					else {
					((Text) textEditor.getControl()).setTextLimit(cKeyEntry.getCKeyField().get(0).getCharData().length());
					}
				}	
				
				((Text) textEditor.getControl()).addFocusListener(new FocusListener(){
					@Override
					public void focusLost(FocusEvent e) {
						// TODO Auto-generated method stub
						CKeyType ckey = currentSegment.getCKey();
						
						if(locateKeyKeyListener==null | !locateKeyKeyListener.getDirty()){
							return;
						}	

						if(element instanceof CKeyEntryType) {
							CKeyEntryType cKeyEntry = (CKeyEntryType) element;
							
							overtyped = true;
							//Get current text value 
							String[] valueLine = text.getText().toString().split(Constants.LINE_SEPARATOR);
							
							if(ckeyHex == YorNType.N){									
								for(CKeyEntryType cKeyEntryOrg : ckey.getCKeyEntry()){			
									if (cKeyEntryOrg.getSegname().equals(cKeyEntry.getSegname())){
										cKeyEntryOrg.getCKeyField().get(0).setCharData(valueLine[0]);
										break;
									}
								}
												
								if (!overTypeError){
									CKeyType responseCKey = sendRequestforShowCKey(ckey,getCurrentSegment().getSegid());				
									if (responseCKey != null){
										updateCKey(responseCKey.getCKeyEntry());
										currentSegment.setCKey(responseCKey);
									}
								} else {
									updateCKey(ckey.getCKeyEntry());
									currentSegment.setCKey(ckey);
								}
								locateKeyKeyListener.setDirty(false);
							} else {
								for(CKeyEntryType cKeyEntryOrg : ckey.getCKeyEntry()){			
									if (cKeyEntryOrg.getSegname().equals(cKeyEntry.getSegname())){
										cKeyEntryOrg.getCKeyField().get(0).setCharData(valueLine[0]);
										cKeyEntryOrg.getCKeyField().get(0).setHexData1(valueLine[1]);
										cKeyEntryOrg.getCKeyField().get(0).setHexData2(valueLine[2]);
										break;
									}
								}

								TextValidator(ckey);
								if (!overTypeError){
									CKeyType responseCKey = sendRequestforShowCKey(ckey,getCurrentSegment().getSegid());				
									if (responseCKey != null){
										updateCKey(responseCKey.getCKeyEntry());
										currentSegment.setCKey(responseCKey);
									}		
								} else {
									updateCKey(ckey.getCKeyEntry());	
									currentSegment.setCKey(ckey);
								}	
								locateKeyKeyListener.setDirty(false);
							}
						}
					}
					
					@Override
					public void focusGained(FocusEvent e) {
						// TODO Auto-generated method stub	
					}
					
				});

				// Add Traverse listener 
				TraverseListenerTable traverseListenerTable = new TraverseListenerTable(textEditor, viewer, null);
				Listener[] traverseListener = text.getListeners(SWT.Traverse);
				if(traverseListener.length == 1) {
					 text.addTraverseListener(traverseListenerTable);
				}
					
				// Add listener to process keys 
				if (locateKeyKeyListener == null){
					locateKeyKeyListener = new LocateKeyKeyListener(textEditor);
				}
				Listener[] keyListener = text.getListeners(SWT.KeyDown);
				if(keyListener.length == 1) {
					text.addKeyListener(locateKeyKeyListener);
				}		
				CKeyEntryType cKeyEntry = (CKeyEntryType) element;
				locateKeyKeyListener.setMaxLengthP(cKeyEntry.getCKeyField().get(0).getCharData().length());
				locateKeyKeyListener.setProtectedValues(getProtectedValues(cKeyEntry.getCKeyField().get(0).getProtectedList()));
				
				// Add mouse listener and selection listener to set caret. We don't want full selection after mouse click 
				viewer.getTable().addMouseListener(new MouseListener() {				
					@Override
					public void mouseUp(MouseEvent e) {
						// TODO Auto-generated method stub				
					}				
					@Override
					public void mouseDown(MouseEvent e) {
						// TODO Auto-generated method stub
						dataColumnBegin = viewer.getTable().getColumn(0).getWidth();
						xPosMouse = e.x;
					}				
					@Override
					public void mouseDoubleClick(MouseEvent e) {
						// TODO Auto-generated method stub				
					}
				});
			
				viewer.getTable().addSelectionListener(new SelectionListener() {			
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						int caretPos = (int) Math.floor((xPosMouse - dataColumnBegin + table.getHorizontalBar().getSelection())/Constants.getPixelSizeOfCharacter());
						text.setSelection(caretPos);
					}				
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
					}
					});
				
				return textEditor;
			}
			
			@Override
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
		});
		
		Menu charPopupMenu = popupMenuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(charPopupMenu);
		
		parent.layout();
		
		updateControlsState();
		}
	
	private void createSFTable(Composite parent){
		viewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);

		final Table table = viewer.getTable();
		final Font font = JFaceResources.getTextFont();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setFont(JFaceResources.getTextFont());
		viewer.getTable().setFont(JFaceResources.getTextFont());
		TableViewerColumn tableColumnKayValue = null;
		
		String[] columnNames = new String[] { "Segment", "Field Name", "Position", "Format", "Key Value" };
		int[] columnAlignments = new int[] { SWT.LEFT, SWT.LEFT, SWT.RIGHT, SWT.CENTER, SWT.LEFT | SWT.NONE };

		for (int i = 0; i < columnNames.length; i++) {
			TableViewerColumn tableViewerColumn = new TableViewerColumn(viewer, columnAlignments[i]);
			TableColumn tableColumn = tableViewerColumn.getColumn();

			tableColumn.setText(columnNames[i]);
			tableColumn.pack();
			
			
			if(i == 4){
				final Shell shell = new Shell();
				final TextLayout ckeyValueLayout = new TextLayout(shell.getDisplay());	
				tableColumnKayValue = tableViewerColumn;
				
				tableViewerColumn.setLabelProvider(new StyledCellLabelProvider(){
					@Override
					protected void paint(Event event, Object element) {
						String keyValue = ((TableItem)event.item).getText(4);
						ckeyValueLayout.setFont(font);
						ckeyValueLayout.setText(keyValue);
						
						if(ckeyHex == YorNType.N
								&& ((TableItem)event.item).getData() instanceof CKeyFieldType
								&& (((CKeyFieldType)((TableItem)event.item).getData()).getLength() * 2) + 3 == keyValue.length()){

							TextStyle colorData = new TextStyle(font, shell.getDisplay().getSystemColor(SWT.COLOR_RED), null);
							ckeyValueLayout.setStyle(colorData, 0, keyValue.length() - 1);
						}
						
						ckeyValueLayout.draw(event.gc, event.x + 2, event.y + 2);
					}
				});
			}
		}


		//Enable to over-type current segment key
		tableColumnKayValue.setEditingSupport(new EditingSupport(tableColumnKayValue.getViewer()) {
			@Override
			protected void setValue(Object element, Object value) {		
			}
			
			@Override
			protected Object getValue(Object element) {
				CKeyFieldType cKeyField  = null;
				 
		        if(element instanceof CKeyFieldType) {
		        	cKeyField = (CKeyFieldType) element;	        	
		        	return cKeyField.getCharData();
		        } else {
		        	return null;
		        }			
			}
			
			@Override
			protected CellEditor getCellEditor(final Object element) {	
				final TextCellEditor textEditor = new TextCellEditor(viewer.getTable(), SWT.SINGLE);			
				final Text text = (Text) textEditor.getControl();
				
				text.setFont(viewer.getTable().getFont());
				
				Menu cellMenu = popupMenuMgr.createContextMenu(text);
				text.setMenu(cellMenu);
				
				if(element instanceof CKeyFieldType) {					
					CKeyFieldType cKeyField = (CKeyFieldType) element;
					if (cKeyField.getCharData() == null){
						return null;
					}
					((Text) textEditor.getControl()).setTextLimit(cKeyField.getCharData().length());
				} else {
					return null;
				}
				
				((Text) textEditor.getControl()).addFocusListener(new FocusListener(){
					@Override
					public void focusLost(FocusEvent e) {
						// TODO Auto-generated method stub
						CKeyType ckey = currentSegment.getCKey();
						
						if(locateKeyKeyListener==null | !locateKeyKeyListener.getDirty()){
							return;
						}					
						
						if(element instanceof CKeyFieldType) {
							CKeyFieldType CKeyField = (CKeyFieldType) element;
							overtyped = true;				
							
							for (int i = 0; i< ckey.getCKeyEntry().size(); i++){
								for (int j = 0; j< ckey.getCKeyEntry().get(i).getCKeyField().size(); j++){
									if (CKeyField.getId() == ckey.getCKeyEntry().get(i).getCKeyField().get(j).getId()){
										ckey.getCKeyEntry().get(i).getCKeyField().get(j).setCharData(text.getText());
										break;
									}
								}
							}
							
							TextValidator(ckey);
							if (!overTypeError){
								CKeyType responseCKey = sendRequestforShowCKey(ckey,getCurrentSegment().getSegid());				
								if (responseCKey != null){
									updateCKey(responseCKey.getCKeyEntry());
									currentSegment.setCKey(responseCKey);
								}
							} else {
								updateCKey(ckey.getCKeyEntry());	
								currentSegment.setCKey(ckey);
							}
							locateKeyKeyListener.setDirty(false);
						}	
					}
					
					@Override
					public void focusGained(FocusEvent e) {
						// TODO Auto-generated method stub						
					}
					
				});

				CKeyFieldType cKeyField = (CKeyFieldType) element;

				TraverseListenerTable traverseListenerTable = new TraverseListenerTable(textEditor, viewer, null);
				Listener[] traverseListener = text.getListeners(SWT.Traverse);
				if(traverseListener.length == 1) {
					 text.addTraverseListener(traverseListenerTable);
				}
				
				if (locateKeyKeyListener == null){
					locateKeyKeyListener = new LocateKeyKeyListener(textEditor);
					}
				
				Listener[] keyListener = text.getListeners(SWT.KeyDown);
				if(keyListener.length == 1) {
					text.addKeyListener(locateKeyKeyListener);
				}
				RangeListType rangeListType = null;
				locateKeyKeyListener.setMaxLengthP(cKeyField.getCharData().length());
				locateKeyKeyListener.setProtectedValues(getProtectedValues(rangeListType));
				
				// Add mouse listener and selection listener to set caret. We don't want full selection after mouse click 
				viewer.getTable().addMouseListener(new MouseListener() {				
					@Override
					public void mouseUp(MouseEvent e) {
						// TODO Auto-generated method stub				
					}				
					@Override
					public void mouseDown(MouseEvent e) {
						// TODO Auto-generated method stub
						dataColumnBegin = viewer.getTable().getColumn(0).getWidth() + viewer.getTable().getColumn(1).getWidth() + 
								viewer.getTable().getColumn(2).getWidth() + viewer.getTable().getColumn(3).getWidth();
						xPosMouse = e.x;
					}				
					@Override
					public void mouseDoubleClick(MouseEvent e) {
						// TODO Auto-generated method stub				
					}
				});
			
				viewer.getTable().addSelectionListener(new SelectionListener() {			
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						int caretPos = (int) Math.floor((xPosMouse - dataColumnBegin + table.getHorizontalBar().getSelection())/Constants.getPixelSizeOfCharacter());
						text.setSelection(caretPos);
					}				
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
					}
					});
				
				return textEditor;
			}
			
			@Override
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
		});
		Menu charPopupMenu = popupMenuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(charPopupMenu);
		
		parent.layout();	
		updateControlsState();
	}
	
	private void initDialogWidth(Composite parent){
		// Invisible table to adjust width of the Locate dialog				
		initWidthTable = new TableViewer(parent, SWT.BORDER);	
		initWidthTable.getTable().setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1));

		TableViewerColumn tableColumn = new TableViewerColumn(initWidthTable, SWT.NONE);
		tableColumn.getColumn().setWidth(Constants.getPixelSizeOfCharacter()*60);
		initWidthTable.getTable().setHeaderVisible(false);
		int multiple_lines = 1;
		int constant = 3;
		if (ckeyHex == YorNType.Y | ckeyDisplay == DisplayModeType.S){
			multiple_lines = 2;
			constant = 0;
		}
		initWidthTable.getTable().setItemCount(multiple_lines*(segmentLevel) + constant);
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);				
	}	
	
	public void updateCKey(List<CKeyEntryType> cKeyList){
		viewer.getTable().removeAll();
		viewer.getTable().setRedraw(false);
		int max_size = 0;
		
		if(ckeyDisplay == DisplayModeType.C){
			if(cKeyList != null){
				TableItem item;
				String charData;

				if(ckeyHex == YorNType.N){
					for(CKeyEntryType cKeyEntry : cKeyList){
						item = new TableItem (viewer.getTable(), SWT.NONE);

						item.setText(0, cKeyEntry.getSegname());

						charData = "";
						for(CKeyFieldType cKeyField : cKeyEntry.getCKeyField()){
							charData = charData.concat(cKeyField.getCharData());
						}
						item.setText(1, charData);
						item.setData(cKeyEntry);
					}
				} else {
					String hexData1, hexData2;
					max_size = viewer.getTable().getColumns()[1].getText().length();
					for(CKeyEntryType cKeyEntry : cKeyList){
						item = new TableItem (viewer.getTable(), SWT.NONE);

						item.setText(0, cKeyEntry.getSegname());

						charData = "";
						hexData1 = "";
						hexData2 = "";
						for(CKeyFieldType cKeyField : cKeyEntry.getCKeyField()){
							charData = charData.concat(cKeyField.getCharData());
							hexData1 = hexData1.concat(cKeyField.getHexData1());
							hexData2 = hexData2.concat(cKeyField.getHexData2());
							if (max_size <= cKeyField.getCharData().length()) { 
								max_size = cKeyField.getCharData().length();
							}
						}
						item.setText(1, charData + Constants.LINE_SEPARATOR + hexData1 + Constants.LINE_SEPARATOR + hexData2);
						item.setData(cKeyEntry);
					}
				}
			}
			
			if (max_size != 0) {
				viewer.getTable().getColumn(1).setWidth((max_size+1+1)*Constants.getPixelSizeOfCharacter());
			} else {
			 viewer.getTable().getColumn(1).pack();
			}
		}
		else if(ckeyDisplay == DisplayModeType.S){
			if(cKeyList != null){
				TableItem item;

				for(CKeyEntryType cKeyEntry : cKeyList){
					String segmentName = cKeyEntry.getSegname();
					
					int count = cKeyEntry.getCKeyField().size();
					
					//Field Name
					TreeSet<String> fieldLevelSet = new TreeSet<String>();
					String fieldLevelRepresentedAstwoDigitString;
					for (int i = 0; i < count; i++){	
						fieldLevelRepresentedAstwoDigitString = (cKeyEntry.getCKeyField().get(i).getLevel() < 10 ? "0" : "")
								+ String.valueOf(cKeyEntry.getCKeyField().get(i).getLevel()); 
						fieldLevelSet.add(fieldLevelRepresentedAstwoDigitString);
					}
					ArrayList<String> fieldLevels = new ArrayList<String>(fieldLevelSet);
					ArrayList<String> indentedFieldNames = new ArrayList<String>();
					for (int i = 0; i < count; i++){	
						fieldLevelRepresentedAstwoDigitString = (cKeyEntry.getCKeyField().get(i).getLevel() < 10 ? "0" : "")
								+ String.valueOf(cKeyEntry.getCKeyField().get(i).getLevel());			
						int indentation = fieldLevels.indexOf(fieldLevelRepresentedAstwoDigitString);
						char[] array = new char[indentation * 2];
						Arrays.fill(array, ' ');
						indentedFieldNames.add(new String(array)
							+ fieldLevelRepresentedAstwoDigitString + " "
							+ String.valueOf(cKeyEntry.getCKeyField().get(i).getName()));
					}
					
					//Format 
					ArrayList<String> formatStrings = new ArrayList<String>();
					for (int i = 0; i < count; i++){
						CKeyFieldType cKeyField = cKeyEntry.getCKeyField().get(i);
						String fieldFormatForDisplay = cKeyField.getFormatChar();
						if (fieldFormatForDisplay == null) {
							fieldFormatForDisplay = "";
						}
						
						// floating point type, response form the mainframe is 1 or 2
						if (fieldFormatForDisplay == "1" || fieldFormatForDisplay == "2") {
							fieldFormatForDisplay = "FP";
						}
						
						// unsigned or signed format type; if signed add 'S' to format 
						if (cKeyField.getSigned() == YorNType.Y) {
							fieldFormatForDisplay += "S";
						}
						
						// length of some format types can consist of two parts, integer and fraction
						String fieldFormatMaxLengthDisplay = "";

						if (cKeyField.getIntegerLength() == null) {
							fieldFormatMaxLengthDisplay = cKeyField.getLength().toString();
						} else {
							fieldFormatMaxLengthDisplay = cKeyField.getIntegerLength().toString();
							if (cKeyField.getFractionLength() != null) {
								fieldFormatMaxLengthDisplay += "." + cKeyField.getFractionLength().toString();
							}
						}
						
						// Format column consists at last 7 characters 
						int charFormatLength = fieldFormatForDisplay.length() + fieldFormatMaxLengthDisplay.length();			
						if (charFormatLength <= 7) {
							char[] array = new char[7 - charFormatLength];
							Arrays.fill(array, ' ');
							formatStrings.add(fieldFormatForDisplay + new String(array) + fieldFormatMaxLengthDisplay);
						} else {
							formatStrings.add(fieldFormatForDisplay + " " + fieldFormatMaxLengthDisplay);
						}
					}
					
					for(int i = 0; i < cKeyEntry.getCKeyField().size(); i++){
						CKeyFieldType cKeyField = cKeyEntry.getCKeyField().get(i);
						item = new TableItem (viewer.getTable(), SWT.NONE);

						if(i == 0){
							item.setText(0, segmentName);
						} else {
							item.setText(0, "");
						}
						
						item.setText(1, indentedFieldNames.get(i));
						item.setText(2, String.valueOf(cKeyField.getPosition()));
						item.setText(3, formatStrings.get(i));
						item.setText(4, (cKeyField.getCharData() == null) ? "" : cKeyField.getCharData());
						item.setData(cKeyField);
					}
				}
			}

			viewer.getTable().getColumn(0).pack();
			viewer.getTable().getColumn(1).pack();
			viewer.getTable().getColumn(2).pack();
			viewer.getTable().getColumn(3).pack();
			viewer.getTable().getColumn(4).pack();
		}
		
		viewer.getTable().setRedraw(true);
	}

	/**
	 * This can return null so need to catch for null.
	 * 
	 * @return
	 */
	private EditorView getEditorView() {
		IWorkbenchPart workbenchPart = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActivePart();
		EditorView editorView;
		if (!(workbenchPart instanceof EditorView)) {
			editorView = null;
		} else {
			editorView = (EditorView) workbenchPart;
		}

		return editorView;
	}
	
	private void updateControlsState(){
		if(ckeyDisplay == DisplayModeType.C){
			charFormatAction.setEnabled(false);
			sfFormatAction.setEnabled(true);
			singleFormatItem.setEnabled(true);
			singleFormatItem.setSelection(false);
			charFormatItem.setEnabled(false);	
			charFormatItem.setSelection(true);
			
		} else if(ckeyDisplay == DisplayModeType.S){
			charFormatAction.setEnabled(true);
			sfFormatAction.setEnabled(false);
			singleFormatItem.setEnabled(false);
			singleFormatItem.setSelection(true);
			charFormatItem.setEnabled(true);
			charFormatItem.setSelection(false);
		}
	}
	
	private void setCurrentSegment(SegmentType currentSegment){
		this.currentSegment = currentSegment;
	}
	
	private SegmentType getCurrentSegment(){
		return currentSegment;
	}
	
	private CKeyType sendRequestforShowCKey(CKeyType cKey, String segId) {
		
		CKeyType cKeyReq = new CKeyType();
		if  (cKey != null){
			cKeyReq.setDisplayMode(cKey.getDisplayMode());		
			int i = 0;
				for(CKeyEntryType cKeyEntry : cKey.getCKeyEntry()){			
					CKeyEntryType cKeyEntryReq = new CKeyEntryType();
					
					for (CKeyFieldType cKeyField : cKeyEntry.getCKeyField()) {
						CKeyFieldType cKeyFieldReq = new CKeyFieldType();
						cKeyFieldReq.setId(cKeyField.getId());
						cKeyFieldReq.setCharData(cKeyField.getCharData());
						cKeyFieldReq.setHexData1(cKeyField.getHexData1());
						cKeyFieldReq.setHexData2(cKeyField.getHexData2());
						if (!(cKeyField.getCharData() == null & cKeyField.getFormatChar() == null & cKeyReq.getDisplayMode() == DisplayModeType.S)){
							cKeyEntryReq.getCKeyField().add(cKeyFieldReq);
						}
					}
					cKeyReq.getCKeyEntry().add(cKeyEntryReq);
					cKeyReq.getCKeyEntry().get(i).setSegname(cKeyEntry.getSegname());
					i ++;
			}
		} else {
			cKeyReq = null;
		}	
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new ShowCKeyRequest(
					editorView.getServer(),((IViewSite) editorView.getSite()).getSecondaryId(),
					cKeyReq, segId, ckeyDisplay, ckeyHex).createXml());
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(
				editorView.getServer(), map, "opendb", true, xmlDocument);

		do {
		} while (req.getResult() != Status.OK_STATUS);

		GUIResponseType response = req.getGuiResponseType();

		if (response.getReturnCode() !=0){
			if (response.getMessages() != null)
			setErrorMessage(response.getMessages().getMessage().get(0).getMessageText().toString());
		}else {
			currentSegment.setCKey(response.getEditResponse().getCKey());
		}
		
		return response.getEditResponse().getCKey();
	}
	
	private void sendRequestforLocateAndUpdateEditorView(CKeyType cKey) {
		
		CKeyType cKeyReq = new CKeyType();
		if  (cKey != null){
			cKeyReq.setDisplayMode(cKey.getDisplayMode());		
			int i = 0;
				for(CKeyEntryType cKeyEntry : cKey.getCKeyEntry()){			
					CKeyEntryType cKeyEntryReq = new CKeyEntryType();
					
					for (CKeyFieldType cKeyField : cKeyEntry.getCKeyField()) {
						CKeyFieldType cKeyFieldReq = new CKeyFieldType();
						cKeyFieldReq.setId(cKeyField.getId());
						cKeyFieldReq.setCharData(cKeyField.getCharData());
						cKeyFieldReq.setHexData1(cKeyField.getHexData1());
						cKeyFieldReq.setHexData2(cKeyField.getHexData2());
						if (!(cKeyField.getCharData() == null & cKeyField.getFormatChar() == null & cKeyReq.getDisplayMode() == DisplayModeType.S)){
							cKeyEntryReq.getCKeyField().add(cKeyFieldReq);
						}						
					}
					cKeyReq.getCKeyEntry().add(cKeyEntryReq);
					cKeyReq.getCKeyEntry().get(i).setSegname(cKeyEntry.getSegname());
					i ++;
			}
		} else {
			return;
		}
						
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new LocateRequest (
					editorView.getServer(),((IViewSite) editorView.getSite()).getSecondaryId(),
					cKeyReq, currentSegment.getSegid(), ckeyDisplay, ckeyHex).createXml());
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(
				editorView.getServer(), map, "opendb", true, xmlDocument);

		do {
		} while (req.getResult() != Status.OK_STATUS);

		GUIResponseType response = req.getGuiResponseType();	
		if  (response.getEditResponse().getSegmentList() != null) {
			editorView.updateTableBasedOnLocateKeyResult(response);
		}	
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	
	public boolean doFinish() {
		if (!overTypeError) {
				sendRequestforLocateAndUpdateEditorView(currentSegment.getCKey());	
				CursorType fmiCursor = editorView.getCursor();
				fmiCursor.setCursorPosition(0);
				fmiCursor.setSegid(null);
				editorView.setCursor(fmiCursor);
			return true;	
		} else {
			return false;
		}
	}
	
	public void createToolbar(Composite parent) {
		Composite wrapper = new Composite(parent, SWT.NONE);
		wrapper.setLayout(new GridLayout(3, false));
		GridData gData = new GridData(SWT.FILL, SWT.TOP, true, false);
		wrapper.setLayoutData(gData);
		subTitleLabel = new Label(wrapper, SWT.FILL);
		gData = new GridData(SWT.FILL, SWT.TOP, true, false);
		gData.horizontalIndent = 5;
		gData.verticalIndent = 0;
		subTitleLabel.setLayoutData(gData);
		subTitleLabel.setVisible(false);
		gData = new GridData(SWT.RIGHT, SWT.TOP, false, false);
		//final ToolBar bar = new ToolBar(wrapper, SWT.FLAT);
		final ToolBar bar = new ToolBar(wrapper, SWT.NONE);
		gData = new GridData(SWT.RIGHT, SWT.TOP, false, false);
		bar.setLayoutData(gData);
		bar.setLayout(new FillLayout(SWT.RIGHT));
		
		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		
		charFormatItem = new ToolItem(bar, SWT.RADIO);		
		ImageDescriptor charImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-character-16.png"), null));
		
		
		charFormatItem.setImage(charImage.createImage());
		charFormatItem.setDisabledImage(charImage.createImage());
		charFormatItem.setToolTipText("Character Format");
		charFormatItem.addSelectionListener(new SelectionListener() {		
			@Override
			public void widgetSelected(SelectionEvent e) {
				viewer.getTable().forceFocus();
				if (!overTypeError){
					viewer.getTable().dispose();
					ckeyDisplay = DisplayModeType.C;
					createCharTable(container);
					if (overtyped) {
						updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
					} else {
						updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
					}
				} else {
					updateControlsState();
				}				
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		
		singleFormatItem = new ToolItem(bar, SWT.CHECK);
		ImageDescriptor singleImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-single-16.png"), null));
		singleFormatItem.setImage(singleImage.createImage());
		singleFormatItem.setToolTipText("Single Record Format");
		singleFormatItem.setDisabledImage(singleImage.createImage());
		singleFormatItem.addSelectionListener(new SelectionListener() { 		
			@Override
			public void widgetSelected(SelectionEvent e) {
				viewer.getTable().forceFocus();
				if (!overTypeError){
					viewer.getTable().dispose();
					ckeyDisplay = DisplayModeType.S;
					createSFTable(container);
					if (overtyped) {
						updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
					} else {
						updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
					}
				} else {
					updateControlsState();
				}				
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub		
			}
    	});
    	
		@SuppressWarnings("unused")
		ToolItem separator = new ToolItem(bar, SWT.SEPARATOR);
		
    	hexOnOffItem = new ToolItem(bar, SWT.CHECK);
    	ImageDescriptor image = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/hex-mode-16.png"), null));	
    	hexOnOffItem.setImage(image.createImage());
    	hexOnOffItem.setToolTipText("Hexadecimal");
    	hexOnOffItem.addSelectionListener(new SelectionListener() {		
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(ckeyHex == YorNType.Y){
					viewer.getTable().forceFocus();
					if (!overTypeError){
						ckeyHex = YorNType.N;
						if(ckeyDisplay == DisplayModeType.C){
							viewer.getTable().dispose();
							createCharTable(container);
						}
						if (overtyped) {
							updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
						} else {
							updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
						}
						hexAction.setChecked(false);
						hexOnOffItem.setSelection(false);
					} else {
						hexAction.setChecked(true);
						hexOnOffItem.setSelection(true);						
					}	
				} else {
					viewer.getTable().forceFocus();
					if (!overTypeError){
						ckeyHex = YorNType.Y;
						if(ckeyDisplay == DisplayModeType.C){
							viewer.getTable().dispose();
							createCharTable(container);
						}
						if (overtyped) {
							updateCKey(sendRequestforShowCKey(currentSegment.getCKey(),getCurrentSegment().getSegid()).getCKeyEntry());
						} else {
							updateCKey(sendRequestforShowCKey(null,getCurrentSegment().getSegid()).getCKeyEntry());
						}
						hexAction.setChecked(true);
						hexOnOffItem.setSelection(true);
					} else {
						hexAction.setChecked(false);
						hexOnOffItem.setSelection(false);						
					}
					
				}	
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub		
			}
    	});
	}
	
	private ArrayList<Integer> getProtectedValues(RangeListType rangeListType) {
		ArrayList<Integer> protectedValues = new ArrayList<Integer>();

		if(rangeListType != null) {
			ArrayList<RangeType> ranges = (ArrayList<RangeType>) rangeListType.getRange();
	        for(RangeType range: ranges) {
	            // the range values are 1 based
	        	// and the text caret position is 0 based.
	        	// need to subtract 1 so that they are compatible with
	        	// each other.
	        	int start = new Long(range.getStart() - 1).intValue();
	        	int end = new Long(range.getEnd() - 1).intValue();
                for(int i = start; i <= end; i++) {
                    protectedValues.add(i);
	        	}        	
	        }
		}
        
        Collections.sort(protectedValues);
        return protectedValues;
	}
	
	private SegmentType copySegmentType(SegmentType originalSegment){
		SegmentType copiedSegment = null;
        try {
            // Create the JAXBContext
                  JAXBContext jc = JAXBContext.newInstance(SegmentType.class);
    
            // Wrap the SegmentType object in a JAXBElement and a JAXBSource
            JAXBElement<SegmentType> originalJAXBElement = 
                new JAXBElement<SegmentType>(new QName("root"),SegmentType.class, originalSegment);
            JAXBSource source = new JAXBSource(jc, originalJAXBElement);
    
            // Treat the JAXBSource as an XML input and unmarshal it
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement<SegmentType> copiedJAXBElement = unmarshaller.unmarshal(source, SegmentType.class);
            copiedSegment = copiedJAXBElement.getValue();
        } catch (JAXBException e1) {
            e1.printStackTrace();
        }
		return copiedSegment;
		
	}
	
	private void TextValidator(CKeyType cKey) {
    	if (overtyped) {
    		String errorMessage = null;
    		if  (cKey != null){
    				for(CKeyEntryType cKeyEntry : cKey.getCKeyEntry()){			    					
    					for (CKeyFieldType cKeyField : cKeyEntry.getCKeyField()) {
    						//Char, Hex On mode
    						if (ckeyDisplay == DisplayModeType.C & ckeyHex == YorNType.Y) {
    							String errorMessageHex;
    							String HexValue = cKeyField.getHexData2() + cKeyField.getHexData1();
    							errorMessageHex = Validator.errorMsg[Validator.HexadecimalLength(HexValue, false)];
        						if (!errorMessageHex.isEmpty()){
        							errorMessage = errorMessageHex;
        						}
    						}
    						
    						//SF mode
    						if (cKeyField.getCharData() !=null & ckeyDisplay == DisplayModeType.S){
    							if (ckeyHex == YorNType.Y | (ckeyHex == YorNType.N & ((cKeyField.getLength() * 2) + 3) == cKeyField.getCharData().length())){    							
    							String errorMessageTmp = null;
    							if (cKeyField.getCharData().indexOf("X'") == 0 | cKeyField.getCharData().indexOf("x'") == 0){
    								if (cKeyField.getCharData().lastIndexOf("'") >0){
    									String HexValue = cKeyField.getCharData().substring(2,cKeyField.getCharData().length()-1);
    									errorMessageTmp = Validator.errorMsg[Validator.HexadecimalLength(HexValue, false)];
    								} else {
    									String HexValue = cKeyField.getCharData();
    									errorMessageTmp = Validator.errorMsg[Validator.HexadecimalLength(HexValue, false)];
    								}
    							} else {
    								errorMessageTmp = Validator.errorMsg[Validator.CharacterLength(cKeyField.getCharData(), cKeyField.getLength())];
    							}   						
    							if (!errorMessageTmp.isEmpty()){
    								errorMessage = errorMessageTmp;
    							}
    						}
    					}
    				}
    			}
    		}
    		setErrorMessage(errorMessage);
    	
    		if (errorMessage == null) {
    			overTypeError = false;	
    		} else {
    			overTypeError = true;
    		}
    	}		
	}
}
