/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.core.MRUList;
import com.ca.testingtools.ui.TextUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class MRUCombo {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Combo combo;
    private MRUList mru;

    public MRUCombo(Composite parent, int style, String mruname) {
        this.combo = new Combo(parent, 4 | style);
        GridData data = new GridData();
        this.mru = new MRUList(mruname);
        String[] stringArray = this.mru.GetNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.combo.add(name);
            ++n2;
        }
        if (this.combo.getItemCount() == 0) {
            this.combo.add("");
        }
        TextUtil.setWidth(this.combo, 1);
        this.combo.select(-1);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.combo.setLayoutData((Object)data);
    }

    public MRUCombo(Composite parent, String mruname) {
        this(parent, 0, mruname);
    }

    public int setSelection(String string) {
        String[] names = this.mru.GetNames();
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(string)) {
                this.combo.select(i);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getSelected() {
        int index = this.combo.getSelectionIndex();
        String name = index < 0 ? this.combo.getText().trim() : this.combo.getItem(index).trim();
        return name.length() == 0 ? null : name;
    }

    public boolean save() {
        String name = this.getSelected();
        if (name == null) {
            return false;
        }
        this.mru.add(name);
        return true;
    }

    public Combo getCombo() {
        return this.combo;
    }

    public MRUList getMru() {
        return this.mru;
    }
}

