/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BacktraceLogMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final short CVMO_BATCH = 1;
    public static final short CVMO_CICS = 0;
    protected static final int BATCH_REC_SIZE = 25;
    protected ArrayList<TraceLogRecord> log = null;

    protected short _defaultID() {
        return 3;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        TraceLogRecord batchrecord;
        int loop;
        int size = 0;
        size = newbuffer.getInt();
        int offset = newbuffer.getInt();
        this.log = new ArrayList(size);
        if (size == 0) {
            return;
        }
        byte[] buf = new byte[26];
        ByteBuffer recordbuffer = ByteBuffer.wrap(buf);
        int baseoffset = newbuffer.position();
        try {
            ((Buffer)newbuffer).position(baseoffset + offset + 25);
            for (loop = offset / 25 + 1; loop < size; ++loop) {
                batchrecord = this.buildBatchRecord(recordbuffer, newbuffer);
                if (batchrecord.program.length() == 0) continue;
                this.log.add(batchrecord);
            }
            ((Buffer)newbuffer).position(baseoffset);
        }
        catch (IllegalArgumentException batchrecord2) {
            // empty catch block
        }
        int looplimit = offset / 25;
        try {
            for (loop = 0; loop <= looplimit; ++loop) {
                batchrecord = this.buildBatchRecord(recordbuffer, newbuffer);
                if (batchrecord.program.length() == 0) continue;
                this.log.add(batchrecord);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private TraceLogRecord buildBatchRecord(ByteBuffer recordbuffer, ByteBuffer newbuffer) throws UnsupportedEncodingException {
        TraceLogRecord batchrecord = new TraceLogRecord();
        byte[] buf = recordbuffer.array();
        newbuffer.get(buf, 1, 25);
        ((Buffer)recordbuffer).position(0);
        batchrecord.firstStatement = recordbuffer.getInt();
        batchrecord.number = recordbuffer.get();
        batchrecord.program = HexUtil.rightTrim(new String(buf, 5, 8, "IBM1047"));
        ((Buffer)recordbuffer).position(13);
        batchrecord.seqnumber = recordbuffer.getInt();
        return batchrecord;
    }

    protected int _getMessageSize() {
        return 2 + (this.log == null ? 0 : this.log.size() * 25);
    }

    protected void buildMessage() throws Exception {
        if (this.log == null) {
            this.buffer.putShort((short)0);
            return;
        }
        this.buffer.put(this.putAvailable());
        switch (this.submessageID) {
            case 0: {
                this.buffer.putShort((short)this.log.size());
                for (TraceLogRecord record : this.log.toArray(new TraceLogRecord[this.log.size()])) {
                    if (record.program == null || record.program.trim().length() == 0) continue;
                    this.buffer.put(HexUtil.spaceFill(record.program.toUpperCase(), 8).getBytes("IBM1047"));
                    this.buffer.putShort((short)record.firstStatement);
                    this.buffer.putShort((short)record.lastStatement);
                }
                break;
            }
            case 1: {
                this.buffer.putInt(this.log.size());
                this.buffer.putInt(0);
                byte[] buf = new byte[26];
                ByteBuffer recordbuffer = ByteBuffer.wrap(buf);
                for (TraceLogRecord record : this.log.toArray(new TraceLogRecord[this.log.size()])) {
                    recordbuffer.putInt(record.firstStatement);
                    recordbuffer.put(record.number);
                    if (record.program == null) {
                        record.program = "";
                    }
                    recordbuffer.put(HexUtil.spaceFill(record.program.toUpperCase(), 8).getBytes("IBM1047"));
                    this.buffer.put(buf, 1, 25);
                }
                break;
            }
            default: {
                throw new ITException("Invalid submessage");
            }
        }
    }

    protected String _toString() {
        return null;
    }

    public TraceLogRecord[] getLogRecords() {
        if (this.log == null || this.log.size() == 0) {
            return new TraceLogRecord[0];
        }
        return this.log.toArray(new TraceLogRecord[this.log.size()]);
    }

    public void setSubmessageID(short submessageID) throws ITException {
        if (submessageID != 1 && submessageID != 0) {
            throw new ITException(String.format("Invalid type for %s", this.getClass().getSimpleName()));
        }
        super.setSubmessageID(submessageID);
    }

    public class TraceLogRecord {
        public String program;
        public int firstStatement;
        public int lastStatement;
        public byte number;
        public int linenumber;
        public String text;
        public long seqnumber;
    }
}

