/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BreakpointMessage
extends DebugMessage
implements IDebugMessage,
IBreakpointMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final String FORMAT_2 = "%1$s";
    private static final String FORMAT_1 = "%1$s Stmt:%2$d Line:%3$d";
    protected long breakpointID = 0L;
    protected int skipcount = 0;
    protected byte flag1 = 0;
    protected boolean enabled = true;
    protected boolean isCICS = false;
    protected int linenumber = 0;
    protected int statement = 1;
    protected boolean stopAfter = false;

    protected BreakpointMessage() {
        this(true);
    }

    protected BreakpointMessage(boolean b) {
        super(true);
    }

    protected void buildMessage() throws Exception {
        this.buffer.put(this.putProgram());
        this.buffer.put(this.putAvailable());
        this.buffer.putLong(this.breakpointID);
        this.buildSubBPMessage();
    }

    protected int _getMessageSize() {
        return 500;
    }

    protected abstract void buildSubBPMessage() throws ITException, UnsupportedEncodingException;

    public long getBreakpointID() {
        return this.breakpointID;
    }

    public void setBreakpointID(long breakpointID) {
        this.breakpointID = breakpointID;
    }

    public int getSkipcount() {
        return this.skipcount;
    }

    public void setSkipcount(int skipcount) {
        this.skipcount = skipcount;
    }

    protected boolean _checkID(short messageID) {
        return messageID == this._defaultID() || messageID == 5;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getStatement() {
        return this.statement;
    }

    public void setStatement(int statement) {
        this.statement = statement;
    }

    public void setStatement(Object statement) {
        if (statement == null) {
            return;
        }
        if (statement instanceof Number) {
            this.setStatement(((Number)statement).intValue());
        } else {
            try {
                this.setStatement(Integer.parseInt(statement.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setBreakpointID(Object breakpointID) {
        if (breakpointID == null) {
            return;
        }
        if (breakpointID instanceof Number) {
            this.setBreakpointID(((Number)breakpointID).longValue());
        } else {
            try {
                this.setBreakpointID(Long.parseLong(breakpointID.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setEnabled(Object enabled) {
        if (enabled == null) {
            return;
        }
        if (enabled instanceof Boolean) {
            this.setEnabled((Boolean)enabled);
        } else {
            this.setEnabled(Boolean.parseBoolean(enabled.toString()));
        }
    }

    public void setProgram(Object program) {
        if (program == null) {
            return;
        }
        this.setProgram(program.toString());
    }

    public void setSkipcount(Object skipcount) {
        if (skipcount == null) {
            return;
        }
        if (skipcount instanceof Number) {
            this.setSkipcount(((Number)skipcount).intValue());
        } else {
            try {
                this.setSkipcount(Integer.parseInt(skipcount.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    protected void fillOffsets(ByteBuffer buffer, String offset) {
        byte[] workarea = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(workarea);
        if (offset != null && offset.length() > 0) {
            int count = 0;
            Pattern pattern = Pattern.compile("[\\+\\-@%][\\w]+");
            Matcher matcher = pattern.matcher(offset);
            try {
                block2: while (matcher.find() && count < 5) {
                    String spec = matcher.group();
                    if (spec.length() <= 1) continue;
                    String prefix = spec.substring(0, 1);
                    String number = spec.substring(1);
                    int value = Integer.decode("0x" + number);
                    for (int j = 0; j < IDebugMessage.OFFSET_SYMBOLS.length; ++j) {
                        if (!IDebugMessage.OFFSET_SYMBOLS[j].matches(prefix)) continue;
                        buf.put(IDebugMessage.OFFSET_FLAGS[j]);
                        buf.putInt(value);
                        ++count;
                        continue block2;
                    }
                }
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
        buffer.put(workarea);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.linenumber;
        result = 31 * result + this.getProgram().hashCode();
        result = 31 * result + this.skipcount;
        result = 31 * result + this.statement;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IBreakpointMessage)) {
            return false;
        }
        IBreakpointMessage other = (IBreakpointMessage)obj;
        if (this.enabled != other.isEnabled()) {
            return false;
        }
        if (!this.getProgram().equals(other.getProgram())) {
            return false;
        }
        if (this.skipcount != other.getSkipcount()) {
            return false;
        }
        if (this.statement != other.getStatement()) {
            return false;
        }
        if (this.stopAfter != other.getStopAfter()) {
            return false;
        }
        return this.submessageID == other.getSubmessageID();
    }

    public boolean getStopAfter() {
        return this.stopAfter;
    }

    public void setStopAfter(boolean stopAfter) {
        this.stopAfter = stopAfter;
    }

    public void setStopAfter(Object stopAfter) {
        if (stopAfter == null) {
            return;
        }
        if (stopAfter instanceof Boolean) {
            this.setStopAfter((Boolean)stopAfter);
        } else {
            try {
                this.setStopAfter(Boolean.parseBoolean(stopAfter.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setSubmessageID(short submessageID) throws ITException {
        if (this.stopAfter) {
            submessageID = (short)(submessageID + 10);
        }
        super.setSubmessageID(submessageID);
    }

    public boolean isCICS() {
        return this.isCICS;
    }

    public void setIsCICS(boolean isCics) {
        this.isCICS = isCics;
    }

    public void setIsCICS(Object isCics) {
        if (isCics == null) {
            return;
        }
        if (isCics instanceof Boolean) {
            this.setIsCICS((Boolean)isCics);
        } else {
            this.setIsCICS(false);
        }
    }

    protected String _toString() {
        return String.format(this.linenumber == 0 ? FORMAT_2 : FORMAT_1, this.getProgram(), this.getStatement());
    }
}

