/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CSect {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final char ASM = 'A';
    public static final char COBOL = 'C';
    public static final char PLI = 'P';
    public static final char UNKNOWN = '?';
    public static final int CSECT_SIZE = 82;
    private String Comment;
    private String CSECTName;
    private String DSN;
    private boolean edit = true;
    private boolean mustEdit = false;
    private char language = (char)63;
    private String length;
    private String monitorName;
    private String offset;
    private String DDName;
    private int date;
    private int time;
    private boolean symbolSynched = false;
    private boolean isMainProgram = false;

    public CSect() {
    }

    public CSect(ByteBuffer buffer) {
        try {
            this.edit = buffer.get() == 0;
            this.symbolSynched = false;
            byte[] buff = new byte[8];
            buffer.get(buff);
            this.CSECTName = HexUtil.rightTrim(new String(buff, "IBM1047"));
            buff = new byte[8];
            buffer.get(buff);
            this.monitorName = HexUtil.rightTrim(new String(buff, "IBM1047"));
            buff = new byte[6];
            buffer.get(buff);
            this.offset = HexUtil.rightTrim(new String(buff, "IBM1047"));
            buff = new byte[6];
            buffer.get(buff);
            this.length = HexUtil.rightTrim(new String(buff, "IBM1047"));
            buff = new byte[1];
            buffer.get(buff);
            String lang = new String(buff, "IBM1047");
            this.language = lang.charAt(0);
            switch (this.language) {
                case 'A': 
                case 'C': 
                case 'P': {
                    break;
                }
                default: {
                    this.language = (char)63;
                }
            }
            buff = new byte[8];
            buffer.get(buff);
            this.DDName = HexUtil.rightTrim(new String(buff, "IBM1047"));
            buff = new byte[44];
            buffer.get(buff);
            this.DSN = HexUtil.rightTrim(new String(buff, "IBM1047"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
        }
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        try {
            buffer.put((byte)(!this.edit ? 1 : 0));
            buffer.put(HexUtil.spaceFill(this.CSECTName, 8).getBytes("IBM1047"));
            buffer.put(HexUtil.spaceFill(this.monitorName, 8).getBytes("IBM1047"));
            buffer.put(HexUtil.spaceFill(this.offset, 6).getBytes("IBM1047"));
            buffer.put(HexUtil.spaceFill(this.length, 6).getBytes("IBM1047"));
            buffer.put(Character.toString(this.language).getBytes("IBM1047"));
            buffer.put(HexUtil.spaceFill(this.DDName, 8).getBytes("IBM1047"));
            buffer.put(HexUtil.spaceFill(this.DSN, 44).getBytes("IBM1047"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
        }
        return (ByteBuffer)((Buffer)buffer).position(0);
    }

    public String getComment() {
        return this.Comment == null ? "" : this.Comment;
    }

    public String getCSECTName() {
        return this.CSECTName;
    }

    public String getDSN() {
        return this.DSN;
    }

    public String getLanguageText() {
        switch (this.language) {
            case 'A': {
                return "ASM";
            }
            case 'P': {
                return "PL/I";
            }
            case 'C': {
                return "COBOL";
            }
        }
        return Character.toString(this.language);
    }

    public char getLanguage() {
        return this.language;
    }

    public String getLength() {
        return this.length;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public String getOffset() {
        return this.offset;
    }

    public int getSize() {
        return 82;
    }

    public void setComment(String comment) {
        this.Comment = comment;
    }

    public void setCSECTName(String CSECTName) {
        if (!CSECTName.equals(this.CSECTName)) {
            this.CSECTName = CSECTName;
            this.setComment(null);
        }
    }

    public void setDSN(String DSN) {
        if (!DSN.equals(this.DSN)) {
            this.DSN = DSN;
            this.setEdit(true);
            this.setComment(null);
        }
    }

    public void setLanguage(char language) {
        if (language != this.language) {
            this.setEdit(true);
            this.language = Character.toUpperCase(language);
            this.setComment("");
            switch (this.language) {
                case 'A': 
                case 'C': 
                case 'P': {
                    break;
                }
                default: {
                    this.language = (char)63;
                }
            }
        }
    }

    public void setLanguage(String language) {
        if (language.length() < 1) {
            this.language = (char)63;
        } else {
            this.setLanguage(language.charAt(0));
        }
    }

    public void setLength(String length) {
        this.length = length;
    }

    public void setMonitorName(String monitorName) {
        if (!monitorName.equals(this.monitorName)) {
            this.setEdit(true);
            this.monitorName = monitorName;
            this.setComment(null);
            return;
        }
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setDDName(String DDName) {
        if (!DDName.equals(this.DDName)) {
            this.DDName = DDName;
            this.setEdit(true);
            this.setComment(null);
        }
    }

    public String toString() {
        return String.format("%s:%8s:%6s:%6s:%1s:%8s:%s", this.edit, this.monitorName, this.offset, this.length, Character.valueOf(this.language), this.DDName, this.DSN);
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getDDName() {
        return this.DDName;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean mustEdit() {
        return this.mustEdit;
    }

    public void setMustEdit(boolean mustEdit) {
        this.mustEdit = mustEdit;
    }

    public boolean isSymbolSynched() {
        return this.symbolSynched;
    }

    public void setSymbolSynched(boolean symbolSynched) {
        this.symbolSynched = symbolSynched;
    }

    public boolean isMainProgram() {
        return this.isMainProgram;
    }

    public void setMainProgram(boolean isMainProgram) {
        this.isMainProgram = isMainProgram;
    }
}

