/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.IAttribute;
import com.ca.intertest.tools.StringAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarAttribute
extends StringAttribute
implements IAttribute {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
    protected Calendar value;

    public CalendarAttribute(String name, String title, String value) {
        super(name, title, value);
    }

    public Object setValue(String value) {
        super.setValue(value);
        this.value = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            Date date = df.parse(value);
            this.value.setTime(date);
            date = this.value.getTime();
            this.string = df.format(date);
        }
        catch (ParseException e) {
            this.value = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.value;
    }

    public int getType() {
        return 4;
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

