/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MoreMessage;
import com.ca.intertest.tools.StatusMessage;
import java.io.ByteArrayOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class DSECT {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final int DSECT_VERSION_2 = -440018446;
    protected ArrayList<DebugMessage> debugmessages = new ArrayList();
    protected static final int slackbytes = 16;
    private static final byte[] slack = new byte[16];
    private int errorLevel = 0;
    private String errorMessage = "OK";
    protected int errorCount = 0;
    private int pUUID = 0;

    public DSECT() {
    }

    public DSECT(ByteBuffer buffer) {
        try {
            this.setArray(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMessage(DebugMessage message) {
        if (message != null) {
            Iterator<DebugMessage> it = this.debugmessages.iterator();
            while (it.hasNext()) {
                if (it.next() != message) continue;
                return;
            }
            this.debugmessages.add(message);
        }
    }

    public void addMessages(DebugMessage[] messages) {
        for (DebugMessage message : messages) {
            this.addMessage(message);
        }
    }

    public void setMessages(DebugMessage[] messages) {
        this.debugmessages.clear();
        this.addMessages(messages);
    }

    protected void reSequence(boolean force) {
        int seq = 1;
        for (DebugMessage item : this.debugmessages) {
            item.setSequencenumber(seq++, force);
        }
    }

    protected byte[] getArray() throws Exception {
        int messagecnt = 0;
        int packetlen = 16;
        byte[] buf = new byte[packetlen];
        for (DebugMessage debugMessage : this.debugmessages) {
            packetlen += debugMessage.getSize();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(packetlen += (this.debugmessages.size() - 1) * 16);
        stream.write(buf);
        for (DebugMessage item : this.debugmessages) {
            if (messagecnt++ > 0) {
                stream.write(slack);
            }
            stream.write(item.getBuffer().array());
        }
        buf = stream.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
        ((Buffer)byteBuffer).position(0);
        byteBuffer.putInt(stream.size());
        byteBuffer.putInt(-440018446);
        byteBuffer.putInt(this.pUUID);
        byteBuffer.putInt(this.debugmessages.size());
        return buf;
    }

    public int size() {
        return this.debugmessages.size();
    }

    protected abstract DebugMessage buildMessage(ByteBuffer var1) throws ITException, Exception;

    public void setArray(ByteBuffer buffer) {
        this.setArray(buffer, true);
    }

    public void setArray(ByteBuffer buffer, boolean reload) {
        if (reload) {
            this.debugmessages.clear();
        } else {
            DebugMessage last = this.getLastMessage();
            if (last instanceof MoreMessage) {
                this.debugmessages.remove(last);
            }
        }
        ((Buffer)buffer).position(0);
        if (buffer.remaining() < 8) {
            return;
        }
        if (buffer.getInt() > buffer.limit()) {
            return;
        }
        int messagecnt = buffer.getInt();
        if (messagecnt == -440018446) {
            this.pUUID = buffer.getInt();
            messagecnt = buffer.getInt();
        }
        for (int i = 0; i < messagecnt; ++i) {
            if (i > 0) {
                ((Buffer)buffer).position(buffer.position() + 16);
            }
            int msglen = buffer.getInt(buffer.position());
            byte[] msg = new byte[msglen];
            buffer.get(msg);
            try {
                this.addMessage(this.buildMessage(ByteBuffer.wrap(msg)));
                continue;
            }
            catch (Exception e) {
                this.addMessage(new StatusMessage(e));
            }
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder(String.format(" Messages:%d ", this.debugmessages.size()));
        for (DebugMessage element : this.debugmessages) {
            string.append("[" + element.toString() + "]");
        }
        return string.toString();
    }

    public DebugMessage[] getMessages() {
        if (this.debugmessages == null) {
            return null;
        }
        return this.debugmessages.toArray(new DebugMessage[0]);
    }

    public DebugMessage getMessage(int messagenumber) {
        if (this.debugmessages == null) {
            return null;
        }
        int index = messagenumber - 1;
        if (index < 0 || index >= this.debugmessages.size()) {
            return null;
        }
        return this.debugmessages.get(index);
    }

    public DebugMessage getLastMessage() {
        if (this.debugmessages == null) {
            return null;
        }
        return this.getMessage(this.debugmessages.size());
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            int index = errorMessage.indexOf("<<-- STACK_TRACE -->>");
            this.errorMessage = index != -1 ? errorMessage.substring(0, index) : errorMessage;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getpUUID() {
        return this.pUUID;
    }

    public void setpUUID(int pUUID) {
        this.pUUID = pUUID;
    }
}

