/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import java.nio.ByteBuffer;

public class DataReturnMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected byte[] hexdata;
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected int dataLength = 0;

    protected void buildMessage() throws Exception {
        this.buffer.putInt(this.dataLength);
        this.buffer.put(this.address.toByteArray());
        this.hexdata = new byte[this.dataLength];
        this.buffer.put(this.hexdata);
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.dataLength = this.buffer.getInt();
        this.address = new MFAddress(this.buffer);
        this.dataLength = Math.min(this.dataLength, this.buffer.remaining());
        this.hexdata = new byte[this.dataLength];
        this.buffer.get(this.hexdata);
    }

    public byte[] getHexdata() {
        return this.hexdata;
    }

    public void setHexdata(byte[] hex) {
        this.hexdata = hex;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public void setAddr(MFAddress addr) {
        this.address = addr;
    }

    public long getAlet() {
        return this.address.getAlet();
    }

    public void setAlet(long accessreg) {
        this.address.setAlet(accessreg);
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    protected short _defaultID() {
        return 5;
    }

    protected int _getMessageSize() {
        return 500;
    }

    protected String _toString() {
        String msg = String.format("Addr:%1$s Length:%2$d Data:%3$s", this.address.getAddrString(), this.dataLength, HexUtil.toHex(this.hexdata, 4));
        return msg;
    }
}

