/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import com.ca.intertest.tools.StatusMessage;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Formatter;

public abstract class DebugMessage
implements IDebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected boolean disposed = false;
    protected ByteBuffer buffer = null;
    protected short messageID = 0;
    protected short submessageID = 0;
    protected int sequencenumber = 0;
    protected int vardata = 0;
    protected int messageSize = 0;
    protected Object object;
    private static final String mask = " %0$02X";
    protected static final int HEADER_SIZE = 10;
    public static final String EMPTY = "";
    public static byte[] EMPTY_8BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected byte flag = 0;
    private String program = "";
    private String loadmodule = "";
    private String prefix = "";
    protected FileType filetype = FileType.PROGID;
    private final boolean useloadmodule;

    protected DebugMessage() {
        this(false);
    }

    protected DebugMessage(boolean useloadmodule) {
        this.messageID = this._defaultID();
        this.useloadmodule = useloadmodule;
    }

    public DebugMessage(ByteBuffer buffer) throws Exception {
        this(false);
        this.extractMessage(buffer);
    }

    public ByteBuffer getBuffer() throws Exception {
        this._initMessage(this._getMessageSize());
        this.buildMessage();
        this._setMessage();
        try {
            ByteBuffer byteBuffer = this.buffer;
            return byteBuffer;
        }
        finally {
            this.buffer = null;
        }
    }

    private void _initMessage(int capacity) {
        if (this.messageID == 0) {
            this.messageID = this._defaultID();
        }
        this.buffer = ByteBuffer.allocate(capacity + 10);
        ((Buffer)this.buffer).position(0);
        this.buffer.putInt(0);
        this.buffer.putShort(Numbers.putUShort(this.sequencenumber));
        this.buffer.putShort(this.messageID);
        this.buffer.putShort(this.submessageID);
    }

    private void _setMessage() {
        int position = this.buffer.position();
        this.buffer.putInt(0, position);
        if (this.buffer.remaining() != 0) {
            byte[] tempbuff = new byte[position];
            ((Buffer)this.buffer).position(0);
            this.buffer.get(tempbuff);
            this.buffer = ByteBuffer.wrap(tempbuff);
        }
        ((Buffer)this.buffer).position(0);
        this.buffer.putShort(6, this.messageID);
        this.buffer.putShort(8, this.submessageID);
    }

    public Object getObject() {
        return this.object;
    }

    public short getMessageID() {
        return this.messageID;
    }

    public DebugMessage extractMessage(ByteBuffer newbuffer) throws Exception {
        this.buffer = (ByteBuffer)((Buffer)newbuffer).position(0);
        this.object = this.buffer;
        ((Buffer)this.buffer).position(0);
        this.messageSize = this.buffer.getInt();
        this.sequencenumber = Numbers.getUShort(this.buffer.getShort());
        this.setMessageID(this.buffer.getShort());
        this.submessageID = this.buffer.getShort();
        this.vardata = this.buffer.position();
        this._extractMessage(this.buffer);
        return this;
    }

    protected abstract void _extractMessage(ByteBuffer var1) throws Exception;

    protected abstract void buildMessage() throws Exception;

    public short getSubmessageID() {
        return this.submessageID;
    }

    protected abstract String _toString();

    public String toString() {
        String string = this._toString();
        if (string == null) {
            if (this.buffer != null) {
                Formatter fmt = new Formatter();
                for (byte element : this.buffer.array()) {
                    fmt.format(mask, element);
                }
                string = fmt.toString();
            } else {
                string = EMPTY;
            }
        }
        return String.format("%s[%d:%d] %s", this.getClass().getSimpleName(), this.messageID, this.submessageID, string);
    }

    public static short getMessageID(ByteBuffer message) {
        if (message == null) {
            return -1;
        }
        return message.getShort(6);
    }

    public int getSequencenumber() {
        return this.sequencenumber;
    }

    public void setSequencenumber(int sequencenumber, boolean force) {
        if (this.sequencenumber == 0 || force) {
            this.sequencenumber = sequencenumber;
        }
    }

    public void setSequencenumber(int sequencenumber) {
        this.setSequencenumber(sequencenumber, false);
    }

    public void setSequencenumber(Object sequencenumber) {
        if (sequencenumber == null) {
            return;
        }
        if (sequencenumber instanceof Number) {
            this.setSequencenumber(((Number)sequencenumber).intValue());
        } else {
            try {
                this.setSequencenumber(Integer.parseInt(sequencenumber.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    protected void setMessageID(short messageID) throws ITException {
        if (!this._checkID(messageID)) {
            throw new ITException(messageID + " is invalid Message ID");
        }
        this.messageID = messageID;
    }

    protected boolean _checkID(short messageID) {
        return messageID == this._defaultID();
    }

    public void setSubmessageID(short submessageID) throws ITException {
        this.submessageID = submessageID;
    }

    public void setSubmessageID(Object submessageID) throws ITException {
        if (submessageID == null) {
            return;
        }
        if (submessageID instanceof Number) {
            this.setSubmessageID(((Number)submessageID).shortValue());
        } else {
            try {
                this.setSubmessageID(Short.parseShort(submessageID.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public StatusMessage statusMessage(short status, String text) {
        return this.statusMessage(status, new String[]{text});
    }

    public StatusMessage statusMessage(short status, String[] messages) {
        StatusMessage msg = new StatusMessage();
        msg.setStatus(status);
        msg.setRequestseqno(this.getSequencenumber());
        msg.setMessages(messages);
        return msg;
    }

    protected abstract int _getMessageSize();

    protected abstract short _defaultID();

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public int getSize() {
        return 10 + this._getMessageSize();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.messageID;
        result = 31 * result + this.sequencenumber;
        result = 31 * result + this.submessageID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IDebugMessage)) {
            return false;
        }
        IDebugMessage other = (IDebugMessage)obj;
        if (this.messageID != other.getMessageID()) {
            return false;
        }
        return this.submessageID == other.getSubmessageID();
    }

    protected String getProgram(ByteBuffer buffer) throws UnsupportedEncodingException {
        byte[] buf = new byte[8];
        buffer.get(buf);
        this.program = HexUtil.rightTrim(new String(buf, "IBM1047"));
        this.loadmodule = EMPTY;
        if (this.useloadmodule) {
            buffer.get(buf);
            if (!Arrays.equals(buf, EMPTY_8BYTES)) {
                this.loadmodule = HexUtil.rightTrim(new String(buf, "IBM1047"));
            }
        }
        return this.getProgram();
    }

    protected byte[] putProgram() throws UnsupportedEncodingException {
        ByteBuffer buffer = ByteBuffer.allocate(this.useloadmodule ? 16 : 8);
        buffer.put(HexUtil.spaceFill(this.program, 8).getBytes("IBM1047"));
        if (this.useloadmodule) {
            buffer.put(HexUtil.spaceFill(this.loadmodule, 8).getBytes("IBM1047"));
        }
        return buffer.array();
    }

    protected byte[] putProgram(String program) throws UnsupportedEncodingException {
        ByteBuffer buffer = ByteBuffer.allocate(this.useloadmodule ? 16 : 8);
        String[] items = program.split("_");
        if (items.length > 1) {
            buffer.put(HexUtil.spaceFill(items[1], 8).getBytes("IBM1047"));
            if (this.useloadmodule) {
                buffer.put(HexUtil.spaceFill(items[0], 8).getBytes("IBM1047"));
            }
        } else {
            buffer.put(HexUtil.spaceFill(items[0], 8).getBytes("IBM1047"));
            if (this.useloadmodule) {
                buffer.put(HexUtil.spaceFill(EMPTY, 8).getBytes("IBM1047"));
            }
        }
        return buffer.array();
    }

    public final String getProgram() {
        if (this.loadmodule.length() > 0) {
            return this.loadmodule.trim() + "_" + this.program.trim();
        }
        return this.prefix.trim() + this.program.trim();
    }

    public final String getShortProgram() {
        return this.program;
    }

    public final void setProgram(String program) {
        String[] items;
        if (program == null || program.length() == 0) {
            program = EMPTY;
            this.loadmodule = EMPTY;
            return;
        }
        if (program != null) {
            if (program.startsWith("$TRAN_")) {
                program = program.substring("$TRAN_".length());
                this.setTranID();
            } else if (program.startsWith("$TERM_")) {
                program = program.substring("$TERM_".length());
                this.setTermID();
            } else {
                this.setProgID();
            }
        }
        if ((items = program.split("_")).length > 1) {
            this.program = items[1].trim();
            this.loadmodule = items[0].trim();
        } else {
            this.program = items[0].trim();
            this.loadmodule = EMPTY;
        }
    }

    protected byte[] getAvailable(ByteBuffer buffer) {
        byte[] bytes = this.getAvailable(buffer, 20);
        this.flag = bytes[0];
        return bytes;
    }

    protected byte[] getAvailable(ByteBuffer buffer, int size) {
        byte[] result = new byte[size];
        buffer.get(result);
        return result;
    }

    protected byte[] putAvailable() {
        return this.putAvailable(20);
    }

    protected byte[] putAvailable(int size) {
        return new byte[size];
    }

    public final String getLoadmodule() {
        return this.loadmodule;
    }

    public final boolean isUseloadmodule() {
        return this.useloadmodule;
    }

    public boolean isProgram() {
        return this.filetype == FileType.PROGID;
    }

    public boolean isTermID() {
        return this.filetype == FileType.TERMID;
    }

    public boolean isTranID() {
        return this.filetype == FileType.TRANID;
    }

    public void setTermID() {
        this.filetype = FileType.TERMID;
        this.prefix = "$TERM_";
    }

    public void setTranID() {
        this.filetype = FileType.TRANID;
        this.prefix = "$TRAN_";
    }

    public void setProgID() {
        this.filetype = FileType.PROGID;
        this.prefix = EMPTY;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public final FileType getFiletype() {
        return this.filetype;
    }

    public final void setFiletype(FileType filetype) {
        this.filetype = filetype;
    }

    public boolean isStatementTraceEnd() {
        return (this.flag & 0x40) != 0;
    }

    public boolean isDummyBreakpoint() {
        return (this.flag & 0xFFFFFF80) != 0;
    }

    public boolean isNewStatementTrace() {
        return (this.flag & 0x20) != 0;
    }
}

