/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import java.nio.ByteBuffer;

public class ExecutionCountsMessage
extends DebugMessage
implements IDebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private String userId;
    private String termId;

    public ExecutionCountsMessage() {
        super(true);
    }

    protected short _defaultID() {
        return 36;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            this.getProgram(newbuffer);
            this.getAvailable(newbuffer);
            byte[] buf = new byte[4];
            newbuffer.get(buf);
            buf = new byte[8];
            newbuffer.get(buf);
            this.userId = HexUtil.rightTrim(new String(buf, "IBM1047"));
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    protected int _getMessageSize() {
        return 56;
    }

    protected void buildMessage() throws Exception {
        if (this.termId == null || this.termId.trim().length() == 0) {
            this.termId = ".ANY";
        }
        if (this.userId == null) {
            this.userId = "";
        }
        this.buffer.put(this.putProgram());
        this.buffer.put(this.putAvailable());
        this.buffer.put(HexUtil.spaceFill(this.termId.toUpperCase(), 4).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.userId.toUpperCase(), 8).getBytes("IBM1047"));
    }

    public void setUserId(String userId) {
        if (userId != null) {
            this.userId = userId;
        }
    }

    public void setTermId(String termId) {
        if (termId != null) {
            this.termId = termId;
        }
    }

    protected String _toString() {
        return null;
    }

    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                super.setSubmessageID(submessageID);
                return;
            }
        }
        throw new ITException("Invalid Execution Count type");
    }
}

