/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Messages;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileName {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private String DSN = "";
    private byte filetype = 0;
    public static final String[] FILE_TYPE_NAMES = new String[]{Messages.getString("FileTypePDS"), Messages.getString("FileTypePanvalet"), Messages.getString("FileTypeLibrarian"), Messages.getString("FileTypeHFS"), Messages.getString("FileTypeDDName"), Messages.getString("FileTypeEndevor"), Messages.getString("FileTypeSEQ")};
    public static final byte[] FILE_TYPES = new byte[]{1, 2, 3, 4, 5, 6, 7};
    private Object object;

    public FileName(byte filetype, String DSN, String member) {
        String mbr;
        this.setDSN(DSN);
        if (member != null && (mbr = member.trim()).length() > 0) {
            this.DSN = String.format("%s(%s)", this.DSN, mbr);
        }
        this.setFiletype(filetype);
    }

    public FileName(byte filetype, String DSN) {
        this(filetype, DSN, null);
    }

    public FileName(ByteBuffer buffer) {
        this.filetype = buffer.get();
        int length = Numbers.getUShort(buffer.getShort());
        if (length > 0) {
            byte[] name = new byte[length];
            buffer.get(name);
            try {
                this.DSN = new String(name, "IBM1047").trim();
            }
            catch (UnsupportedEncodingException e) {
                Logger.loggit(e);
            }
        } else {
            this.DSN = "";
        }
    }

    public FileName(Map<String, Object> map) {
        Object value = map.get("DSN");
        if (value instanceof String) {
            this.setDSN((String)value);
        }
        if ((value = map.get("type")) instanceof Number) {
            this.setFiletype(((Number)value).byteValue());
        } else if (value instanceof String) {
            this.setFiletype(Byte.parseByte((String)value));
        }
    }

    public int getSize() {
        return this._getSize();
    }

    private int _getSize() {
        return 3 + this.DSN.length();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buff = ByteBuffer.allocate(this._getSize());
        buff.put(this.filetype);
        buff.putShort((short)this.DSN.length());
        try {
            if (this.DSN.length() > 0) {
                buff.put(this.DSN.getBytes("IBM1047"));
            }
            return (ByteBuffer)((Buffer)buff).position(0);
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            return null;
        }
    }

    public String getDSN() {
        return this.DSN;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn.trim();
    }

    public String getRootName() {
        String[] parts = this.DSN.split("[()]");
        if (parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public String getMemberName() {
        String[] parts = this.DSN.split("[()]");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    public byte getFiletype() {
        return this.filetype;
    }

    public void setFiletype(byte filetype) {
        this.filetype = filetype;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        return String.format("%s:%s", FileName.fileTypeString(this.filetype), this.DSN);
    }

    public static String fileTypeString(byte type) {
        for (int i = 0; i < FILE_TYPES.length; ++i) {
            if (FILE_TYPES[i] != type) continue;
            return FILE_TYPE_NAMES[i];
        }
        return String.format("Type:%d", type);
    }

    public Map<String, Object> getParms() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DSN", this.getDSN());
        map.put("type", this.getFiletype());
        map.put("member", this.getMemberName());
        map.put("rootname", this.getRootName());
        return map;
    }
}

