/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class FindRequestMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected int dataLength = 0;
    protected short findDirect = 0;
    protected byte findType = 0;
    protected int findRange = 0;
    protected String findValue = "";

    public FindRequestMessage() {
    }

    public FindRequestMessage(short submessageID) throws ITException {
        this();
        this.setSubmessageID(submessageID);
    }

    protected void buildMessage() throws Exception {
        this.buffer.put(this.findType);
        this.buffer.putInt(this.dataLength);
        this.buffer.put(this.address.toByteArray());
        this.buffer.putInt(this.findRange);
        if (this.findType == 0) {
            int lth = this.findValue.length() / 2;
            this.buffer.putShort((short)lth);
            this.buffer.put(HexUtil.HextoBytes(this.findValue));
        } else {
            this.buffer.putShort((short)this.findValue.length());
            this.buffer.put(this.findValue.getBytes("IBM1047"));
        }
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.findType = this.buffer.get();
        this.dataLength = this.buffer.getInt();
        this.address = new MFAddress(this.buffer);
        this.findRange = this.buffer.getInt();
        int lth = Numbers.getUShort(this.buffer.getShort());
        byte[] buf = new byte[lth];
        this.buffer.get(buf);
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public void setFindDirect(short direction) {
        this.findDirect = direction;
    }

    public void setFindType(byte type) {
        this.findType = type;
    }

    public void setAlet(long aletval) {
        this.address.setAlet(aletval);
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void setFindRange(int range) {
        this.findRange = range;
    }

    public void setFindValue(String value) {
        this.findValue = value;
    }

    protected short _defaultID() {
        return 39;
    }

    public void setSubmessageID(short submessageID) throws ITException {
        super.setSubmessageID(submessageID);
    }

    protected int _getMessageSize() {
        return 500;
    }

    protected String _toString() {
        return null;
    }
}

