/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MemberInfo;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class GMBRMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private String DSN = "";
    private MemberInfo memberinfo = new MemberInfo();
    private int selectedDate = 0;
    private int selectedTime = 0;

    public String getDSN() {
        return this.DSN;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn;
    }

    public String getMember() {
        return this.memberinfo.getMember();
    }

    protected void buildMessage() throws Exception {
        ByteBuffer msgbuffer = this.memberinfo.getBuffer();
        this.DSN = HexUtil.rightTrim(this.DSN);
        this.buffer.put(msgbuffer);
        this.buffer.putShort((short)this.DSN.length());
        this.buffer.put(this.DSN.getBytes("IBM1047"));
        this.buffer.put(Numbers.pack(this.selectedDate, 3));
        this.buffer.put(Numbers.pack(this.selectedTime, 4));
    }

    public MemberInfo getMemberinfo() {
        return this.memberinfo;
    }

    public void setMemberinfo(MemberInfo memberinfo) {
        this.memberinfo = memberinfo;
    }

    protected short _defaultID() {
        return 30;
    }

    protected void _extractMessage(ByteBuffer buffer) throws Exception {
        this.memberinfo = new MemberInfo(buffer);
        int size = Numbers.getUShort(buffer.getShort());
        if (size > 0) {
            byte[] dsn = new byte[size];
            buffer.get(dsn);
            this.DSN = new String(dsn, "IBM1047");
        }
        if (buffer.remaining() > 0) {
            try {
                byte[] selDate = new byte[3];
                buffer.get(selDate);
                this.selectedDate = Numbers.unpack(selDate).intValue();
                byte[] selTime = new byte[4];
                buffer.get(selTime);
                this.selectedTime = Numbers.unpack(selTime).intValue();
            }
            catch (Exception e) {
                this.selectedDate = 0;
                this.selectedTime = 0;
            }
        } else {
            this.selectedDate = 0;
            this.selectedTime = 0;
        }
    }

    protected int _getMessageSize() {
        this.DSN = HexUtil.rightTrim(this.DSN);
        return this.memberinfo.getSize() + 2 + this.DSN.length() + 7;
    }

    protected String _toString() {
        return null;
    }

    public int getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(int date) {
        this.selectedDate = date;
    }

    public int getSelectedTime() {
        return this.selectedTime;
    }

    public void setSelectedTime(int time) {
        this.selectedTime = time;
    }
}

