/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.CSect;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCompositeMessage
extends DebugMessage {
    public static final short CVMI_COMPOSITE_GETMAP = 0;
    public static final short CVMI_COMPOSITE_ON = 1;
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected ArrayList<CSect> csects = new ArrayList();
    protected String programName = "";

    public GetCompositeMessage() {
    }

    public GetCompositeMessage(String programName) {
        this.programName = programName;
    }

    public int getCSectSize() {
        return this.csects.size();
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 0: 
            case 1: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException(String.format("Invalid Message type for %s", this.getClass().getSimpleName()));
            }
        }
    }

    @Override
    protected short _defaultID() {
        return 40;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] buff = new byte[8];
        this.buffer.get(buff);
        this.programName = HexUtil.rightTrim(new String(buff, "IBM1047"));
        if (this.submessageID == 1 || this.getMessageID() == 41) {
            int size = Numbers.getUShort(this.buffer.getShort());
            this.csects.clear();
            while (size-- > 0) {
                CSect csect = new CSect(this.buffer);
                this.csects.add(csect);
            }
        }
    }

    @Override
    protected int _getMessageSize() {
        int size = 8;
        switch (this.submessageID) {
            case 0: {
                break;
            }
            case 1: {
                size += 2 + 82 * this.csects.size();
            }
        }
        return size;
    }

    @Override
    protected String _toString() {
        if (this.csects.size() == 0) {
            return this.programName;
        }
        StringBuilder string = new StringBuilder(this._getMessageSize() + this.csects.size() + 2);
        string.append("[");
        for (CSect item : this.csects) {
            string.append(item.toString());
            string.append(",");
        }
        string.setCharAt(string.length() - 1, ']');
        return string.toString();
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(HexUtil.spaceFill(this.programName, 8).getBytes("IBM1047"));
        if (this.submessageID != 1) {
            return;
        }
        this.buffer.putShort((short)this.csects.size());
        for (CSect item : this.csects) {
            this.buffer.put(item.getBuffer());
        }
    }

    public ArrayList<CSect> getCSects() {
        return this.csects;
    }

    public void setCSects(ArrayList<CSect> csects) {
        this.csects = csects;
    }
}

