/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class PUEXIMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private StringBuilder UEXIList = new StringBuilder();

    protected short _defaultID() {
        return 31;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.UEXIList.setLength(0);
        int count = Numbers.getUShort(this.buffer.getShort());
        byte[] bytes = new byte[8];
        for (int i = 0; i < count; ++i) {
            this.buffer.get(bytes);
            String label = new String(bytes, "IBM1047").trim();
            int ix = this.buffer.get();
            int index = ix < 0 ? ix + 256 : ix;
            this.UEXIList.append(String.format("%s=%d;", label, index));
        }
        if (this.UEXIList.length() > 0) {
            this.UEXIList.setLength(this.UEXIList.length() - 1);
        }
    }

    protected void buildMessage() throws Exception {
        String[] itemlist;
        int pos = this.buffer.position();
        short count = 0;
        this.buffer.putShort(count);
        for (String item : itemlist = this.UEXIList.toString().split(";")) {
            String[] args = item.split("=");
            if (args.length != 2) continue;
            this.buffer.put(HexUtil.spaceFill(args[0], 8).getBytes("IBM1047"));
            this.buffer.put(Byte.parseByte(args[1]));
            count = (short)(count + 1);
        }
        this.buffer.putShort(pos, count);
    }

    public String getUEXIList() {
        return this.UEXIList.toString();
    }

    protected int _getMessageSize() {
        return 2000;
    }

    protected String _toString() {
        return null;
    }
}

