/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Numbers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtsymItem
implements Comparator<ProtsymItem> {
    public static final int PROTSYMITEM_SIZE = 59;
    private String DDName;
    private int date;
    private int time;
    private String DSN;

    public ProtsymItem(ByteBuffer buffer) {
        this();
        this.extractBuffer(buffer);
    }

    protected ProtsymItem() {
    }

    protected void extractBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            try {
                byte[] buf = new byte[8];
                buffer.get(buf);
                this.DDName = new String(buf, "IBM1047").trim();
                buf = new byte[3];
                buffer.get(buf);
                if (buf[2] != 0) {
                    this.date = Numbers.unpack(buf).intValue();
                }
                buf = new byte[4];
                buffer.get(buf);
                if (buf[3] != 0) {
                    this.time = Numbers.unpack(buf).intValue();
                }
                buf = new byte[44];
                buffer.get(buf);
                this.DSN = new String(buf, "IBM1047").trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        try {
            buffer.put(HexUtil.spaceFill(this.DDName, 8).getBytes("IBM1047"));
            buffer.put(Numbers.pack(this.date, 3));
            buffer.put(Numbers.pack(this.time, 4));
            buffer.put(HexUtil.spaceFill(this.DSN, 44).getBytes("IBM1047"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ByteBuffer)((Buffer)buffer).position(0);
    }

    public int getDate() {
        return this.date;
    }

    public String getDSN() {
        return this.DSN;
    }

    public String getDDName() {
        return this.DDName;
    }

    public int getSize() {
        return 59;
    }

    public int getTime() {
        return this.time;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn;
    }

    public void setDDName(String DDName) {
        this.DDName = DDName;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String toString() {
        return String.format("%s:%s %s", this.DDName, HexUtil.TimeStampString(this.date, this.time), this.DSN);
    }

    @Override
    public int compare(ProtsymItem o1, ProtsymItem o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1.date == o2.date) {
            if (o1.time == o2.time) {
                return o1.DSN.compareTo(o2.DSN);
            }
            return o1.time < o2.time ? -1 : 1;
        }
        return o1.date < o2.date ? -1 : 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProtsymItem)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.compare(this, (ProtsymItem)obj) == 0;
    }
}

