/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ServerRequestMessage
extends DebugMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final short SHUTDOWN = 1;
    public static final short COMMAND = 2;
    private String command = "";

    public ServerRequestMessage() {
    }

    public ServerRequestMessage(short command) throws ITException {
        this();
        this.setSubmessageID(command);
    }

    public ServerRequestMessage(ByteBuffer buffer) throws Exception {
        super(buffer);
    }

    protected short _defaultID() {
        return 37;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        switch (this.submessageID) {
            case 2: {
                if (this.buffer.remaining() > 2) {
                    int length = this.buffer.getShort();
                    if (this.buffer.remaining() < length) {
                        length = this.buffer.remaining();
                    }
                    byte[] buff = new byte[length];
                    this.buffer.get(buff);
                    this.command = new String(buff, "IBM1047").trim();
                    break;
                }
                this.setCommand(null);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected int _getMessageSize() {
        switch (this.submessageID) {
            case 2: {
                return 2 + this.command.length();
            }
        }
        return 0;
    }

    protected String _toString() {
        String type;
        switch (this.submessageID) {
            case 2: {
                type = "COMMAND";
                break;
            }
            case 1: {
                type = "SHUTDOWN";
                break;
            }
            default: {
                type = "UNKNOWN";
            }
        }
        return String.format("%s %s", type, this.getCommand());
    }

    protected void buildMessage() throws Exception {
        switch (this.submessageID) {
            case 2: {
                try {
                    this.buffer.putShort((short)this.command.length());
                    this.buffer.put(this.command.getBytes("IBM1047"));
                }
                catch (UnsupportedEncodingException e) {
                    Logger.loggit(e);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid Server Request");
            }
        }
    }

    public String getCommand() {
        return this.command == null ? "" : this.command;
    }

    public void setCommand(String command) {
        this.command = command == null ? "" : command;
    }

    public DebugMessage extractMessage(ByteBuffer newbuffer) throws Exception {
        return super.extractMessage(newbuffer);
    }
}

