/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.IVariableBreakpointMessage;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class VariableBreakpointMessage
extends BreakpointMessage
implements IVariableBreakpointMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected byte leftType = 0;
    protected int leftValueLen = 0;
    protected String leftVar = "";
    protected String leftOffset = "";
    protected int leftLenOvrd = 0;
    protected boolean dropMonitor = false;

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            this.getProgram(this.buffer);
            this.getAvailable(this.buffer);
            this.breakpointID = this.buffer.getLong();
            this.skipcount = Numbers.getUShort(this.buffer.getShort());
            this.flag1 = this.buffer.get();
            int lleftvarlen = Numbers.getUShort(this.buffer.getShort());
            this.leftValueLen = this.buffer.getInt();
            this.leftType = this.buffer.get();
            byte[] buf = new byte[lleftvarlen];
            this.buffer.get(buf);
            this.leftVar = new String(buf, "IBM1047");
        }
        catch (BufferUnderflowException e) {
            Logger.loggit(e);
            throw new ITException("Invalid message for BreakPoint message", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITException(e.getCause());
        }
    }

    protected short _defaultID() {
        return 3;
    }

    protected void buildSubBPMessage() throws ITException, UnsupportedEncodingException {
        if (this.isCICS) {
            this.buildCICSSubBPMessage();
        }
        this.buffer.putShort(Numbers.putUShort(this.skipcount));
        this.buffer.put(this.flag1);
        this.buffer.putShort((short)this.leftVar.length());
        if (this.leftValueLen < 0) {
            this.leftValueLen = 0;
        }
        this.buffer.putInt(this.leftValueLen);
        if (this.leftType < 0) {
            this.leftType = 1;
        }
        if (!this.isCICS) {
            this.leftType = 1;
        }
        this.buffer.put(this.leftType);
        this.buffer.put(this.leftVar.getBytes("IBM1047"));
    }

    public byte getLeftType() {
        return this.leftType;
    }

    public int getLeftValueLen() {
        return this.leftValueLen;
    }

    public String getLeftVar() {
        return this.leftVar;
    }

    public String getLeftOffset() {
        return this.leftOffset;
    }

    public void setLeftOffset(Object leftOffset) {
        if (leftOffset == null) {
            return;
        }
        this.setLeftOffset(leftOffset.toString());
    }

    public void setLeftOffset(String leftOffset) {
        this.leftOffset = leftOffset;
    }

    public void setLeftType(byte leftType) {
        this.leftType = leftType;
    }

    public void setLeftType(Object leftType) {
        if (leftType == null) {
            return;
        }
        if (leftType instanceof Number) {
            this.setLeftType(((Number)leftType).byteValue());
        } else {
            try {
                this.setLeftType(Byte.parseByte(leftType.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setLeftValueLen(int leftValueLen) {
        this.leftValueLen = leftValueLen;
    }

    public void setLeftValueLen(Object leftValueLen) {
        if (leftValueLen == null) {
            return;
        }
        if (leftValueLen instanceof Number) {
            this.setLeftValueLen(((Number)leftValueLen).intValue());
        } else {
            try {
                this.setLeftValueLen(Integer.parseInt(leftValueLen.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setLeftVar(Object leftVar) {
        if (leftVar == null) {
            return;
        }
        this.setLeftVar(leftVar.toString());
    }

    public void setLeftVar(String leftVar) {
        this.leftVar = leftVar.trim();
    }

    public void setSubmessageID(short submessageID) throws ITException {
        short subId = 0;
        super.setSubmessageID(subId);
    }

    protected String _toString() {
        return super._toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.leftOffset == null ? 0 : this.leftOffset.hashCode());
        result = 31 * result + this.leftValueLen;
        result = 31 * result + (this.leftVar == null ? 0 : this.leftVar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IVariableBreakpointMessage)) {
            return false;
        }
        IVariableBreakpointMessage other = (IVariableBreakpointMessage)obj;
        other.setStatement(0);
        this.setStatement(0);
        if (this.leftOffset == null ? other.getLeftOffset() != null : !this.leftOffset.equals(other.getLeftOffset())) {
            return false;
        }
        if (this.leftType != other.getLeftType()) {
            return false;
        }
        if (this.leftValueLen != other.getLeftValueLen()) {
            return false;
        }
        if (this.leftVar == null ? other.getLeftVar() != null : !this.leftVar.equals(other.getLeftVar())) {
            return false;
        }
        if (this.leftLenOvrd != other.getLeftLenOvrd()) {
            return false;
        }
        if (this.dropMonitor != other.getDropMonitor()) {
            return false;
        }
        return super.equals(obj);
    }

    protected void buildCICSSubBPMessage() {
        if (this.leftType == 1) {
            this.leftVar = "'" + this.leftVar + "'";
        }
        if (this.leftLenOvrd > 0) {
            this.leftValueLen = this.leftLenOvrd;
        }
        if (this.leftOffset != null && this.leftOffset.length() > 0) {
            this.leftVar = this.leftVar + this.leftOffset;
        }
        if (this.dropMonitor) {
            this.flag1 = (byte)2;
        }
    }

    public int getLeftLenOvrd() {
        return this.leftLenOvrd;
    }

    public void setLeftLenOvrd(int leftLenOvrd) {
        this.leftLenOvrd = leftLenOvrd;
    }

    public void setLeftLenOvrd(Object leftLenOvrd) {
        if (leftLenOvrd == null) {
            return;
        }
        if (leftLenOvrd instanceof Number) {
            this.setLeftLenOvrd(((Number)leftLenOvrd).intValue());
        } else {
            try {
                this.setLeftLenOvrd(Integer.parseInt(leftLenOvrd.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    public boolean getDropMonitor() {
        return this.dropMonitor;
    }

    public void setDropMonitor(boolean dropMonitor) {
        this.dropMonitor = dropMonitor;
    }

    public void setDropMonitor(Object dropMonitor) {
        if (dropMonitor == null) {
            return;
        }
        if (dropMonitor instanceof Boolean) {
            this.setDropMonitor((Boolean)dropMonitor);
        } else {
            this.setDropMonitor(Boolean.parseBoolean(dropMonitor.toString()));
        }
    }
}

