/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.Attribute;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.scanSource;

public class scanCOBOL
extends scanSource
implements IScanSource {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private String[] titles = new String[]{"5648-", "5668-", "5740-", "5688-", "5655-", "LineID"};
    private Integer version;
    private String regex5 = "[0-9]{5}";
    private String regex6 = "[0-9]{6}";
    private String regex;

    public scanCOBOL(String version) {
        this.version = (Integer)Attribute.getValue("gt_m_cty", version);
        this.setValues();
    }

    public boolean isCandidate(String line) {
        if (line.length() < this.stmtStart) {
            return false;
        }
        for (int i = 0; i < this.titles.length; ++i) {
            int index = line.indexOf(this.titles[i]);
            if (index < 0 || index >= 10) continue;
            return false;
        }
        String token = line.substring(this.seqStart, this.seqEnd);
        boolean numeric = token.matches(this.regex);
        if (numeric) {
            return line.substring(this.seqEnd, this.stmtStart).trim().length() == 0;
        }
        return false;
    }

    public int getType() {
        return 32;
    }

    protected void setValues() {
        if (this.version != null) {
            switch (this.version) {
                case 1: {
                    this.seqStart = 0;
                    this.seqEnd = this.seqStart + 5;
                    this.stmtStart = 7;
                    this.stmtComment = this.stmtStart + 6;
                    this.regex = this.regex5;
                    this.lineRegex = "[\\w\\+\\-*=()]+|('[\\w\\s,.+-=()#@;:?%!&<>\"*!/$]+')";
                    break;
                }
                default: {
                    this.seqStart = 2;
                    this.seqEnd = this.seqStart + 6;
                    this.stmtStart = 17;
                    this.stmtComment = this.stmtStart + 6;
                    this.regex = this.regex6;
                    this.lineRegex = "[\\w\\+\\-*=()]+|('[\\w\\s,.+-=()#@;:?%!&<>\"*!/$]+')";
                }
            }
        }
    }

    public int getStatement(String line) {
        int statement = -1;
        if (this.isCandidate(line) && (statement = this.getSeqNumber(line, false, this.seqStart, this.seqEnd - this.seqStart)) == -1) {
            statement = 0;
        }
        return statement;
    }
}

