/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.IScanSource;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class scanSource
implements IScanSource {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected int seqStart = 0;
    protected int seqEnd = 0;
    protected int stmtStart = 0;
    protected int stmtComment = 0;
    protected String commentChar = "*";
    protected String commentRegex;
    protected int sourceLength = 71;
    protected boolean stripblanks = false;
    protected String lineRegex = "[\\w()+-=]+";

    @Override
    public String getSourceSegment(String line) {
        if (this.isCandidate(line)) {
            int startindex;
            int length = line.length();
            int endIndex = length <= (startindex = this.getStmtStart()) + this.getSourceLength() ? length : startindex + this.getSourceLength();
            return line.substring(startindex, endIndex);
        }
        return "";
    }

    public scanSource() {
        this.setValues();
        if (this.seqEnd < this.seqStart) {
            this.seqEnd = this.seqStart;
        }
        if (this.stmtStart < this.seqEnd) {
            this.stmtStart = this.seqEnd;
        }
        if (this.stmtComment < this.stmtStart) {
            this.stmtComment = this.stmtStart;
        }
        this.commentRegex = "[" + this.commentChar + "]";
    }

    @Override
    public int getSeqEnd() {
        return this.seqEnd;
    }

    @Override
    public int getSeqStart() {
        return this.seqStart;
    }

    @Override
    public int getStmtComment() {
        return this.stmtComment;
    }

    @Override
    public int getStmtStart() {
        return this.stmtStart;
    }

    @Override
    public boolean isStripblanks() {
        return this.stripblanks;
    }

    protected abstract void setValues();

    protected final int getSeqNumber(String s) {
        return this.getSeqNumber(s, this.stripblanks, this.seqStart, this.seqEnd - this.seqStart + 1);
    }

    protected final int getSeqNumber(String s, boolean trim, int start, int length) {
        String number = s.substring(start, start + length);
        if (trim) {
            while (number.startsWith(" ")) {
                number = number.substring(1);
            }
        }
        int i = -1;
        try {
            i = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return i;
    }

    @Override
    public int getSourceLength() {
        return this.sourceLength;
    }

    @Override
    public int getSourceOffset() {
        return this.getStmtComment();
    }

    @Override
    public boolean isCommentLine(String line) {
        if (this.isCandidate(line)) {
            String cmt;
            try {
                cmt = line.substring(this.stmtComment, this.stmtComment + 1);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return cmt.matches(this.commentRegex);
        }
        return false;
    }

    @Override
    public boolean isExecuteCode(String line) {
        if (this.isCandidate(line)) {
            return !this.isCommentLine(line);
        }
        return false;
    }

    @Override
    public List<String> getStringTokens(String input) {
        return this.getStringTokens(input, this.lineRegex);
    }

    @Override
    public List<String> getStringTokens(String input, String regex) {
        if (input.length() <= 0 || regex.length() <= 0) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (matcher.group().length() <= 0) continue;
            tokens.add(matcher.group());
        }
        if (tokens.isEmpty()) {
            return null;
        }
        return tokens;
    }

    @Override
    public String getLineRegex() {
        return this.lineRegex;
    }
}

