/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.MarkerPropertySource;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;

public class IT_TreeItem
implements IAdaptable,
IActionFilter {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private String name;
    private TreeType type = null;
    private IT_TreeItem parent = null;
    private Object obj = null;
    private Object propertysource = null;
    private ArrayList<IT_TreeItem> children = new ArrayList(0);

    private IT_TreeItem() {
    }

    public IT_TreeItem(TreeType type, Object obj) {
        this(type, obj, obj.toString());
    }

    public IT_TreeItem(TreeType type, Object obj, String name) {
        this();
        Class<?> typeclass = type.get();
        if (typeclass.isAssignableFrom(obj.getClass())) {
            this.type = type;
            this.obj = obj;
            this.name = name;
        }
        Assert.isNotNull((Object)((Object)this.type), (String)"Constructor Object");
    }

    public IT_TreeItem getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(IT_TreeItem parent) {
        this.parent = parent;
    }

    public IT_TreeItem getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    public void addChild(IT_TreeItem child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(IT_TreeItem child) {
        child.setParent(null);
        this.children.remove(child);
    }

    public IT_TreeItem[] getChildren() {
        return this.children.toArray(new IT_TreeItem[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public int size() {
        return this.children.size();
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (this.obj.getClass().equals(adapter)) {
            return this.obj;
        }
        if (this.obj instanceof IAdaptable && (result = ((IAdaptable)this.obj).getAdapter(adapter)) != null) {
            return result;
        }
        if (adapter == IPropertySource.class) {
            if (this.propertysource == null) {
                this.propertysource = this.getPropertySource();
            }
            return this.propertysource;
        }
        return null;
    }

    protected Object getPropertySource() {
        switch (this.type) {
            case MARKER: {
                return new MarkerPropertySource((IMarker)this.obj);
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            return this.obj.equals(((IT_TreeItem)other).getObj());
        }
        return this.obj.equals(other);
    }

    public TreeType getType() {
        return this.type;
    }

    public Object getObj() {
        return this.obj;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (!(target instanceof IT_TreeItem)) {
            return false;
        }
        Object extract = ((IT_TreeItem)target).getObj();
        IT_TreeItem root = ((IT_TreeItem)target).getRoot();
        if (root != null && root.getType() == TreeType.SESSION) {
            debugFile file;
            debugSession session = (debugSession)root.getObj();
            boolean test = Boolean.parseBoolean(value);
            if (name.equals("isdebugging")) {
                return session.isDebugging() == test;
            }
            if (name.equals("isatbreakpoint")) {
                return session.isAtBreakpoint() == test;
            }
            if (name.equals("issession")) {
                return test;
            }
            if (name.equals("isbatch")) {
                return session.isBatch() == test;
            }
            if (name.equals("iscics")) {
                return session.isCICS() == test;
            }
            if (name.equals("isintertest")) {
                return extract instanceof IDebug == test;
            }
            if (name.endsWith("isfile")) {
                boolean result = false;
                if (extract instanceof debugFile) {
                    result = true;
                }
                return result == test;
            }
            if (name.equals("isunmonitored") && !(file = (debugFile)extract).isMonitor()) {
                return test;
            }
        }
        return false;
    }
}

