/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.ASMVariable;
import com.ca.intertest.common.CobolVariable;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.XMLFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Keywords {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    static TreeObject pgmtree = null;
    static Keywords keywords = null;
    protected HashMap<String, HashMap<String, IMemento>> versionsmap;
    protected Bundle bundle;

    private Keywords() throws ITException {
        URL urlEntry = null;
        InputStreamReader urlReader = null;
        InputStream urlStream = null;
        String name = this.getClass().getSimpleName();
        String format = "%s:%s";
        try {
            this.bundle = IntertestPlugin.getDefault().getBundle();
            if (this.bundle == null) {
                throw new ITException(String.format(format, name, Messages.Keywords_1));
            }
            urlEntry = this.bundle.getEntry("keywords.xml");
            if (urlEntry == null) {
                throw new ITException(String.format(format, name, Messages.Keywords_3));
            }
            urlStream = urlEntry.openStream();
            urlReader = new InputStreamReader(urlStream);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)urlReader);
            IMemento[] major = memento.getChildren("keywords");
            this.versionsmap = new HashMap(major.length);
            IMemento[] iMementoArray = major;
            int n = major.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento item = iMementoArray[n2];
                String type = item.getString("type");
                String version = item.getString("version");
                if (type == null || version == null) {
                    throw new ITException(String.format(format, name, String.valueOf(Messages.Keywords_7) + item.toString()));
                }
                IMemento[] minor = item.getChildren("keyword");
                HashMap<String, IMemento> map = new HashMap<String, IMemento>(minor.length);
                IMemento[] iMementoArray2 = minor;
                int n3 = minor.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento word = iMementoArray2[n4];
                    String key = word.getString("name");
                    if (map.containsKey(key)) {
                        String error = String.format(Messages.Keywords_10, key, type, version);
                        throw new ITException(String.format(format, name, error));
                    }
                    map.put(key, word);
                    ++n4;
                }
                if (this.versionsmap.containsKey(String.valueOf(type) + version)) {
                    String error = String.format(Messages.Keywords_11, type, version);
                    throw new ITException(String.format(format, name, error));
                }
                this.versionsmap.put(String.valueOf(type) + version, map);
                ++n2;
            }
        }
        catch (IOException e) {
            throw new ITException((Throwable)e);
        }
        catch (WorkbenchException e) {
            throw new ITException((Throwable)e);
        }
    }

    private TreeObject _getTree(String name, String type, String version) throws ITException {
        TreeObject tree = new TreeObject("root", "root");
        HashMap<String, IMemento> map = this.versionsmap.get(String.valueOf(type) + version);
        if (map == null) {
            throw new ITException(String.format(Messages.Keywords_14, type, version));
        }
        IMemento item = map.get(name);
        if (item == null) {
            throw new ITException(String.format(Messages.Keywords_15, name, type, version));
        }
        String protsym = item.getString("member");
        if (protsym == null) {
            throw new ITException(String.format(Messages.Keywords_17, name, type, version));
        }
        String DSECT2 = item.getString("DSECT");
        if (DSECT2 == null) {
            throw new ITException(String.format(Messages.Keywords_19, name, type, version));
        }
        String select = item.getString("select");
        protsym = String.format(Messages.Keywords_21, protsym);
        URL urlEntry = null;
        InputStream urlStream = null;
        urlEntry = this.bundle.getEntry(protsym);
        if (urlEntry == null) {
            throw new ITException(String.format(Messages.Keywords_22, protsym));
        }
        try {
            urlStream = urlEntry.openStream();
        }
        catch (IOException e) {
            throw new ITException((Throwable)e);
        }
        XMLFile xml = new XMLFile(urlStream);
        Element member = xml.getFirstMember();
        Element element = null;
        if (member == null) {
            throw new ITException(Messages.Keywords_23);
        }
        NodeList list = member.getElementsByTagName("symbols");
        if (list == null || list.getLength() == 0) {
            throw new ITException(Messages.Keywords_24);
        }
        if ((list = ((Element)list.item(0)).getElementsByTagName("pgmlabel")) == null || list.getLength() == 0) {
            throw new ITException(Messages.Keywords_25);
        }
        list = list.item(0).getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            if (element.getNodeName().equals("variables") && DSECT2.equals(element.getAttribute("name"))) {
                if (select == null) {
                    return this.buildTree(element, tree);
                }
                list = element.getChildNodes();
                int j = 0;
                while (j < list.getLength()) {
                    element = (Element)list.item(j);
                    if (select.equals(element.getAttribute("name"))) {
                        return this.buildTree(element, tree);
                    }
                    ++j;
                }
                throw new ITException(Messages.Keywords_26);
            }
            ++i;
        }
        throw new ITException(Messages.Keywords_27);
    }

    private TreeObject[] _getTrees(String protLit, String version) throws ITException {
        ArrayList<TreeObject> keywordObjects = new ArrayList<TreeObject>();
        String protsym = "PROT" + protLit + version;
        TreeObject pgmtree = new TreeObject(protsym, "root");
        protsym = String.format("keyword_metadata/%s.xml", protsym);
        URL urlEntry = null;
        InputStream urlStream = null;
        urlEntry = this.bundle.getEntry(protsym);
        if (urlEntry == null) {
            throw new ITException(String.format(Messages.Keywords_31, protsym));
        }
        try {
            urlStream = urlEntry.openStream();
        }
        catch (IOException e) {
            throw new ITException((Throwable)e);
        }
        XMLFile xml = new XMLFile(urlStream);
        Element member = xml.getFirstMember();
        Element element = null;
        if (member == null) {
            throw new ITException(Messages.Keywords_32);
        }
        NodeList list = member.getElementsByTagName("symbols");
        if (list == null || list.getLength() == 0) {
            throw new ITException(Messages.Keywords_33);
        }
        if ((list = ((Element)list.item(0)).getElementsByTagName("pgmlabel")) == null || list.getLength() == 0) {
            throw new ITException(Messages.Keywords_34);
        }
        list = list.item(0).getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            if (element.getNodeName().equals("variables")) {
                keywordObjects.add(this.buildTree(element, pgmtree));
            }
            ++i;
        }
        return keywordObjects.toArray(new TreeObject[keywordObjects.size()]);
    }

    public static TreeObject getPgmTree() {
        return pgmtree;
    }

    private TreeObject buildTree(Element child, TreeObject parent) {
        int language = 16;
        if (child == null) {
            return parent;
        }
        TreeObject current = parent;
        String type = child.getTagName();
        if (type.equals("variables")) {
            try {
                switch (language) {
                    case 32: {
                        current = new CobolVariable(child);
                        break;
                    }
                    case 16: {
                        current = new ASMVariable(child);
                        break;
                    }
                    case 128: {
                        current = new PLIVariable(child);
                        break;
                    }
                    default: {
                        current = new TreeObject(child);
                        break;
                    }
                }
            }
            catch (ITException e) {
                Logger.loggit(e);
                current = new TreeObject(child);
            }
        } else {
            current = new TreeObject(child);
        }
        parent.addChild(current);
        NodeList children = child.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.buildTree((Element)children.item(i), current);
            ++i;
        }
        return current;
    }

    public static Keywords getInstance() throws ITException {
        if (keywords == null) {
            keywords = new Keywords();
        }
        return keywords;
    }

    public static HashMap<String, IMemento> getKeywords(String type, String version) {
        try {
            return Keywords.getInstance().versionsmap.get(String.valueOf(type) + version);
        }
        catch (ITException e) {
            Logger.loggit(e);
            return null;
        }
    }

    public static TreeObject getTree(String name, String type, String version) throws ITException {
        return Keywords.getInstance()._getTree(name, type, version);
    }

    public static TreeObject[] getTrees(String type, String version) throws ITException {
        return Keywords.getInstance()._getTrees(type, version);
    }
}

